/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.service.es;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.stms.elasticSearch.entity.SewerageCollectFeeSearchRequest;
import org.egov.stms.elasticSearch.entity.SewerageConnSearchRequest;
import org.egov.stms.entity.es.SewerageIndex;
import org.egov.stms.repository.es.SewerageIndexRepository;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageIndexService {
    @Autowired
    private CityService cityService;
    @Autowired
    private SewerageIndexRepository sewerageIndexRepository;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    public SewerageIndex createSewarageIndex(SewerageApplicationDetails sewerageApplicationDetails, AssessmentDetails assessmentDetails) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        SewerageIndex sewarageIndex = new SewerageIndex();
        sewarageIndex.setUlbName(cityWebsite.getName());
        sewarageIndex.setApplicationCreatedBy(sewerageApplicationDetails.getCreatedBy().getName());
        sewarageIndex.setId(cityWebsite.getCode().concat("-").concat(sewerageApplicationDetails.getApplicationNumber()));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        sewarageIndex.setApplicationDate(this.formatDate(formatter.format(sewerageApplicationDetails.getApplicationDate())));
        sewarageIndex.setApplicationNumber(sewerageApplicationDetails.getApplicationNumber());
        sewarageIndex.setApplicationStatus(sewerageApplicationDetails.getStatus() != null ? sewerageApplicationDetails.getStatus().getDescription() : "");
        sewarageIndex.setConsumerNumber(sewerageApplicationDetails.getApplicationNumber());
        sewarageIndex.setApplicationType(sewerageApplicationDetails.getApplicationType() != null ? sewerageApplicationDetails.getApplicationType().getName() : "");
        sewarageIndex.setConnectionStatus(sewerageApplicationDetails.getConnection().getStatus() != null ? sewerageApplicationDetails.getConnection().getStatus().name() : "");
        sewarageIndex.setCreatedDate(this.formatDate(formatter.format(sewerageApplicationDetails.getCreatedDate())));
        sewarageIndex.setShscNumber(sewerageApplicationDetails.getConnection().getShscNumber() != null ? sewerageApplicationDetails.getConnection().getShscNumber() : "");
        sewarageIndex.setDisposalDate(this.formatDate(formatter.format(sewerageApplicationDetails.getDisposalDate())));
        sewarageIndex.setExecutionDate(this.formatDate(formatter.format(sewerageApplicationDetails.getConnection().getExecutionDate())));
        sewarageIndex.setIslegacy(sewerageApplicationDetails.getConnection().getLegacy());
        sewarageIndex.setNoOfClosets_nonResidential(sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential());
        sewarageIndex.setNoOfClosets_residential(sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential());
        sewarageIndex.setPropertyIdentifier(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() != null ? sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() : "");
        sewarageIndex.setPropertyType(sewerageApplicationDetails.getConnectionDetail().getPropertyType() != null ? sewerageApplicationDetails.getConnectionDetail().getPropertyType().name() : "");
        if (sewerageApplicationDetails.getEstimationDate() != null) {
            sewarageIndex.setEstimationDate(this.formatDate(formatter.format(sewerageApplicationDetails.getEstimationDate())));
        }
        sewarageIndex.setEstimationNumber(sewerageApplicationDetails.getEstimationNumber() != null ? sewerageApplicationDetails.getEstimationNumber() : "");
        if (sewerageApplicationDetails.getWorkOrderDate() != null) {
            sewarageIndex.setWorkOrderDate(this.formatDate(formatter.format(sewerageApplicationDetails.getWorkOrderDate())));
        }
        sewarageIndex.setWorkOrderNumber(sewerageApplicationDetails.getWorkOrderNumber() != null ? sewerageApplicationDetails.getWorkOrderNumber() : "");
        if (sewerageApplicationDetails.getClosureNoticeDate() != null) {
            sewarageIndex.setClosureNoticeDate(this.formatDate(formatter.format(sewerageApplicationDetails.getClosureNoticeDate())));
        }
        sewarageIndex.setClosureNoticeNumber(sewerageApplicationDetails.getClosureNoticeNumber() != null ? sewerageApplicationDetails.getClosureNoticeNumber() : "");
        Iterator ownerNameItr = null;
        if (null != assessmentDetails.getOwnerNames()) {
            ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        }
        StringBuilder consumerName = new StringBuilder();
        StringBuilder mobileNumber = new StringBuilder();
        if (null != ownerNameItr && ownerNameItr.hasNext()) {
            OwnerName primaryOwner = (OwnerName)ownerNameItr.next();
            consumerName.append(primaryOwner.getOwnerName() != null ? primaryOwner.getOwnerName() : "");
            mobileNumber.append(primaryOwner.getMobileNumber() != null ? primaryOwner.getMobileNumber() : "");
            while (ownerNameItr.hasNext()) {
                OwnerName secondaryOwner = (OwnerName)ownerNameItr.next();
                consumerName.append(",").append(secondaryOwner.getOwnerName() != null ? secondaryOwner.getOwnerName() : "");
                mobileNumber.append(",").append(secondaryOwner.getMobileNumber() != null ? secondaryOwner.getMobileNumber() : "");
            }
        }
        sewarageIndex.setMobileNumber(mobileNumber.toString());
        sewarageIndex.setConsumerName(consumerName.toString());
        sewarageIndex.setDoorNo(assessmentDetails.getHouseNo() != null ? assessmentDetails.getHouseNo() : "");
        sewarageIndex.setWard(assessmentDetails.getBoundaryDetails() != null ? assessmentDetails.getBoundaryDetails().getWardName() : "");
        sewarageIndex.setAddress(assessmentDetails.getPropertyAddress() != null ? assessmentDetails.getPropertyAddress() : "");
        sewarageIndex.setActive(sewerageApplicationDetails.isActive());
        this.sewerageIndexRepository.save(sewarageIndex);
        return sewarageIndex;
    }

    public Date formatDate(String Date2) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        try {
            return formatter.parse(Date2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public BoolQueryBuilder getQueryFilter(SewerageConnSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"active", (Object)true));
        if (StringUtils.isNotBlank((String)searchRequest.getConsumerNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerNumber", (Object)searchRequest.getConsumerNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getShscNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"shscNumber", (Object)searchRequest.getShscNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getApplicantName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerName", (Object)searchRequest.getApplicantName()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getMobileNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"mobileNumber", (Object)searchRequest.getMobileNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"revenueWard", (Object)searchRequest.getRevenueWard()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getDoorNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"doorNumber", (Object)searchRequest.getDoorNumber()));
        }
        return boolQuery;
    }

    public List<SewerageIndex> getSearchResultByBoolQuery(BoolQueryBuilder boolQuery) {
        ArrayList<SewerageIndex> resultList = new ArrayList<SewerageIndex>();
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"sewerage"}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)new FieldSortBuilder("shscNumber").order(SortOrder.DESC)).build();
        Page sewerageIndexRecords = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, SewerageIndex.class);
        for (SewerageIndex indexRecord : sewerageIndexRecords) {
            resultList.add(indexRecord);
        }
        return resultList;
    }

    public BoolQueryBuilder getSearchQueryFilter(SewerageCollectFeeSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"ulbName", (Object)searchRequest.getUlbName()));
        if (StringUtils.isNotBlank((String)searchRequest.getConsumerNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerNumber", (Object)searchRequest.getConsumerNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getShscNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"shscNumber", (Object)searchRequest.getShscNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getApplicantName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerName", (Object)searchRequest.getApplicantName()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getMobileNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"mobileNumber", (Object)searchRequest.getMobileNumber()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ward", (Object)searchRequest.getRevenueWard()));
        }
        if (StringUtils.isNotBlank((String)searchRequest.getDoorNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"doorNo", (Object)searchRequest.getDoorNumber()));
        }
        return boolQuery;
    }

    public List<SewerageIndex> getCollectSearchResult(BoolQueryBuilder boolQuery) {
        ArrayList<SewerageIndex> resultList = new ArrayList<SewerageIndex>();
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"sewerage"}).withQuery((QueryBuilder)boolQuery).withSort((SortBuilder)new FieldSortBuilder("shscNumber").order(SortOrder.DESC)).build();
        Page seweragePage = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, SewerageIndex.class);
        for (SewerageIndex index : seweragePage) {
            resultList.add(index);
        }
        return resultList;
    }
}

