/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.masters.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.stms.masters.entity.DonationDetailMaster;
import org.egov.stms.masters.entity.enums.PropertyType;

@Entity
@Table(name="egswtax_donation_master")
@SequenceGenerator(name="SEQ_EGSWTAX_DONATION_MASTER", sequenceName="SEQ_EGSWTAX_DONATION_MASTER", allocationSize=1)
public class DonationMaster
extends AbstractAuditable {
    private static final long serialVersionUID = 7892490025155232973L;
    public static final String SEQ_DONATIONMASTER = "SEQ_EGSWTAX_DONATION_MASTER";
    @Id
    @GeneratedValue(generator="SEQ_EGSWTAX_DONATION_MASTER", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    private PropertyType propertyType;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date fromDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date toDate;
    private boolean active;
    @OneToMany(mappedBy="donation", cascade={CascadeType.ALL}, fetch=FetchType.LAZY, orphanRemoval=true)
    private List<DonationDetailMaster> donationDetail = new ArrayList<DonationDetailMaster>(0);

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public List<DonationDetailMaster> getDonationDetail() {
        return this.donationDetail;
    }

    public void setDonationDetail(List<DonationDetailMaster> donationDetail) {
        this.donationDetail = donationDetail;
    }

    public void deleteDonationDetail(DonationDetailMaster donationDetail) {
        if (this.donationDetail != null) {
            this.donationDetail.remove(donationDetail);
        }
    }

    public void addDonationDetail(DonationDetailMaster donationDetail) {
        if (this.donationDetail != null) {
            this.donationDetail.add(donationDetail);
        }
    }
}

