/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.elasticSearch.service;

import java.util.Iterator;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.search.elastic.annotation.Indexing;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.stms.elasticSearch.entity.SewerageSearch;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class SewerageIndexService {
    @Autowired
    private CityService cityService;

    @Indexing(name=Index.SEWARAGE, type=IndexType.SEWARAGESEARCH)
    public SewerageSearch createSewarageIndex(SewerageApplicationDetails sewerageApplicationDetails, AssessmentDetails assessmentDetails) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        SewerageSearch sewarageSearch = new SewerageSearch(sewerageApplicationDetails.getApplicationNumber(), cityWebsite.getName(), cityWebsite.getCode(), sewerageApplicationDetails.getCreatedDate(), cityWebsite.getDistrictName(), cityWebsite.getRegionName(), cityWebsite.getGrade());
        sewarageSearch.setApplicationCreatedBy(sewerageApplicationDetails.getCreatedBy().getName());
        sewarageSearch.setApplicationDate(sewerageApplicationDetails.getApplicationDate());
        sewarageSearch.setApplicationNumber(sewerageApplicationDetails.getApplicationNumber());
        sewarageSearch.setApplicationStatus(sewerageApplicationDetails.getStatus() != null ? sewerageApplicationDetails.getStatus().getDescription() : "");
        sewarageSearch.setConsumerNumber(sewerageApplicationDetails.getApplicationNumber());
        sewarageSearch.setApplicationType(sewerageApplicationDetails.getApplicationType() != null ? sewerageApplicationDetails.getApplicationType().getName() : "");
        sewarageSearch.setConnectionStatus(sewerageApplicationDetails.getConnection().getStatus() != null ? sewerageApplicationDetails.getConnection().getStatus().name() : "");
        sewarageSearch.setCreatedDate(sewerageApplicationDetails.getCreatedDate());
        sewarageSearch.setShscNumber(sewerageApplicationDetails.getConnection().getShscNumber() != null ? sewerageApplicationDetails.getConnection().getShscNumber() : "");
        sewarageSearch.setDisposalDate(sewerageApplicationDetails.getDisposalDate());
        sewarageSearch.setExecutionDate(sewerageApplicationDetails.getConnection().getExecutionDate());
        sewarageSearch.setIslegacy(sewerageApplicationDetails.getConnection().getLegacy());
        sewarageSearch.setNoOfClosets_nonResidential(sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsNonResidential());
        sewarageSearch.setNoOfClosets_residential(sewerageApplicationDetails.getConnectionDetail().getNoOfClosetsResidential());
        sewarageSearch.setPropertyIdentifier(sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() != null ? sewerageApplicationDetails.getConnectionDetail().getPropertyIdentifier() : "");
        sewarageSearch.setPropertyType(sewerageApplicationDetails.getConnectionDetail().getPropertyType() != null ? sewerageApplicationDetails.getConnectionDetail().getPropertyType().name() : "");
        sewarageSearch.setEstimationDate(sewerageApplicationDetails.getEstimationDate());
        sewarageSearch.setEstimationNumber(sewerageApplicationDetails.getEstimationNumber() != null ? sewerageApplicationDetails.getEstimationNumber() : "");
        sewarageSearch.setWorkOrderDate(sewerageApplicationDetails.getWorkOrderDate());
        sewarageSearch.setWorkOrderNumber(sewerageApplicationDetails.getWorkOrderNumber() != null ? sewerageApplicationDetails.getWorkOrderNumber() : "");
        sewarageSearch.setClosureNoticeDate(sewerageApplicationDetails.getClosureNoticeDate());
        sewarageSearch.setClosureNoticeNumber(sewerageApplicationDetails.getClosureNoticeNumber() != null ? sewerageApplicationDetails.getClosureNoticeNumber() : "");
        Iterator ownerNameItr = null;
        if (null != assessmentDetails.getOwnerNames()) {
            ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        }
        StringBuilder consumerName = new StringBuilder();
        StringBuilder mobileNumber = new StringBuilder();
        if (null != ownerNameItr && ownerNameItr.hasNext()) {
            OwnerName primaryOwner = (OwnerName)ownerNameItr.next();
            consumerName.append(primaryOwner.getOwnerName() != null ? primaryOwner.getOwnerName() : "");
            mobileNumber.append(primaryOwner.getMobileNumber() != null ? primaryOwner.getMobileNumber() : "");
            while (ownerNameItr.hasNext()) {
                OwnerName secondaryOwner = (OwnerName)ownerNameItr.next();
                consumerName.append(",").append(secondaryOwner.getOwnerName() != null ? secondaryOwner.getOwnerName() : "");
                mobileNumber.append(",").append(secondaryOwner.getMobileNumber() != null ? secondaryOwner.getMobileNumber() : "");
            }
        }
        sewarageSearch.setMobileNumber(mobileNumber.toString());
        sewarageSearch.setConsumerName(consumerName.toString());
        sewarageSearch.setDoorNo(assessmentDetails.getHouseNo() != null ? assessmentDetails.getHouseNo() : "");
        sewarageSearch.setWard(assessmentDetails.getBoundaryDetails() != null ? assessmentDetails.getBoundaryDetails().getWardName() : "");
        sewarageSearch.setAddress(assessmentDetails.getPropertyAddress() != null ? assessmentDetails.getPropertyAddress() : "");
        sewarageSearch.setIsActive(sewerageApplicationDetails.isActive());
        return sewarageSearch;
    }
}

