/*
 * Decompiled with CFR 0.152.
 */
package org.egov.stms.autonumber.impl;

import java.io.Serializable;
import org.egov.infra.persistence.utils.ApplicationSequenceNumberGenerator;
import org.egov.stms.autonumber.SewerageDemandBillNumberGenerator;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.utils.SewerageTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SewerageDemandBillNumberGeneratorImpl
implements SewerageDemandBillNumberGenerator {
    private static final String DEMANDBILL_NUMBER_SEQ_PREFIX = "SEQ_EGSWTAX_DEMANDBILL_NUMBER";
    @Autowired
    private ApplicationSequenceNumberGenerator applicationSequenceNumberGenerator;
    @Autowired
    private SewerageTaxUtils sewerageTaxUtils;

    @Override
    @Transactional
    public String generateSewerageDemandBillNumber(SewerageApplicationDetails sewerageApplicationDetails) {
        String sequenceName = DEMANDBILL_NUMBER_SEQ_PREFIX;
        Serializable nextsequence = this.applicationSequenceNumberGenerator.getNextSequence(DEMANDBILL_NUMBER_SEQ_PREFIX);
        return String.format("%s%06d", this.sewerageTaxUtils.getCityCode(), nextsequence);
    }
}

