/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.zuulproxy.listeners;

import com.netflix.zuul.DynamicCodeCompiler;
import com.netflix.zuul.FilterFileManager;
import com.netflix.zuul.FilterLoader;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.filters.FilterRegistry;
import com.netflix.zuul.groovy.GroovyCompiler;
import com.netflix.zuul.groovy.GroovyFileFilter;
import com.netflix.zuul.monitoring.MonitoringHelper;
import java.io.File;
import java.io.FilenameFilter;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.egov.services.zuulproxy.filter.ZuulProxyFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZuulProxyStartServerListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(ZuulProxyStartServerListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        if (logger.isInfoEnabled()) {
            logger.info("Starting Zuul Proxy server");
        }
        MonitoringHelper.initMocks();
        this.initGroovyFilterManager();
        this.initJavaFilters();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (logger.isInfoEnabled()) {
            logger.info("Stopping Zuul Proxy server");
        }
    }

    private void initGroovyFilterManager() {
        block3: {
            FilterLoader.getInstance().setCompiler((DynamicCodeCompiler)new GroovyCompiler());
            String scriptRoot = System.getProperty("zuul.filter.root", "groovy/filters");
            if (scriptRoot.length() > 0 && !scriptRoot.endsWith("/")) {
                scriptRoot = scriptRoot + File.separator;
            }
            try {
                FilterFileManager.setFilenameFilter((FilenameFilter)new GroovyFileFilter());
                FilterFileManager.init((int)5, (String[])new String[]{scriptRoot + "route", scriptRoot + "post"});
            }
            catch (Exception e) {
                if (!logger.isErrorEnabled()) break block3;
                logger.error("Error reading Groovy filters for zuul proxy... " + e.getMessage());
            }
        }
    }

    private void initJavaFilters() {
        FilterRegistry r = FilterRegistry.instance();
        r.put("javaPreFilter", (ZuulFilter)new ZuulProxyFilter());
    }
}

