/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.config.properties;

import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;

@Configuration
@PropertySource(name="servicesApplicationProperties", value={"classpath:config/application-config-services.properties", "classpath:config/egov-erp-${user.name}.properties", "classpath:config/application-config-${client.id}.properties", "classpath:config/egov-erp-override.properties"}, ignoreResourceNotFound=true)
public class ServicesApplicationProperties {
    private static final String ZUUL_PROXY_ROUTING_URLS_MAPPING = "zuul.proxy.routing.urls";
    @Autowired
    private Environment environment;

    public Map<String, String> zuulProxyRoutingUrls() {
        HashMap<String, String> routingUrlsKeyValuePair = new HashMap<String, String>();
        String[] routingUrls = this.environment.getProperty(ZUUL_PROXY_ROUTING_URLS_MAPPING).split(",");
        if (routingUrls != null && routingUrls.length > 0) {
            for (String mappingUrl : routingUrls) {
                String[] url = mappingUrl.split("~");
                routingUrlsKeyValuePair.put(url[0], url[1]);
            }
        }
        return routingUrlsKeyValuePair;
    }
}

