/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.zuulproxy.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.security.authentication.SecureUser;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.services.config.properties.ServicesApplicationProperties;
import org.egov.services.zuulproxy.models.Role;
import org.egov.services.zuulproxy.models.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class ZuulProxyFilter
extends ZuulFilter {
    private static Logger log = LoggerFactory.getLogger(ZuulProxyFilter.class);
    private static final String USER_INFO = "x-user-info";

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 1;
    }

    public boolean shouldFilter() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth != null;
    }

    public Object run() {
        HashMap zuulProxyRoutingUrls;
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        WebApplicationContext springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getServletContext());
        ServicesApplicationProperties applicationProperties = (ServicesApplicationProperties)springContext.getBean("servicesApplicationProperties");
        try {
            zuulProxyRoutingUrls = (HashMap)applicationProperties.zuulProxyRoutingUrls();
            if (log.isInfoEnabled()) {
                log.info("Zuul Proxy Routing Mapping Urls... " + zuulProxyRoutingUrls);
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Could not get valid routing url mapping for mirco services", (Throwable)e);
        }
        try {
            URL requestURL = new URL(request.getRequestURL().toString());
            String endPointURI = requestURL.getPath().startsWith("/services") ? requestURL.getPath().split("/services")[1] : requestURL.getPath();
            String mappingURL = "";
            for (Map.Entry entry : zuulProxyRoutingUrls.entrySet()) {
                String key = (String)entry.getKey();
                if (!endPointURI.contains(key)) continue;
                mappingURL = (String)entry.getValue();
                break;
            }
            if (log.isInfoEnabled()) {
                log.info(String.format("%s request to the url %s", request.getMethod(), request.getRequestURL().toString()));
            }
            if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{request.getQueryString()})) {
                endPointURI = endPointURI + "?" + request.getQueryString();
            }
            URL routedHost = new URL(mappingURL + endPointURI);
            ctx.setRouteHost(routedHost);
            ctx.set("requestURI", (Object)routedHost.getPath());
            ctx.addZuulRequestHeader(USER_INFO, this.getUserInfo(request, springContext));
        }
        catch (MalformedURLException e) {
            throw new ApplicationRuntimeException("Could not form valid URL", (Throwable)e);
        }
        return null;
    }

    private String getUserInfo(HttpServletRequest request, WebApplicationContext springContext) {
        HttpSession session = request.getSession();
        String userInfoJson = "";
        if (session.getAttribute(USER_INFO) != null) {
            userInfoJson = session.getAttribute(USER_INFO).toString();
        }
        if (log.isInfoEnabled()) {
            log.info("x-user-info is from the session... " + userInfoJson);
        }
        if (StringUtils.isBlank((String)userInfoJson)) {
            UserService userService = (UserService)springContext.getBean("userService");
            SecureUser userDetails = new SecureUser(userService.getUserByUsername(request.getRemoteUser()));
            User user = userDetails.getUser();
            ArrayList roles = new ArrayList();
            userDetails.getUser().getRoles().forEach(authority -> roles.add(new Role(authority.getName())));
            UserInfo userInfo = new UserInfo(roles, userDetails.getUserId(), userDetails.getUsername(), user.getName(), user.getEmailId(), user.getMobileNumber(), userDetails.getUserType().toString());
            ObjectMapper mapper = new ObjectMapper();
            try {
                userInfoJson = mapper.writeValueAsString((Object)userInfo);
            }
            catch (JsonProcessingException e) {
                throw new ApplicationRuntimeException("Could not convert object to json string", (Throwable)e);
            }
            if (log.isInfoEnabled()) {
                log.info("Read x-user-info from the DB and set it to the session... " + userInfoJson);
            }
            session.setAttribute(USER_INFO, (Object)userInfoJson);
        }
        return userInfoJson;
    }
}

