/*
 * Decompiled with CFR 0.152.
 */
package org.egov.services.zuulproxy.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.util.HTTPRequestUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.security.authentication.SecureUser;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.services.config.properties.ServicesApplicationProperties;
import org.egov.services.wrapper.CustomRequestWrapper;
import org.egov.services.zuulproxy.models.Role;
import org.egov.services.zuulproxy.models.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZuulProxyFilter
extends ZuulFilter {
    private static Logger log = LoggerFactory.getLogger(ZuulProxyFilter.class);
    private static final String PRE = "pre";
    private static final String CLIENT_ID = "client.id";
    private static final String GET = "GET";
    private static final String FILESTORE_REGEX = "(.*)filestore(.*)";
    private static final String REQUEST_INFO_FIELD_NAME = "RequestInfo";
    private static final String USER_INFO_FIELD_NAME = "userInfo";
    private static final String SERVICES_CONTEXTROOT = "/services";
    private static final String REQUEST_URI = "requestURI";
    private static final String SERVICES_APPLICATION_PROPERTIES = "servicesApplicationProperties";
    private static final String USER_SERVICE = "userService";
    private static final String ENVIRONMENT = "environment";
    private static final String TENANT_ID = "tenantId";
    private ObjectMapper mapper;

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 1;
    }

    public boolean shouldFilter() {
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        return auth != null;
    }

    public Object run() {
        HashMap zuulProxyRoutingUrls;
        this.mapper = new ObjectMapper();
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        WebApplicationContext springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getServletContext());
        ServicesApplicationProperties applicationProperties = (ServicesApplicationProperties)springContext.getBean("servicesApplicationProperties");
        try {
            zuulProxyRoutingUrls = (HashMap)applicationProperties.zuulProxyRoutingUrls();
            if (log.isInfoEnabled()) {
                log.info("Zuul Proxy Routing Mapping Urls... " + zuulProxyRoutingUrls);
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Could not get valid routing url mapping for mirco services", (Throwable)e);
        }
        try {
            URL requestURL = new URL(request.getRequestURL().toString());
            String endPointURI = requestURL.getPath().startsWith("/services") ? requestURL.getPath().split("/services")[1] : requestURL.getPath();
            String mappingURL = "";
            for (Map.Entry entry : zuulProxyRoutingUrls.entrySet()) {
                String key = (String)entry.getKey();
                if (!endPointURI.contains(key)) continue;
                mappingURL = (String)entry.getValue();
                break;
            }
            if (log.isInfoEnabled()) {
                log.info(String.format("%s request to the url %s", request.getMethod(), request.getRequestURL().toString()));
            }
            String tenantId = this.getTanentId(springContext);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(endPointURI).append('?').append(ZuulProxyFilter.updateQueryString((String)request.getQueryString(), (String)"tenantId", (String)tenantId));
            endPointURI = stringBuilder.toString();
            if (log.isInfoEnabled()) {
                log.info("endPointURI  " + endPointURI);
            }
            URL routedHost = new URL(mappingURL + endPointURI);
            ctx.setRouteHost(routedHost);
            ctx.set("requestURI", (Object)routedHost.getPath());
            Map map = HTTPRequestUtils.getInstance().getQueryParams();
            if (map == null) {
                RequestContext.getCurrentContext().setRequestQueryParams(new HashMap());
                map = HTTPRequestUtils.getInstance().getQueryParams();
            }
            map.put("tenantId", Arrays.asList(tenantId));
            ctx.setRequestQueryParams(map);
            if (log.isInfoEnabled()) {
                log.info("TenantId from getRequestQueryParams() " + ((List)ctx.getRequestQueryParams().get("tenantId")).toString());
            }
            String userInfo = this.getUserInfo(request, springContext, tenantId);
            if (this.shouldPutUserInfoOnHeaders(ctx)) {
                ctx.addZuulRequestHeader("userInfo", userInfo);
            } else {
                this.appendUserInfoToRequestBody(ctx, userInfo);
            }
        }
        catch (MalformedURLException e) {
            throw new ApplicationRuntimeException("Could not form valid URL", (Throwable)e);
        }
        catch (IOException ex) {
            ctx.setSendZuulResponse(false);
            throw new ApplicationRuntimeException("Problem while setting RequestInfo..", (Throwable)ex);
        }
        return null;
    }

    private boolean shouldPutUserInfoOnHeaders(RequestContext ctx) {
        return Objects.equals(ctx.getRequest().getMethod().toUpperCase(), "GET") || ctx.getRequest().getRequestURI().matches("(.*)filestore(.*)");
    }

    private void appendUserInfoToRequestBody(RequestContext ctx, String userInfoJson) throws IOException {
        HashMap requestBody = this.getRequestBody(ctx);
        HashMap requestInfo = (HashMap)requestBody.get("RequestInfo");
        UserInfo userInfo = (UserInfo)this.mapper.readValue(userInfoJson, UserInfo.class);
        requestInfo.put("userInfo", userInfo);
        requestBody.put("RequestInfo", requestInfo);
        CustomRequestWrapper requestWrapper = new CustomRequestWrapper(ctx.getRequest());
        requestWrapper.setPayload(this.mapper.writeValueAsString((Object)requestBody));
        ctx.setRequest((HttpServletRequest)requestWrapper);
    }

    private HashMap<String, Object> getRequestBody(RequestContext ctx) throws IOException {
        String payload = IOUtils.toString((InputStream)ctx.getRequest().getInputStream());
        return (HashMap)this.mapper.readValue(payload, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    private String getUserInfo(HttpServletRequest request, WebApplicationContext springContext, String tenantId) {
        HttpSession session = request.getSession();
        String userInfoJson = null;
        if (session.getAttribute("userInfo") != null) {
            userInfoJson = session.getAttribute("userInfo").toString();
        }
        if (log.isInfoEnabled()) {
            log.info("userInfo is from the session... " + userInfoJson);
        }
        if (StringUtils.isBlank((CharSequence)userInfoJson)) {
            UserService userService = (UserService)springContext.getBean("userService");
            SecureUser userDetails = new SecureUser(userService.getUserByUsername(request.getRemoteUser()));
            User user = userDetails.getUser();
            ArrayList roles = new ArrayList();
            userDetails.getUser().getRoles().forEach(authority -> roles.add(new Role(authority.getName())));
            UserInfo userInfo = new UserInfo(roles, userDetails.getUserId(), userDetails.getUsername(), user.getName(), user.getEmailId(), user.getMobileNumber(), userDetails.getUserType().toString(), tenantId);
            ObjectMapper mapper = new ObjectMapper();
            try {
                userInfoJson = mapper.writeValueAsString((Object)userInfo);
            }
            catch (JsonProcessingException e) {
                throw new ApplicationRuntimeException("Could not convert object to json string", (Throwable)e);
            }
            if (log.isInfoEnabled()) {
                log.info("Read userInfo from the DB and set it to the session... " + userInfoJson);
            }
            session.setAttribute("userInfo", (Object)userInfoJson);
        }
        return userInfoJson;
    }

    private String getTanentId(WebApplicationContext springContext) {
        Environment environment = (Environment)springContext.getBean("environment");
        String clientId = environment.getProperty("client.id");
        String tenantId = ApplicationThreadLocals.getTenantID();
        if (StringUtils.isNotBlank((CharSequence)clientId)) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(clientId).append('.').append(tenantId);
            tenantId = stringBuilder.toString();
        }
        return tenantId;
    }

    private static String updateQueryString(String queryString, String name, String value) {
        String updatedQueryString = null;
        if (queryString != null) {
            updatedQueryString = queryString.replaceAll(name + "=.*?($|&)", "").replaceFirst("&$", "");
        }
        return ZuulProxyFilter.addParameter(updatedQueryString, (String)name, (String)value);
    }

    public static String addParameter(String queryString, String name, String value) {
        return StringUtils.isEmpty((CharSequence)queryString) ? name + "=" + value : queryString + "&" + name + "=" + value;
    }
}

