/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.dcb.bean.ChequePayment;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.entity.property.vacantland.LayoutApprovalAuthority;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.FloorDetails;
import org.egov.ptis.domain.model.NewPropertyDetails;
import org.egov.ptis.domain.model.ViewPropertyDetails;
import org.egov.ptis.domain.repository.master.vacantland.LayoutApprovalAuthorityRepository;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.restapi.model.AmenitiesDetails;
import org.egov.restapi.model.AssessmentsDetails;
import org.egov.restapi.model.ConstructionTypeDetails;
import org.egov.restapi.model.CreatePropertyDetails;
import org.egov.restapi.model.SurroundingBoundaryDetails;
import org.egov.restapi.model.VacantLandDetails;
import org.egov.restapi.util.ValidationUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UpdateAssessmentController {
    private static final String NO_APPROVAL = "No Approval";
    @Autowired
    private ValidationUtil validationUtil;
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private LayoutApprovalAuthorityRepository layoutApprovalAuthorityRepo;

    @RequestMapping(value={"/property/updateProperty"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public NewPropertyDetails updateProperty(@RequestBody String createPropertyDetails) throws IOException, ParseException {
        NewPropertyDetails newPropertyDetails;
        ApplicationThreadLocals.setUserId((Long)2L);
        CreatePropertyDetails createPropDetails = (CreatePropertyDetails)this.getObjectFromJSONRequest(createPropertyDetails, CreatePropertyDetails.class);
        ErrorDetails errorDetails = this.validationUtil.validateUpdateRequest(createPropDetails, "modify");
        if (errorDetails != null && errorDetails.getErrorCode() != null) {
            newPropertyDetails = new NewPropertyDetails();
            newPropertyDetails.setReferenceId(createPropDetails.getReferenceId());
            newPropertyDetails.setApplicationNo("-1");
            newPropertyDetails.setErrorDetails(errorDetails);
        } else {
            ViewPropertyDetails viewPropertyDetails = this.setRequestParameters(createPropDetails);
            newPropertyDetails = this.propertyExternalService.updateProperty(viewPropertyDetails);
        }
        return newPropertyDetails;
    }

    public ViewPropertyDetails setRequestParameters(CreatePropertyDetails createPropDetails) {
        AmenitiesDetails amenities;
        ViewPropertyDetails viewPropertyDetails = new ViewPropertyDetails();
        viewPropertyDetails.setAssessmentNumber(createPropDetails.getAssessmentNumber());
        viewPropertyDetails.setPropertyTypeMaster(createPropDetails.getPropertyTypeMasterCode());
        viewPropertyDetails.setCategory(createPropDetails.getCategoryCode());
        AssessmentsDetails assessmentDetails = createPropDetails.getAssessmentDetails();
        if (assessmentDetails != null) {
            viewPropertyDetails.setMutationReason(assessmentDetails.getMutationReasonCode());
            viewPropertyDetails.setExtentOfSite(assessmentDetails.getExtentOfSite());
            viewPropertyDetails.setOccupancyCertificationNo(assessmentDetails.getOccupancyCertificationNo());
            viewPropertyDetails.setOccupancyCertificationDate(assessmentDetails.getOccupancyCertificationDate());
            viewPropertyDetails.setExtentAppartenauntLand(assessmentDetails.getExtentAppartenauntLand());
        }
        if ((amenities = createPropDetails.getAmenitiesDetails()) != null) {
            viewPropertyDetails.setHasLift(amenities.hasLift());
            viewPropertyDetails.setHasToilet(amenities.hasToilet());
            viewPropertyDetails.setHasWaterTap(amenities.hasWaterTap());
            viewPropertyDetails.setHasElectricity(amenities.hasElectricity());
            viewPropertyDetails.setHasAttachedBathroom(amenities.hasAttachedBathroom());
            viewPropertyDetails.setHasWaterHarvesting(amenities.hasWaterHarvesting());
            viewPropertyDetails.setHasCableConnection(amenities.hasCableConnection());
        } else {
            viewPropertyDetails.setHasLift(Boolean.valueOf(false));
            viewPropertyDetails.setHasToilet(Boolean.valueOf(false));
            viewPropertyDetails.setHasWaterTap(Boolean.valueOf(false));
            viewPropertyDetails.setHasElectricity(Boolean.valueOf(false));
            viewPropertyDetails.setHasAttachedBathroom(Boolean.valueOf(false));
            viewPropertyDetails.setHasWaterHarvesting(Boolean.valueOf(false));
            viewPropertyDetails.setHasCableConnection(Boolean.valueOf(false));
        }
        ConstructionTypeDetails constructionTypeDetails = createPropDetails.getConstructionTypeDetails();
        if (constructionTypeDetails != null) {
            viewPropertyDetails.setFloorType(constructionTypeDetails.getFloorTypeId());
            viewPropertyDetails.setRoofType(constructionTypeDetails.getRoofTypeId());
            viewPropertyDetails.setWallType(constructionTypeDetails.getWallTypeId());
            viewPropertyDetails.setWoodType(constructionTypeDetails.getWoodTypeId());
        } else {
            viewPropertyDetails.setFloorType(null);
            viewPropertyDetails.setRoofType(null);
            viewPropertyDetails.setWallType(null);
            viewPropertyDetails.setWoodType(null);
        }
        if (createPropDetails.getPropertyTypeMasterCode().equalsIgnoreCase("VAC_LAND")) {
            VacantLandDetails vacantLandDetails = createPropDetails.getVacantLandDetails();
            viewPropertyDetails.setSurveyNumber(vacantLandDetails.getSurveyNumber());
            viewPropertyDetails.setPattaNumber(vacantLandDetails.getPattaNumber());
            viewPropertyDetails.setVacantLandArea(vacantLandDetails.getVacantLandArea());
            viewPropertyDetails.setMarketValue(vacantLandDetails.getMarketValue());
            viewPropertyDetails.setCurrentCapitalValue(vacantLandDetails.getCurrentCapitalValue());
            viewPropertyDetails.setEffectiveDate(vacantLandDetails.getEffectiveDate());
            viewPropertyDetails.setVlPlotArea(vacantLandDetails.getVacantLandPlot());
            viewPropertyDetails.setLaAuthority(vacantLandDetails.getLayoutApprovalAuthority());
            if (!NO_APPROVAL.equals(((LayoutApprovalAuthority)this.layoutApprovalAuthorityRepo.findOne((Serializable)vacantLandDetails.getLayoutApprovalAuthority())).getName())) {
                viewPropertyDetails.setLpNo(vacantLandDetails.getLayoutPermitNumber());
                viewPropertyDetails.setLpDate(vacantLandDetails.getLayoutPermitDate());
            }
            SurroundingBoundaryDetails surroundingBoundaryDetails = createPropDetails.getSurroundingBoundaryDetails();
            viewPropertyDetails.setNorthBoundary(surroundingBoundaryDetails.getNorthBoundary());
            viewPropertyDetails.setSouthBoundary(surroundingBoundaryDetails.getSouthBoundary());
            viewPropertyDetails.setEastBoundary(surroundingBoundaryDetails.getEastBoundary());
            viewPropertyDetails.setWestBoundary(surroundingBoundaryDetails.getWestBoundary());
        } else {
            viewPropertyDetails.setFloorDetails(createPropDetails.getFloorDetails());
            viewPropertyDetails.setEffectiveDate(((FloorDetails)createPropDetails.getFloorDetails().get(0)).getOccupancyDate());
        }
        viewPropertyDetails.setParcelId(createPropDetails.getParcelId());
        viewPropertyDetails.setReferenceId(createPropDetails.getReferenceId());
        viewPropertyDetails.setLatitude(createPropDetails.getLatitude());
        viewPropertyDetails.setLongitude(createPropDetails.getLongitude());
        return viewPropertyDetails;
    }

    private Object getObjectFromJSONRequest(String jsonString, Class cls) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        mapper.setDateFormat((DateFormat)ChequePayment.CHEQUE_DATE_FORMAT);
        return mapper.readValue(jsonString, cls);
    }
}

