/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.commons.Bank;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.restapi.util.JsonConvertor;
import org.egov.stms.entity.PaySewerageTaxDetails;
import org.egov.stms.entity.SewerageReceiptDetails;
import org.egov.stms.entity.SewerageTaxDetails;
import org.egov.stms.entity.SewerageTaxPaidDetails;
import org.egov.stms.masters.entity.enums.SewerageConnectionStatus;
import org.egov.stms.transactions.entity.SewerageApplicationDetails;
import org.egov.stms.transactions.service.SewerageApplicationDetailsService;
import org.egov.stms.transactions.service.SewerageDemandService;
import org.egov.stms.transactions.service.SewerageThirdPartyServices;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SewerageCollectionController {
    @Autowired
    private SewerageApplicationDetailsService sewerageApplicationDetailsService;
    @Autowired
    private SewerageThirdPartyServices sewerageThirdPartyServices;
    @Autowired
    private SewerageDemandService sewerageDemandService;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;

    @RequestMapping(value={"/sewerage/payseweragetax"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String paySewerageTax(@Valid @RequestBody PaySewerageTaxDetails paySewerageTaxDetails, HttpServletRequest request) {
        SewerageReceiptDetails sewerageReceiptDetails = null;
        try {
            ErrorDetails errorDetails = this.validatePaymentDetails(paySewerageTaxDetails);
            if (null != errorDetails) {
                return JsonConvertor.convert((Object)errorDetails);
            }
            paySewerageTaxDetails.setSource(request.getSession().getAttribute("source") != null ? request.getSession().getAttribute("source").toString() : "");
            sewerageReceiptDetails = this.sewerageThirdPartyServices.paySewerageTax(paySewerageTaxDetails, request);
        }
        catch (ValidationException e) {
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            List errors = e.getErrors();
            for (ValidationError ve : errors) {
                ErrorDetails er = new ErrorDetails();
                er.setErrorCode(ve.getKey());
                er.setErrorMessage(ve.getMessage());
                errorList.add(er);
            }
            JsonConvertor.convert(errorList);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            ErrorDetails er = new ErrorDetails();
            er.setErrorCode(e.getMessage());
            er.setErrorMessage(e.getMessage());
            errorList.add(er);
            JsonConvertor.convert(errorList);
        }
        return JsonConvertor.convert((Object)sewerageReceiptDetails);
    }

    public ErrorDetails validatePaymentDetails(PaySewerageTaxDetails paySewerageTaxDetails) {
        BillReceiptInfo billReceipt;
        SewerageApplicationDetails sewerageApplicationDtlObject = null;
        ErrorDetails errorDetails = this.validateConsumerAndApplicationNumber(paySewerageTaxDetails);
        if (paySewerageTaxDetails.getApplicaionNumber() != null && !"".equals(paySewerageTaxDetails.getApplicaionNumber())) {
            sewerageApplicationDtlObject = this.sewerageApplicationDetailsService.findByApplicationNumber(paySewerageTaxDetails.getApplicaionNumber());
        } else if (paySewerageTaxDetails.getConsumerNo() != null) {
            sewerageApplicationDtlObject = this.sewerageApplicationDetailsService.findByConnectionShscNumberAndConnectionStatus(paySewerageTaxDetails.getConsumerNo(), SewerageConnectionStatus.ACTIVE);
        }
        if (sewerageApplicationDtlObject == null) {
            sewerageApplicationDtlObject = this.sewerageApplicationDetailsService.findByConnectionShscNumberAndConnectionStatus(paySewerageTaxDetails.getConsumerNo(), SewerageConnectionStatus.INACTIVE);
            if (sewerageApplicationDtlObject != null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("WCMS-REST-14");
                errorDetails.setErrorMessage("Consumer number is InActive");
            } else {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("WCMS-REST-8");
                errorDetails.setErrorMessage("Either ConsumerCode is not valid or ApplicationNumber not valid");
            }
        } else {
            EgDemand sewerageDemand;
            BigDecimal totalAmt = BigDecimal.ZERO;
            if (sewerageApplicationDtlObject != null && sewerageApplicationDtlObject.getConnection().getStatus().equals((Object)SewerageConnectionStatus.ACTIVE) && (sewerageDemand = sewerageApplicationDtlObject.getCurrentDemand()) != null) {
                for (EgDemandDetails demandDtl : sewerageDemand.getEgDemandDetails()) {
                    if (!demandDtl.getEgDemandReason().getEgDemandReasonMaster().getCode().equalsIgnoreCase("SEWERAGETAX") || demandDtl.getAmount().compareTo(demandDtl.getAmtCollected() == null ? BigDecimal.ZERO : demandDtl.getAmtCollected()) <= 0) continue;
                    totalAmt = totalAmt.add(demandDtl.getAmount().subtract(demandDtl.getAmtCollected() == null ? BigDecimal.ZERO : demandDtl.getAmtCollected()));
                }
            }
            if (totalAmt.compareTo(BigDecimal.ZERO) > 0) {
                if (totalAmt.compareTo(paySewerageTaxDetails.getTotalAmount()) < 0) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("STMS-REST-2");
                    errorDetails.setErrorMessage("Payment amount should be less than demand amount");
                }
            } else if (totalAmt.compareTo(BigDecimal.ZERO) == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("STMS-REST-1");
                errorDetails.setErrorMessage("There is no tax pending for selected ApplicationNumber");
            }
        }
        if (paySewerageTaxDetails.getTransactionId() == null || "".equals(paySewerageTaxDetails.getTransactionId())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-25");
            errorDetails.setErrorMessage("Invalid Request, No transaction ID is associated");
        } else if (!(paySewerageTaxDetails.getTransactionId() == null && "".equals(paySewerageTaxDetails.getTransactionId()) || (billReceipt = this.sewerageThirdPartyServices.validateTransanctionIdPresent(paySewerageTaxDetails.getTransactionId())) == null)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-26");
            errorDetails.setErrorMessage("Invalid Request, Used transaction ID is associated");
        }
        if (paySewerageTaxDetails.getPaymentMode() == null || paySewerageTaxDetails.getPaymentMode().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-13");
            errorDetails.setErrorMessage("Payment mode is required");
        } else if (!("CASH".equalsIgnoreCase(paySewerageTaxDetails.getPaymentMode().trim()) || "CHEQUE".equalsIgnoreCase(paySewerageTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(paySewerageTaxDetails.getPaymentMode().trim()))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-14");
            errorDetails.setErrorMessage("Payment mode is invalid");
        }
        if (paySewerageTaxDetails.getPaymentMode() != null && ("CHEQUE".equalsIgnoreCase(paySewerageTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(paySewerageTaxDetails.getPaymentMode().trim()))) {
            if (paySewerageTaxDetails.getChqddNo() == null || paySewerageTaxDetails.getChqddNo().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-34");
                errorDetails.setErrorMessage("Cheque/DD number is required");
            } else if (paySewerageTaxDetails.getChqddDate() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-35");
                errorDetails.setErrorMessage("Cheque/DD Date is required");
            } else if (paySewerageTaxDetails.getBankName() == null || paySewerageTaxDetails.getBankName().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-36");
                errorDetails.setErrorMessage("Bank Name is required");
            } else if (paySewerageTaxDetails.getBranchName() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-37");
                errorDetails.setErrorMessage("Branch Name  is required");
            } else if (!this.validateBank(paySewerageTaxDetails.getBankName()).booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("STMS-REST-3");
                errorDetails.setErrorMessage("Bank Name is not a valid.");
            }
        }
        return errorDetails;
    }

    private Boolean validateBank(String bankCodeOrName) {
        Bank bank = this.bankHibernateDAO.getBankByCode(bankCodeOrName);
        return bank != null;
    }

    @RequestMapping(value={"/sewerage/getseweragedetails"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getSewerageTaxDetailsByAppLicationOrConsumerNumber(@Valid @RequestBody PaySewerageTaxDetails paySewerageTaxDetails) throws IOException, BindException {
        ErrorDetails errorDetails = this.validateConsumerAndApplicationNumber(paySewerageTaxDetails);
        if (null != errorDetails) {
            return JsonConvertor.convert((Object)errorDetails);
        }
        SewerageTaxDetails sewerageTaxDetails = this.sewerageDemandService.getSeweragTaxeDemandDetails(paySewerageTaxDetails);
        return JsonConvertor.convert((Object)this.getSewerageTaxDetails(sewerageTaxDetails));
    }

    private ErrorDetails validateConsumerAndApplicationNumber(PaySewerageTaxDetails paySewerageTaxDetails) {
        ErrorDetails errorDetails = null;
        if (paySewerageTaxDetails.getConsumerNo() == null || paySewerageTaxDetails.getConsumerNo().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-12");
            errorDetails.setErrorMessage("Cosumer Code is required");
        } else if (paySewerageTaxDetails.getConsumerNo().trim().length() > 0 && paySewerageTaxDetails.getConsumerNo().trim().length() < 10) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-9");
            errorDetails.setErrorMessage("Consumer number length can not less than 10 digits");
        }
        if (paySewerageTaxDetails.getConsumerNo() == null && paySewerageTaxDetails.getApplicaionNumber() == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-13");
            errorDetails.setErrorMessage("Either Cosumer Code or Application number is required");
        } else if (paySewerageTaxDetails.getApplicaionNumber() != null && paySewerageTaxDetails.getApplicaionNumber().trim().length() > 0 && paySewerageTaxDetails.getApplicaionNumber().trim().length() < 13) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-10");
            errorDetails.setErrorMessage("Application number length can not less than 13 digits");
        }
        SewerageApplicationDetails sewerageApplicationDetails = null;
        if (paySewerageTaxDetails.getConsumerNo() != null) {
            sewerageApplicationDetails = this.sewerageApplicationDetailsService.findByConnectionShscNumberAndConnectionStatus(paySewerageTaxDetails.getConsumerNo(), SewerageConnectionStatus.INACTIVE);
        }
        if (sewerageApplicationDetails != null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WCMS-REST-14");
            errorDetails.setErrorMessage("Consumer number is InActive");
        }
        return errorDetails;
    }

    private SewerageTaxDetails getSewerageTaxDetails(SewerageTaxDetails sewerageTaxDetails) {
        if (sewerageTaxDetails.getConsumerNo() == null || "".equals(sewerageTaxDetails.getConsumerNo())) {
            sewerageTaxDetails.setConsumerNo("");
        }
        if (sewerageTaxDetails.getOwnerName() == null) {
            sewerageTaxDetails.setOwnerName("");
        }
        if (sewerageTaxDetails.getLocalityName() == null) {
            sewerageTaxDetails.setLocalityName("");
        }
        if (sewerageTaxDetails.getPropertyAddress() == null) {
            sewerageTaxDetails.setPropertyAddress("");
        }
        if (sewerageTaxDetails.getTaxDetails() == null) {
            SewerageTaxPaidDetails ar = new SewerageTaxPaidDetails();
            ArrayList<SewerageTaxPaidDetails> taxDetails = new ArrayList<SewerageTaxPaidDetails>(0);
            taxDetails.add(ar);
            sewerageTaxDetails.setTaxDetails(taxDetails);
        }
        return sewerageTaxDetails;
    }
}

