/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.restapi.model.WaterChargesConnectionInfo;
import org.egov.restapi.model.WaterConnectionInfo;
import org.egov.wtms.application.entity.RegularisedConnection;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.rest.WaterChargesRestApiResponse;
import org.egov.wtms.application.service.AdditionalConnectionService;
import org.egov.wtms.application.service.ChangeOfUseService;
import org.egov.wtms.application.service.NewConnectionService;
import org.egov.wtms.application.service.RegularisedConnectionService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.PropertyCategory;
import org.egov.wtms.masters.entity.PropertyPipeSize;
import org.egov.wtms.masters.entity.WaterChargesDetailInfo;
import org.egov.wtms.masters.entity.WaterPropertyUsage;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.PropertyCategoryService;
import org.egov.wtms.masters.service.PropertyPipeSizeService;
import org.egov.wtms.masters.service.WaterPropertyUsageService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestWaterConnectionValidationService {
    private static final String REGULARISED_CONN_NATUREOFTASK = "Regularised Water Tap Connection";
    @Autowired
    private WaterPropertyUsageService waterPropertyUsageService;
    @Autowired
    private ChangeOfUseService changeOfUseService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private AdditionalConnectionService additionalConnectionService;
    @Autowired
    private PropertyCategoryService propertyCategoryService;
    @Autowired
    private NewConnectionService newConnectionService;
    @Autowired
    private PropertyPipeSizeService propertyPipeSizeService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<RegularisedConnection> waterConnectionWorkflowService;
    @Autowired
    private RegularisedConnectionService regularisedConnectionService;

    public WaterChargesRestApiResponse validatePropertyID(String propertyid) {
        WaterChargesRestApiResponse errorDetails = null;
        String errorMessage = this.newConnectionService.checkValidPropertyAssessmentNumber(propertyid);
        if (errorMessage != null && !errorMessage.equals("")) {
            errorDetails = new WaterChargesRestApiResponse();
            errorDetails.setErrorCode("46");
            errorDetails.setErrorMessage(errorMessage);
        }
        return errorDetails;
    }

    public WaterChargesRestApiResponse validateWaterConnectionDetails(String propertyId) {
        String responseMessagedet;
        String responseMessage = "";
        WaterChargesRestApiResponse errorDetails = null;
        responseMessage = this.newConnectionService.checkValidPropertyAssessmentNumber(propertyId);
        if (responseMessage.isEmpty() && StringUtils.isNotBlank((String)(responseMessagedet = this.newConnectionService.checkConnectionPresentForProperty(propertyId)))) {
            errorDetails = new WaterChargesRestApiResponse();
            errorDetails.setErrorMessage("Provided assessmentNumber has already connection");
            errorDetails.setErrorCode("47");
        }
        return errorDetails;
    }

    public ErrorDetails validateAdditionalWaterConnectionDetails(WaterConnectionInfo connectionInfo) {
        String responseMessage = "";
        ErrorDetails errorDetails = null;
        WaterConnection connection = this.waterConnectionService.findByConsumerCode(connectionInfo.getConsumerCode());
        WaterConnectionDetails parentConnectionDetails = this.waterConnectionDetailsService.getParentConnectionDetails(connection.getPropertyIdentifier(), ConnectionStatus.ACTIVE);
        responseMessage = this.additionalConnectionService.validateAdditionalConnection(parentConnectionDetails);
        if (StringUtils.isNotBlank((String)responseMessage)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorMessage("Either ConsumerCode is not valid or Due is present");
            errorDetails.setErrorCode("50");
        }
        return errorDetails;
    }

    public ErrorDetails validateChangOfUsageWaterConnectionDetails(WaterChargesDetailInfo connectionInfo) {
        String responseMessage = "";
        ErrorDetails errorDetails = null;
        WaterConnectionDetails connectionUnderChange = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(connectionInfo.getConsumerCode(), ConnectionStatus.ACTIVE);
        responseMessage = this.changeOfUseService.validateChangeOfUseConnection(connectionUnderChange);
        if (StringUtils.isNotBlank((String)responseMessage)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorMessage("Either ConsumerCode is not valid or Due is present");
            errorDetails.setErrorCode("50");
        }
        return errorDetails;
    }

    public ErrorDetails validateCombinationOfChangOfUsage(WaterChargesDetailInfo connectionInfo) {
        String responseMessage = "";
        ErrorDetails errorDetails = null;
        WaterConnectionDetails connectionUnderChange = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(connectionInfo.getConsumerCode(), ConnectionStatus.ACTIVE);
        if (StringUtils.isBlank((String)connectionInfo.getPropertyID())) {
            connectionInfo.setPropertyID(connectionUnderChange.getConnection().getPropertyIdentifier());
        }
        if (StringUtils.isBlank((String)connectionInfo.getWaterSource())) {
            connectionInfo.setWaterSource(connectionUnderChange.getWaterSource().getCode());
        }
        if (StringUtils.isBlank((String)connectionInfo.getConnectionType())) {
            connectionInfo.setConnectionType(connectionUnderChange.getConnectionType().toString());
        }
        if (StringUtils.isBlank((String)connectionInfo.getPropertyType())) {
            connectionInfo.setPropertyType(connectionUnderChange.getPropertyType().getCode());
        }
        if (StringUtils.isBlank((String)connectionInfo.getCategory())) {
            connectionInfo.setCategory(connectionUnderChange.getCategory().getCode());
        }
        if (StringUtils.isBlank((String)connectionInfo.getPipeSize())) {
            connectionInfo.setPipeSize(connectionUnderChange.getPipeSize().getCode());
        }
        if (connectionUnderChange.getCategory().getCode().equals(connectionInfo.getCategory()) && connectionUnderChange.getUsageType().getCode().equals(connectionInfo.getUsageType()) && connectionUnderChange.getPropertyType().getCode().equals(connectionInfo.getPropertyType()) && connectionUnderChange.getPipeSize().getCode().equals(connectionInfo.getPipeSize()) && connectionUnderChange.getConnectionType().name().equals(connectionInfo.getConnectionType())) {
            responseMessage = "Please modify at least one mandatory field";
        }
        if (StringUtils.isNotBlank((String)responseMessage)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorMessage("Either ConsumerCode is not valid or Due is present");
            errorDetails.setErrorCode(responseMessage);
        }
        return errorDetails;
    }

    public WaterChargesRestApiResponse populateAndPersistRegularisedWaterConnection(WaterChargesConnectionInfo waterChargesConnectionInfo) {
        return this.prepareNewRegularizationConnectionDetails(waterChargesConnectionInfo);
    }

    public WaterChargesRestApiResponse prepareNewRegularizationConnectionDetails(WaterChargesConnectionInfo waterChargesConnectionInfo) {
        WaterChargesRestApiResponse response = new WaterChargesRestApiResponse();
        RegularisedConnection regularisedConnection = new RegularisedConnection();
        regularisedConnection.setApplicationNumber(this.applicationNumberGenerator.generate());
        WorkFlowMatrix wfmatrix = this.waterConnectionWorkflowService.getWfMatrix(regularisedConnection.getStateType(), null, null, "REGLZNCONNECTION", "Created", null);
        User user = this.securityUtils.getCurrentUser();
        Position userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(waterChargesConnectionInfo.getPropertyId());
        regularisedConnection.setUlbCode(waterChargesConnectionInfo.getUlbCode());
        regularisedConnection.setPropertyIdentifier(waterChargesConnectionInfo.getPropertyId());
        regularisedConnection.transition().start().withSenderName(user.getUsername() + "::" + user.getName()).withStateValue(wfmatrix.getNextState()).withDateInfo(new Date()).withOwner((OwnerGroup)userPosition).withNextAction(wfmatrix.getNextAction()).withNatureOfTask(REGULARISED_CONN_NATUREOFTASK);
        this.regularisedConnectionService.save(regularisedConnection);
        response.setApplicationNumber(regularisedConnection.getApplicationNumber());
        return response;
    }

    public ErrorDetails validateServiceRequest(String propertyType, String usageType, String pipeSize, String category) {
        ErrorDetails errorDetails = null;
        if (propertyType != null) {
            WaterPropertyUsage usageTypesList = this.waterPropertyUsageService.findByPropertyTypecodeAndUsageTypecode(propertyType, usageType);
            if (usageTypesList == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("42");
                errorDetails.setErrorMessage("PropertyType and UsageType Combination is not valid");
                return errorDetails;
            }
            PropertyPipeSize pipeSizeList = this.propertyPipeSizeService.findByPropertyTypecodeAndPipeSizecode(propertyType, pipeSize);
            if (pipeSizeList == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("44");
                errorDetails.setErrorMessage("PropertyType and Pipesize Combination is not valid");
                return errorDetails;
            }
            PropertyCategory categoryTypes = this.propertyCategoryService.getAllCategoryTypesByPropertyTypeAndCategory(propertyType, category);
            if (categoryTypes == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("49");
                errorDetails.setErrorMessage("PropertyType and Category Combination is not valid");
                return errorDetails;
            }
        }
        return errorDetails;
    }

    public WaterChargesRestApiResponse validatePropertyAssessmentNumber(String propertyid) {
        WaterChargesRestApiResponse errorDetails = null;
        String errorMessage = this.newConnectionService.checkValidPropertyForDataEntry(propertyid);
        if (errorMessage != null && !errorMessage.equals("")) {
            errorDetails = new WaterChargesRestApiResponse();
            errorDetails.setApplicationNumber("-1");
            errorDetails.setErrorCode("46");
            errorDetails.setErrorMessage(errorMessage);
        }
        return errorDetails;
    }
}

