/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.restapi.model.WaterChargesConnectionInfo;
import org.egov.restapi.model.WaterConnectionInfo;
import org.egov.restapi.web.rest.RestWaterConnectionValidationService;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.rest.WaterChargesDetails;
import org.egov.wtms.application.rest.WaterChargesRestApiResponse;
import org.egov.wtms.application.service.ChangeOfUseService;
import org.egov.wtms.application.service.ConnectionDetailService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.WaterChargesDetailInfo;
import org.egov.wtms.masters.entity.WaterTaxDetailRequest;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.ApplicationProcessTimeService;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.egov.wtms.masters.service.PipeSizeService;
import org.egov.wtms.masters.service.PropertyTypeService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.masters.service.WaterSourceService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestWaterConnectionController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private ApplicationProcessTimeService applicationProcessTimeService;
    @Autowired
    private ConnectionCategoryService connectionCategoryService;
    @Autowired
    private RestWaterConnectionValidationService restWaterConnectionValidationService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private PipeSizeService pipeSizeService;
    @Autowired
    private PropertyTypeService propertyTypeService;
    @Autowired
    private UsageTypeService usageTypeService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private WaterSourceService waterSourceService;
    @Autowired
    private ChangeOfUseService changeOfUseService;
    @Autowired
    private ConnectionDetailService connectionDetailService;
    public static final String SUCCESS = "SUCCESS";

    @RequestMapping(value={"/watercharges/newconnection"}, method={RequestMethod.POST}, produces={"application/json"})
    public String createNewConnection(@Valid @RequestBody WaterConnectionInfo waterConnectionInfo) throws IOException {
        WaterChargesRestApiResponse response = this.restWaterConnectionValidationService.validatePropertyID(waterConnectionInfo.getPropertyID());
        if (response != null) {
            return this.getJSONResponse((Object)response);
        }
        WaterChargesRestApiResponse errorMessage = this.restWaterConnectionValidationService.validateWaterConnectionDetails(waterConnectionInfo.getPropertyID());
        if (errorMessage != null) {
            return this.getJSONResponse((Object)errorMessage);
        }
        ErrorDetails errorDetails = this.restWaterConnectionValidationService.validateServiceRequest(waterConnectionInfo.getPropertyType(), waterConnectionInfo.getUsageType(), waterConnectionInfo.getPipeSize(), waterConnectionInfo.getCategory());
        if (errorDetails != null) {
            return this.getJSONResponse((Object)errorDetails);
        }
        String applicationCode = "NEWCONNECTION";
        WaterConnectionDetails waterConnectionDetails = this.populateAndPersistWaterConnectionDetails(waterConnectionInfo, "NEWCONNECTION");
        return waterConnectionDetails.getApplicationNumber();
    }

    @RequestMapping(value={"/watercharges/regulariseconnection"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String createRegularisedConnection(@Valid @RequestBody WaterChargesConnectionInfo waterChargesConnectionInfo) throws IOException {
        WaterChargesRestApiResponse errorDetails = this.restWaterConnectionValidationService.validatePropertyAssessmentNumber(waterChargesConnectionInfo.getPropertyId());
        if (errorDetails != null) {
            errorDetails.setReferenceId(waterChargesConnectionInfo.getReferenceId());
            return this.getJSONResponse((Object)errorDetails);
        }
        WaterChargesRestApiResponse response = this.restWaterConnectionValidationService.populateAndPersistRegularisedWaterConnection(waterChargesConnectionInfo);
        if (response != null) {
            response.setReferenceId(waterChargesConnectionInfo.getReferenceId());
            response.setErrorCode("WCMS-REST-0");
            response.setErrorMessage(SUCCESS);
        }
        return this.getJSONResponse((Object)response);
    }

    @RequestMapping(value={"/watercharges/additionalconnection"}, method={RequestMethod.POST}, produces={"application/json"})
    public String createAddtionalConnection(@Valid @RequestBody WaterConnectionInfo waterConnectionInfo) throws IOException {
        ErrorDetails response = this.restWaterConnectionValidationService.validateAdditionalWaterConnectionDetails(waterConnectionInfo);
        String applicationCode = "ADDNLCONNECTION";
        if (response != null) {
            return this.getJSONResponse((Object)response);
        }
        ErrorDetails errorDetails = this.restWaterConnectionValidationService.validateServiceRequest(waterConnectionInfo.getPropertyType(), waterConnectionInfo.getUsageType(), waterConnectionInfo.getPipeSize(), waterConnectionInfo.getCategory());
        if (errorDetails != null) {
            return this.getJSONResponse((Object)errorDetails);
        }
        WaterConnectionDetails waterConnectionDetails = this.populateAndPersistWaterConnectionDetails(waterConnectionInfo, "ADDNLCONNECTION");
        return waterConnectionDetails.getApplicationNumber();
    }

    @RequestMapping(value={"/watercharges/changeofuse"}, method={RequestMethod.POST}, produces={"application/json"})
    public String createChangeOfUsageConnection(@Valid @RequestBody WaterChargesDetailInfo waterConnectionInfo) throws IOException {
        WaterConnectionDetails waterConnectionDetails = null;
        Long approvalPosition = 0L;
        Position userPosition = null;
        ErrorDetails response = this.restWaterConnectionValidationService.validateChangOfUsageWaterConnectionDetails(waterConnectionInfo);
        if (response != null) {
            return this.getJSONResponse((Object)response);
        }
        ErrorDetails errorMessage = this.restWaterConnectionValidationService.validateCombinationOfChangOfUsage(waterConnectionInfo);
        if (errorMessage != null) {
            return this.getJSONResponse((Object)response);
        }
        ErrorDetails errorDetails = this.restWaterConnectionValidationService.validateServiceRequest(waterConnectionInfo.getPropertyType(), waterConnectionInfo.getUsageType(), waterConnectionInfo.getPipeSize(), waterConnectionInfo.getCategory());
        if (errorDetails != null) {
            return this.getJSONResponse((Object)errorDetails);
        }
        WaterConnectionDetails connectionUnderChange = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(waterConnectionInfo.getConsumerCode(), ConnectionStatus.ACTIVE);
        waterConnectionDetails = this.prepareChangeOfUsageWaterConnectionDetails(waterConnectionInfo, connectionUnderChange);
        if (connectionUnderChange != null) {
            waterConnectionDetails.setConnection(connectionUnderChange.getConnection());
            userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(connectionUnderChange.getConnection().getPropertyIdentifier());
            if (userPosition != null) {
                approvalPosition = userPosition.getId();
            }
        }
        waterConnectionDetails = this.changeOfUseService.createChangeOfUseApplication(waterConnectionDetails, approvalPosition, "Application has been created through GIS survey system", waterConnectionDetails.getApplicationType().getCode(), null, "Survey");
        return waterConnectionDetails.getApplicationNumber();
    }

    private WaterConnectionDetails populateAndPersistWaterConnectionDetails(WaterConnectionInfo waterConnectionInfo, String applicationCode) {
        WaterConnectionDetails waterConnectionDetails = null;
        Long approvalPosition = 0L;
        Position userPosition = null;
        if (!applicationCode.equals("CHANGEOFUSE")) {
            waterConnectionDetails = this.prepareNewAndAdditionalConnectionDetails(waterConnectionInfo, applicationCode);
            userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier());
        }
        if (userPosition != null) {
            approvalPosition = userPosition.getId();
        }
        if (!applicationCode.equals("CHANGEOFUSE")) {
            waterConnectionDetails = this.waterConnectionDetailsService.createNewWaterConnection(waterConnectionDetails, approvalPosition, "Rest Api", waterConnectionDetails.getApplicationType().getCode(), null, null);
        }
        return waterConnectionDetails;
    }

    private WaterConnectionDetails prepareNewAndAdditionalConnectionDetails(WaterConnectionInfo waterConnectionInfo, String applicationCode) {
        WaterConnection waterConnection = new WaterConnection();
        WaterConnectionDetails waterConnectionDetails = new WaterConnectionDetails();
        waterConnection.setPropertyIdentifier(waterConnectionInfo.getPropertyID());
        waterConnectionDetails.setConnection(waterConnection);
        waterConnectionDetails.setApplicationDate(new Date());
        if (applicationCode.equals("NEWCONNECTION")) {
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("NEWCONNECTION"));
        } else {
            WaterConnection connection = this.waterConnectionService.findByConsumerCode(waterConnectionInfo.getConsumerCode());
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("ADDNLCONNECTION"));
            waterConnection.setParentConnection(connection);
        }
        waterConnectionDetails.setCategory(this.connectionCategoryService.findByCode(waterConnectionInfo.getCategory()));
        return this.prepareWaterConnectionDetails(waterConnectionInfo, waterConnectionDetails);
    }

    private WaterConnectionDetails prepareChangeOfUsageWaterConnectionDetails(WaterChargesDetailInfo waterConnectionInfo, WaterConnectionDetails waterConnectionDetails) {
        WaterConnectionDetails changeOfUse = new WaterConnectionDetails();
        changeOfUse.setApplicationDate(new Date());
        changeOfUse.setApplicationType(this.applicationTypeService.findByCode("CHANGEOFUSE"));
        changeOfUse.setCategory(this.connectionCategoryService.findByCode(waterConnectionInfo.getCategory()));
        changeOfUse.setConnectionReason(waterConnectionInfo.getReasonforChangeOfUsage());
        return this.prepareConnectionDetailsForChangeOfUse(waterConnectionInfo, changeOfUse);
    }

    private WaterConnectionDetails prepareWaterConnectionDetails(WaterConnectionInfo waterConnectionInfo, WaterConnectionDetails waterConnectionDetails) {
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.INPROGRESS);
        waterConnectionDetails.setConnectionType(waterConnectionInfo.getConnectionType().equals(ConnectionType.METERED.toString()) ? ConnectionType.METERED : ConnectionType.NON_METERED);
        Integer appProcessTime = this.applicationProcessTimeService.getApplicationProcessTime(waterConnectionDetails.getApplicationType(), waterConnectionDetails.getCategory());
        if (appProcessTime != null) {
            waterConnectionDetails.setDisposalDate(this.waterConnectionDetailsService.getDisposalDate(waterConnectionDetails, appProcessTime));
        }
        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CREATED", "WATERTAXAPPLICATION"));
        waterConnectionDetails.setPipeSize(this.pipeSizeService.findByCode(waterConnectionInfo.getPipeSize()));
        waterConnectionDetails.setPropertyType(this.propertyTypeService.findByCode(waterConnectionInfo.getPropertyType()));
        waterConnectionDetails.setUsageType(this.usageTypeService.findByCode(waterConnectionInfo.getUsageType()));
        waterConnectionDetails.setWaterSource(this.waterSourceService.findByCode(waterConnectionInfo.getWaterSource()));
        if (waterConnectionDetails.getUsageType().getCode().equals("LODGES")) {
            waterConnectionDetails.setNumberOfRooms(waterConnectionInfo.getNumberOfRooms());
        } else {
            waterConnectionDetails.setNumberOfPerson(waterConnectionInfo.getNumberOfPersons());
        }
        return waterConnectionDetails;
    }

    private WaterConnectionDetails prepareConnectionDetailsForChangeOfUse(WaterChargesDetailInfo waterConnectionInfo, WaterConnectionDetails waterConnectionDetails) {
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.INPROGRESS);
        waterConnectionDetails.setConnectionType(waterConnectionInfo.getConnectionType().equals(ConnectionType.METERED.toString()) ? ConnectionType.METERED : ConnectionType.NON_METERED);
        Integer appProcessTime = this.applicationProcessTimeService.getApplicationProcessTime(waterConnectionDetails.getApplicationType(), waterConnectionDetails.getCategory());
        if (appProcessTime != null) {
            waterConnectionDetails.setDisposalDate(this.waterConnectionDetailsService.getDisposalDate(waterConnectionDetails, appProcessTime));
        }
        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CREATED", "WATERTAXAPPLICATION"));
        waterConnectionDetails.setPipeSize(this.pipeSizeService.findByCode(waterConnectionInfo.getPipeSize()));
        waterConnectionDetails.setPropertyType(this.propertyTypeService.findByCode(waterConnectionInfo.getPropertyType()));
        waterConnectionDetails.setUsageType(this.usageTypeService.findByCode(waterConnectionInfo.getUsageType()));
        waterConnectionDetails.setWaterSource(this.waterSourceService.findByCode(waterConnectionInfo.getWaterSource()));
        if (waterConnectionDetails.getUsageType().getCode().equals("LODGES")) {
            waterConnectionDetails.setNumberOfRooms(waterConnectionInfo.getNumberOfRooms());
        } else {
            waterConnectionDetails.setNumberOfPerson(waterConnectionInfo.getNumberOfPersons());
        }
        return waterConnectionDetails;
    }

    @RequestMapping(value={"/watertax/connectiondetails"}, method={RequestMethod.GET}, consumes={"application/json"}, produces={"application/json"})
    public List<WaterChargesDetails> getWaterConnectionDetailsByPropertyId(WaterTaxDetailRequest waterTaxDetailRequest) {
        List waterChargesDetailsList = this.connectionDetailService.getWaterTaxDetailsByPropertyId(waterTaxDetailRequest.getAssessmentNumber(), waterTaxDetailRequest.getUlbCode(), waterTaxDetailRequest.getConsumerNumber());
        return waterChargesDetailsList;
    }

    private String getJSONResponse(Object obj) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        return objectMapper.writeValueAsString(obj);
    }

    public Boolean authenticateUser(String username, String password) {
        Boolean isAuthenticated = false;
        if (username.equals("mahesh") && password.equals("demo")) {
            isAuthenticated = true;
        }
        ApplicationThreadLocals.setUserId((Long)Long.valueOf("2"));
        return isAuthenticated;
    }
}

