/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.dcb.bean.ChequePayment;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.restapi.model.BudgetCheck;
import org.egov.restapi.model.RestErrors;
import org.egov.restapi.service.BudgetCheckService;
import org.egov.restapi.util.JsonConvertor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestBudgetController {
    @Autowired
    private BudgetCheckService budgetCheckService;

    @RequestMapping(value={"/egf/budget/planningbudgetavailable"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getBudgetAvailable(@RequestBody String requestJson, HttpServletResponse response) throws IOException {
        String planningBudgetAvailable;
        BudgetCheck budgetCheck = (BudgetCheck)this.getObjectFromJSONRequest(requestJson, BudgetCheck.class);
        try {
            List restErrors = this.budgetCheckService.validateMandatoryFields(budgetCheck);
            if (!restErrors.isEmpty()) {
                response.setStatus(400);
                return JsonConvertor.convert((Object)restErrors);
            }
            planningBudgetAvailable = this.budgetCheckService.getPlanningBudgetAvailable(budgetCheck);
        }
        catch (ValidationException v) {
            ArrayList<RestErrors> errorList = new ArrayList<RestErrors>(0);
            RestErrors re = new RestErrors();
            re.setErrorCode(((ValidationError)v.getErrors().get(0)).getMessage());
            re.setErrorMessage(((ValidationError)v.getErrors().get(0)).getMessage());
            errorList.add(re);
            return JsonConvertor.convert(errorList);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("AvailableBalance", planningBudgetAvailable);
        response.setStatus(201);
        return jsonObject.toString();
    }

    private Object getObjectFromJSONRequest(String jsonString, Class cls) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        mapper.setDateFormat((DateFormat)ChequePayment.CHEQUE_DATE_FORMAT);
        return mapper.readValue(jsonString, cls);
    }
}

