/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.controller.tradelicense;

import java.util.List;
import java.util.stream.Collectors;
import org.egov.restapi.model.RestErrors;
import org.egov.restapi.web.contracts.tradelicense.TradeLicenseDetailRequest;
import org.egov.restapi.web.contracts.tradelicense.TradeLicenseDetailResponse;
import org.egov.tl.service.TradeLicenseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tradelicense"})
public class TradeLicenseDetailController {
    @Autowired
    private TradeLicenseService tradeLicenseService;

    @GetMapping(value={"/details"}, consumes={"application/json"}, produces={"application/json"})
    public List<TradeLicenseDetailResponse> tradeLicenseDetails(TradeLicenseDetailRequest request) {
        return this.tradeLicenseService.getLicenses(request.tradeLicenseLike()).parallelStream().map(TradeLicenseDetailResponse::new).collect(Collectors.toList());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public RestErrors restErrors(RuntimeException runtimeException) {
        return new RestErrors("LICENSE NOT EXIST", runtimeException.getMessage());
    }
}

