/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.controller.tradelicense;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.egov.restapi.web.contracts.tradelicense.LicenseCreateRequest;
import org.egov.tl.repository.LicenseCategoryRepository;
import org.egov.tl.repository.LicenseSubCategoryRepository;
import org.egov.tl.repository.NatureOfBusinessRepository;
import org.egov.tl.repository.ValidityRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class LicenseCreateAPIValidator
implements Validator {
    @Autowired
    private LicenseCategoryRepository licenseCategoryRepository;
    @Autowired
    private LicenseSubCategoryRepository licenseSubCategoryRepository;
    @Autowired
    private NatureOfBusinessRepository natureOfBusinessRepository;
    @Autowired
    private ValidityRepository validityRepository;

    public boolean supports(Class<?> clazz) {
        return LicenseCreateRequest.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        LicenseCreateRequest license = (LicenseCreateRequest)target;
        if (license.getAgreementDate() == null && StringUtils.isNotBlank((String)license.getAgreementDocNo()) || license.getAgreementDate() != null && StringUtils.isBlank((String)license.getAgreementDocNo())) {
            errors.rejectValue("agreementDate", "Provide both Agreement Date and Agreement Doc No", "Provide both Agreement Date and Agreement Doc No");
        }
        if (this.natureOfBusinessRepository.findOne((Serializable)license.getNatureOfBusiness()) == null) {
            errors.rejectValue("natureOfBusiness", "Invalid Nature Of Business", "Invalid Nature Of Business");
        }
        Long categoryId = null;
        if (license.getCategory() != null && license.getCategory().length() < 6) {
            categoryId = this.licenseCategoryRepository.findByCodeIgnoreCase(license.getCategory()).getId();
        }
        if (categoryId == null) {
            errors.rejectValue("category", "Invalid Category", "Invalid Category");
            return;
        }
        List subCategories = this.licenseSubCategoryRepository.findByCategoryIdOrderByNameAsc(categoryId);
        if (!subCategories.stream().anyMatch(subCategory -> subCategory.getCode().equalsIgnoreCase(license.getSubCategory()))) {
            errors.rejectValue("subCategory", "Invalid SubCategory", "Invalid SubCategory");
        }
        if (Optional.ofNullable(this.validityRepository.findByNatureOfBusinessIdAndLicenseCategoryId(license.getNatureOfBusiness(), categoryId)).orElse(this.validityRepository.findByNatureOfBusinessIdAndLicenseCategoryIsNull(license.getNatureOfBusiness())) == null) {
            errors.rejectValue("category", "License validity not defined for this Category", "License validity not defined for this Category");
        }
    }
}

