/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.controller.tradelicense;

import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.restapi.service.LicenseCreateAPIService;
import org.egov.restapi.web.contracts.tradelicense.LicenseCreateRequest;
import org.egov.restapi.web.contracts.tradelicense.LicenseCreateResponse;
import org.egov.restapi.web.controller.tradelicense.LicenseCreateAPIValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LicenseCreateAPIController {
    @Autowired
    private LicenseCreateAPIService licenseCreateAPIService;
    @Autowired
    private LicenseCreateAPIValidator licenseCreateAPIValidator;

    @PostMapping(value={"license/create"})
    public LicenseCreateResponse createLicense(@Valid @RequestBody LicenseCreateRequest licenseCreateRequest, BindingResult binding) {
        this.licenseCreateAPIValidator.validate((Object)licenseCreateRequest, (Errors)binding);
        if (binding.hasErrors()) {
            List licenseResponses = binding.getFieldErrors().stream().map(DefaultMessageSourceResolvable::getDefaultMessage).collect(Collectors.toList());
            return new LicenseCreateResponse(false, HttpStatus.BAD_REQUEST.toString(), licenseResponses.toString());
        }
        return new LicenseCreateResponse(true, this.licenseCreateAPIService.createLicense(licenseCreateRequest).getApplicationNumber(), HttpStatus.OK.toString(), "License Created Successfully");
    }

    @ExceptionHandler(value={ValidationException.class})
    public ResponseEntity<Object> validationErrors(ValidationException exception) {
        List errors = exception.getErrors().stream().map(ValidationError::getMessage).collect(Collectors.toList());
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)new LicenseCreateResponse(false, HttpStatus.BAD_REQUEST.toString(), errors.toString()));
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> restErrors() {
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)new LicenseCreateResponse(false, HttpStatus.INTERNAL_SERVER_ERROR.toString(), "Server Error"));
    }
}

