/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.contracts.tradelicense;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.Date;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

public class LicenseCreateRequest {
    private static final String ALPHABETS = "^[A-Za-z]{1,256}$";
    private static final String EMAIL = "^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    private static final String ALPHANUMERIC_WITHLENGTH = "^[0-9a-zA-Z-& :,/.()@]{1,256}$";
    @NotBlank(message="ULB code must be present")
    private String ulbCode;
    @Pattern(regexp="^[A-Za-z]{1,256}$", message="Invalid Applicant Name")
    private String applicantName;
    @Pattern(regexp="^[A-Za-z]{1,256}$", message="Invalid Father/Spouse Name")
    private String fatherOrSpouseName;
    @NotBlank(message="Provide Mobile Number")
    @Pattern(regexp="^[0-9]{10,10}$", message="Invalid Mobile Number")
    private String mobilePhoneNumber;
    @Pattern(regexp="^[0-9]{12,12}$", message="Invalid Aadhaar Number")
    private String aadhaarNumber;
    @NotBlank(message="Provide EmailId")
    @Email(regexp="^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$", message="Invalid Email")
    private String emailId;
    @Pattern(regexp="^[0-9a-zA-Z-& :,/.()@]{1,256}$", message="Invalid Trade Title")
    private String tradeTitle;
    @Pattern(regexp="^[A-Za-z]{1,120}$", message="Invalid Ownership Type")
    private String ownershipType;
    @Pattern(regexp="^[0-9]{0,64}$", message="Invalid Assessment Number")
    private String assessmentNo;
    @NotNull(message="Invalid Commencement Date")
    @JsonFormat(pattern="dd-MM-yyyy", shape=JsonFormat.Shape.STRING)
    private Date commencementDate;
    @NotNull(message="Invalid Trade Measure")
    private BigDecimal tradeMeasure;
    @NotNull(message="Invalid Locality")
    private Long boundary;
    @NotNull(message="Invalid Ward")
    private Long parentBoundary;
    @NotNull(message="Invalid Nature Of Business")
    private Long natureOfBusiness;
    @NotBlank(message="Invalid Subcategory")
    private String subCategory;
    @NotBlank(message="Invalid Category")
    private String category;
    @Length(min=1, max=256, message="Invalid Trade Address")
    private String tradeAddress;
    @Length(min=1, max=256, message="Invalid Licensee Address")
    private String licenseeAddress;
    @Length(max=512)
    private String remarks;
    @JsonFormat(pattern="dd-MM-yyyy", shape=JsonFormat.Shape.STRING)
    private Date agreementDate;
    @Length(max=50, message="Invalid Agreement Document No.")
    private String agreementDocNo;

    public String getUlbCode() {
        return this.ulbCode;
    }

    public void setUlbCode(String ulbCode) {
        this.ulbCode = ulbCode;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getFatherOrSpouseName() {
        return this.fatherOrSpouseName;
    }

    public void setFatherOrSpouseName(String fatherOrSpouseName) {
        this.fatherOrSpouseName = fatherOrSpouseName;
    }

    public String getMobilePhoneNumber() {
        return this.mobilePhoneNumber;
    }

    public void setMobilePhoneNumber(String mobilePhoneNumber) {
        this.mobilePhoneNumber = mobilePhoneNumber;
    }

    public String getAadhaarNumber() {
        return this.aadhaarNumber;
    }

    public void setAadhaarNumber(String aadhaarNumber) {
        this.aadhaarNumber = aadhaarNumber;
    }

    public String getEmailId() {
        return this.emailId;
    }

    public void setEmailId(String emailId) {
        this.emailId = emailId;
    }

    public String getTradeTitle() {
        return this.tradeTitle;
    }

    public void setTradeTitle(String tradeTitle) {
        this.tradeTitle = tradeTitle;
    }

    public String getOwnershipType() {
        return this.ownershipType;
    }

    public void setOwnershipType(String ownershipType) {
        this.ownershipType = ownershipType;
    }

    public String getAssessmentNo() {
        return this.assessmentNo;
    }

    public void setAssessmentNo(String assessmentNo) {
        this.assessmentNo = assessmentNo;
    }

    public Date getCommencementDate() {
        return this.commencementDate;
    }

    public void setCommencementDate(Date commencementDate) {
        this.commencementDate = commencementDate;
    }

    public BigDecimal getTradeMeasure() {
        return this.tradeMeasure;
    }

    public void setTradeMeasure(BigDecimal tradeMeasure) {
        this.tradeMeasure = tradeMeasure;
    }

    public Long getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Long boundary) {
        this.boundary = boundary;
    }

    public Long getParentBoundary() {
        return this.parentBoundary;
    }

    public void setParentBoundary(Long parentBoundary) {
        this.parentBoundary = parentBoundary;
    }

    public Long getNatureOfBusiness() {
        return this.natureOfBusiness;
    }

    public void setNatureOfBusiness(Long natureOfBusiness) {
        this.natureOfBusiness = natureOfBusiness;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getTradeAddress() {
        return this.tradeAddress;
    }

    public void setTradeAddress(String tradeAddress) {
        this.tradeAddress = tradeAddress;
    }

    public String getLicenseeAddress() {
        return this.licenseeAddress;
    }

    public void setLicenseeAddress(String licenseeAddress) {
        this.licenseeAddress = licenseeAddress;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Date getAgreementDate() {
        return this.agreementDate;
    }

    public void setAgreementDate(Date agreementDate) {
        this.agreementDate = agreementDate;
    }

    public String getAgreementDocNo() {
        return this.agreementDocNo;
    }

    public void setAgreementDocNo(String agreementDocNo) {
        this.agreementDocNo = agreementDocNo;
    }
}

