/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.ptis.client.service.calculator.APTaxCalculator;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.entity.property.vacantland.LayoutApprovalAuthority;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.FloorDetails;
import org.egov.ptis.domain.model.OwnerInformation;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.model.TaxCalculatorRequest;
import org.egov.ptis.domain.repository.master.vacantland.LayoutApprovalAuthorityRepository;
import org.egov.ptis.domain.repository.master.vacantland.VacantLandPlotAreaRepository;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.ptis.master.service.PropertyUsageService;
import org.egov.ptis.master.service.StructureClassificationService;
import org.egov.restapi.model.AssessmentRequest;
import org.egov.restapi.model.AssessmentsDetails;
import org.egov.restapi.model.CreatePropertyDetails;
import org.egov.restapi.model.DocumentTypeDetails;
import org.egov.restapi.model.PropertyAddressDetails;
import org.egov.restapi.model.PropertyTransferDetails;
import org.egov.restapi.model.SurroundingBoundaryDetails;
import org.egov.restapi.model.VacantLandDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValidationUtil {
    private static final String NO_APPROVAL = "No Approval";
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    PropertyUsageService propertyUsageService;
    @Autowired
    StructureClassificationService structureClassificationService;
    @Autowired
    PropertyTaxUtil propertyTaxUtil;
    @Autowired
    APTaxCalculator aPTaxCalculator;
    @Autowired
    private LayoutApprovalAuthorityRepository layoutApprovalAuthorityRepo;
    @Autowired
    private VacantLandPlotAreaRepository vacantLandPlotAreaRepository;
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final String PINCODE_PATTERN = "^[1-9][0-9]{5}$";
    private static final String GUARDIAN_PATTERN = "^[\\p{L} .'-]+$";
    private static final String DIGITS_ONLY = "^(0|[1-9][0-9]*)$";
    private static final String CAMEL_CASE_PATTERN = "([A-Z]+[a-z]+\\w+)+";
    private static final String DIGITS_FLOAT_INT_DBL = "[-+]?[0-9]*\\.?[0-9]+";
    private static final String UPPERCASE_PATTERN = "([A-Z])";

    public static ErrorDetails validatePropertyTransferRequest(PropertyTransferDetails propertyTransferDetails) {
        ErrorDetails errorDetails = null;
        String assessmentNumber = propertyTransferDetails.getAssessmentNo();
        if (StringUtils.isBlank((CharSequence)assessmentNumber)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("51");
            errorDetails.setErrorMessage("Assessment Number is required.");
            return errorDetails;
        }
        String mutationReasonCode = propertyTransferDetails.getMutationReasonCode();
        if (StringUtils.isBlank((CharSequence)mutationReasonCode)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("52");
            errorDetails.setErrorMessage("Mutation Reason Code is required.");
            return errorDetails;
        }
        if (!(!StringUtils.isNotBlank((CharSequence)mutationReasonCode) || mutationReasonCode.equalsIgnoreCase("GIFTDEED") || mutationReasonCode.equalsIgnoreCase("WILLDEED") || mutationReasonCode.equalsIgnoreCase("SALEDEED") || mutationReasonCode.equalsIgnoreCase("RELINQUISH") || mutationReasonCode.equalsIgnoreCase("PARTITIOND"))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("56");
            errorDetails.setErrorMessage("Invalid Mutation Reason Code. It can be GIFTDEED/WILLDEED/SALEDEED/RELINQUISH/PARTITIOND");
            return errorDetails;
        }
        if (mutationReasonCode.equalsIgnoreCase("SALEDEED") && StringUtils.isBlank((CharSequence)propertyTransferDetails.getSaleDetails())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("53");
            errorDetails.setErrorMessage("Sale Details are required.");
            return errorDetails;
        }
        if (!mutationReasonCode.equalsIgnoreCase("SALEDEED") && StringUtils.isNotBlank((CharSequence)propertyTransferDetails.getSaleDetails())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("57");
            errorDetails.setErrorMessage("Sale Details are required only if reason is Sale Deed.");
            return errorDetails;
        }
        String deedNo = propertyTransferDetails.getDeedNo();
        if (StringUtils.isBlank((CharSequence)deedNo)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("54");
            errorDetails.setErrorMessage("Deed Number is required.");
            return errorDetails;
        }
        String deedDate = propertyTransferDetails.getDeedDate();
        if (StringUtils.isBlank((CharSequence)deedDate)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("55");
            errorDetails.setErrorMessage("Deed Date is required.");
            return errorDetails;
        }
        List ownerDetailsList = propertyTransferDetails.getOwnerDetails();
        if (ownerDetailsList.isEmpty()) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("35");
            errorDetails.setErrorMessage("Owner Details is required.");
            return errorDetails;
        }
        for (OwnerInformation ownerInfo : ownerDetailsList) {
            if (ownerInfo.getMobileNumber() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("30");
                errorDetails.setErrorMessage("Mobile Number is required.");
                return errorDetails;
            }
            if (ownerInfo.getName() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("30");
                errorDetails.setErrorMessage("Owner Name is required.");
                return errorDetails;
            }
            if (ownerInfo.getGender() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("31");
                errorDetails.setErrorMessage("Gender is required.");
                return errorDetails;
            }
            if (ownerInfo.getGuardianRelation() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("32");
                errorDetails.setErrorMessage("Guardian Relation is required.");
                return errorDetails;
            }
            if (ownerInfo.getGuardian() != null) continue;
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("33");
            errorDetails.setErrorMessage("Guardian is required.");
            return errorDetails;
        }
        return errorDetails;
    }

    public ErrorDetails validateCreateRequest(CreatePropertyDetails createPropDetails, String mode) throws ParseException {
        AssessmentsDetails assessmentsDetails;
        ErrorDetails errorDetails = new ErrorDetails();
        String propertyTypeMasterCode = createPropDetails.getPropertyTypeMasterCode();
        DocumentTypeDetails documentTypeDetails = createPropDetails.getDocumentTypeDetails();
        if (StringUtils.isBlank((CharSequence)propertyTypeMasterCode)) {
            errorDetails.setErrorCode("01");
            errorDetails.setErrorMessage("Category of Ownership is required.");
            return errorDetails;
        }
        if (!(propertyTypeMasterCode == null || propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND") || propertyTypeMasterCode.equalsIgnoreCase("PRIVATE") || PropertyTaxConstants.PROPERTY_TYPE_GOVT_LIST.contains(propertyTypeMasterCode))) {
            errorDetails.setErrorCode("02");
            errorDetails.setErrorMessage("Invalid Category of Ownership. ");
            return errorDetails;
        }
        String propertyCategoryCode = createPropDetails.getCategoryCode();
        if (StringUtils.isBlank((CharSequence)propertyCategoryCode)) {
            errorDetails.setErrorCode("03");
            errorDetails.setErrorMessage("Property Type is required.");
            return errorDetails;
        }
        if (!(propertyCategoryCode == null || propertyCategoryCode.equalsIgnoreCase("VACANTLAND") || propertyCategoryCode.equalsIgnoreCase("STATE_GOVT") || propertyCategoryCode.equalsIgnoreCase("CENTRAL_GOVT") || propertyCategoryCode.equalsIgnoreCase("RESIDENTIAL") || propertyCategoryCode.equalsIgnoreCase("NON_RESIDENTIAL") || propertyCategoryCode.equalsIgnoreCase("MIXED"))) {
            errorDetails.setErrorCode("04");
            errorDetails.setErrorMessage("Invalid Property Type.");
            return errorDetails;
        }
        if ("VAC_LAND".equalsIgnoreCase(propertyTypeMasterCode) && ("RESIDENTIAL".equalsIgnoreCase(propertyCategoryCode) || "NON_RESIDENTIAL".equalsIgnoreCase(propertyCategoryCode) || "MIXED".equalsIgnoreCase(propertyCategoryCode))) {
            errorDetails.setErrorCode("74");
            errorDetails.setErrorMessage("Ownership type is Vacant Land, hence Property type can't be Residential, Non-Residential or Mixed.");
            return errorDetails;
        }
        if (PropertyTaxConstants.PROPERTY_TYPE_GOVT_LIST.contains(propertyTypeMasterCode) && "VACANTLAND".equalsIgnoreCase(propertyCategoryCode)) {
            errorDetails.setErrorCode("123");
            errorDetails.setErrorMessage("Ownership type is State/Central Govt, Hence Property Category can't be Vacant Land");
            return errorDetails;
        }
        Double areaOfPlot = 0.0;
        if (mode.equals("create")) {
            List ownerDetailsList = createPropDetails.getOwnerDetails();
            if (documentTypeDetails != null && !"Un-registered Document / Notary document".equals(documentTypeDetails.getDocumentName())) {
                errorDetails = this.validateOwnerDetails(errorDetails, ownerDetailsList);
            }
            if (errorDetails != null && errorDetails.getErrorCode() != null) {
                return errorDetails;
            }
        }
        if ((assessmentsDetails = createPropDetails.getAssessmentDetails()) == null && !"modify".equalsIgnoreCase(mode)) {
            errorDetails.setErrorCode("36");
            errorDetails.setErrorMessage("Assessment Details is required.");
            return errorDetails;
        }
        if (assessmentsDetails != null && StringUtils.isBlank((CharSequence)assessmentsDetails.getMutationReasonCode()) && !"modify".equalsIgnoreCase(mode)) {
            errorDetails.setErrorCode("37");
            errorDetails.setErrorMessage("Reason For Creation is required.");
            return errorDetails;
        }
        if (assessmentsDetails != null && !propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND")) {
            if (StringUtils.isBlank((CharSequence)assessmentsDetails.getExtentOfSite())) {
                errorDetails.setErrorCode("38");
                errorDetails.setErrorMessage("Extent of Site (Sq.Mtrs) is required.");
                return errorDetails;
            }
            if (Double.valueOf(assessmentsDetails.getExtentOfSite()) == 0.0) {
                errorDetails.setErrorCode("61");
                errorDetails.setErrorMessage("Area/Extent of site should be greate than 0.");
                return errorDetails;
            }
            areaOfPlot = Double.valueOf(assessmentsDetails.getExtentOfSite());
        }
        if (propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND") && (errorDetails = this.validateVacantLandDetails(createPropDetails, errorDetails)) != null && errorDetails.getErrorCode() != null) {
            return errorDetails;
        }
        PropertyAddressDetails propertyAddressDetails = createPropDetails.getPropertyAddressDetails();
        if (!mode.equals("modify")) {
            if (propertyAddressDetails == null) {
                errorDetails.setErrorCode("71");
                errorDetails.setErrorMessage("Property address details are required.");
                return errorDetails;
            }
            if ((errorDetails = this.validateBoundaries(propertyAddressDetails, errorDetails, mode)) != null && errorDetails.getErrorCode() != null) {
                return errorDetails;
            }
            Boundary locality = this.propertyExternalService.getBoundarybyboundaryNumberTypeHierarchy(propertyAddressDetails.getLocalityNum(), this.propertyExternalService.getBoundaryTypeByNameandHierarchy("Locality", "LOCATION"));
            Boundary block = this.propertyExternalService.getBoundarybyboundaryNumberTypeHierarchy(propertyAddressDetails.getBlockNum(), this.propertyExternalService.getBoundaryTypeByNameandHierarchy("Block", "REVENUE"));
            Boundary ward = this.propertyExternalService.getBoundarybyboundaryNumberTypeHierarchy(propertyAddressDetails.getWardNum(), this.propertyExternalService.getBoundaryTypeByNameandHierarchy("Ward", "REVENUE"));
            errorDetails = this.validateCrossHierarchyMapping(locality, ward, block, errorDetails);
            if (errorDetails != null && errorDetails.getErrorCode() != null) {
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getPinCode())) {
                errorDetails.setErrorCode("25");
                errorDetails.setErrorMessage("Pin Code is required.");
                return errorDetails;
            }
            Pattern pattern = Pattern.compile(PINCODE_PATTERN);
            Matcher matcher = pattern.matcher(propertyAddressDetails.getPinCode());
            if (!matcher.matches()) {
                errorDetails.setErrorCode("85");
                errorDetails.setErrorMessage("Invalid Pin Code...");
                return errorDetails;
            }
        }
        if (!propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND")) {
            List floorDetailsList = createPropDetails.getFloorDetails();
            if (floorDetailsList == null || floorDetailsList.isEmpty()) {
                errorDetails.setErrorCode("40");
                errorDetails.setErrorMessage("Floor Details is required.");
                return errorDetails;
            }
            for (FloorDetails floorDetails : floorDetailsList) {
                if (StringUtils.isBlank((CharSequence)floorDetails.getFloorNoCode())) {
                    errorDetails.setErrorCode("17");
                    errorDetails.setErrorMessage("Floor Number is required.");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getBuildClassificationCode())) {
                    errorDetails.setErrorCode("18");
                    errorDetails.setErrorMessage("Building Classification is required.");
                    return errorDetails;
                }
                Boolean classification = this.structureClassificationService.isActiveClassification(floorDetails.getBuildClassificationCode());
                if (classification == null) {
                    errorDetails.setErrorCode("23");
                    errorDetails.setErrorMessage("Building Classification doesn't exist");
                    return errorDetails;
                }
                if (!classification.booleanValue()) {
                    errorDetails.setErrorCode("109");
                    errorDetails.setErrorMessage("Building Classification is Inactive");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getNatureOfUsageCode())) {
                    errorDetails.setErrorCode("19");
                    errorDetails.setErrorMessage("Nature of Usage is required.");
                    return errorDetails;
                }
                if (propertyCategoryCode.equalsIgnoreCase("NON_RESIDENTIAL") && this.propertyUsageService.getUsageByCode(floorDetails.getNatureOfUsageCode()).getUsageName().equalsIgnoreCase("Residence")) {
                    errorDetails.setErrorCode("120");
                    errorDetails.setErrorMessage("Non-Residential property hence, Nature of Usage can't be Residential.");
                    return errorDetails;
                }
                Boolean usage = this.propertyUsageService.isActiveUsage(floorDetails.getNatureOfUsageCode());
                if (usage == null) {
                    errorDetails.setErrorCode("24");
                    errorDetails.setErrorMessage("Nature of Usage doesn't exist");
                    return errorDetails;
                }
                if (!usage.booleanValue()) {
                    errorDetails.setErrorCode("108");
                    errorDetails.setErrorMessage("Usage Code is Inactive");
                    return errorDetails;
                }
                if (!floorDetails.getNatureOfUsageCode().equalsIgnoreCase("RESD") && StringUtils.isBlank((CharSequence)floorDetails.getFirmName())) {
                    errorDetails.setErrorCode("64");
                    errorDetails.setErrorMessage("Firm Name is Required");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getOccupancyCode())) {
                    errorDetails.setErrorCode("20");
                    errorDetails.setErrorMessage("Occupancy is required.");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getConstructionDate())) {
                    errorDetails.setErrorCode("21");
                    errorDetails.setErrorMessage("Construction Date is required.");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getOccupancyDate())) {
                    errorDetails.setErrorCode("65");
                    errorDetails.setErrorMessage("Occupancy Date is required.");
                    return errorDetails;
                }
                String zoneNo = null;
                if (!mode.equals("modify")) {
                    zoneNo = propertyAddressDetails.getZoneNum();
                } else {
                    BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(createPropDetails.getAssessmentNumber());
                    zoneNo = basicProperty.getPropertyID().getZone().getBoundaryNum().toString();
                }
                if (this.propertyExternalService.isActiveUnitRateExists(floorDetails, zoneNo, floorDetails.getNatureOfUsageCode(), floorDetails.getBuildClassificationCode()).booleanValue()) {
                    errorDetails.setErrorCode("110");
                    errorDetails.setErrorMessage("There is no Active Unit Rates for given Zone,Claasfication,Usage and Occupancy Date");
                    return errorDetails;
                }
                Date constructionDate = this.propertyExternalService.convertStringToDate(floorDetails.getConstructionDate());
                Date occupancyDate = this.propertyExternalService.convertStringToDate(floorDetails.getOccupancyDate());
                if (constructionDate.after(new Date()) || occupancyDate.after(new Date())) {
                    errorDetails.setErrorCode("75");
                    errorDetails.setErrorMessage("Registration Doc Date/Construction Date/Occupancy Date cannot be greater than current date.");
                    return errorDetails;
                }
                if (occupancyDate.before(constructionDate)) {
                    errorDetails.setErrorCode("76");
                    errorDetails.setErrorMessage("Occupancy Date cannot be before Construction Date.");
                    return errorDetails;
                }
                if (floorDetails.getUnstructuredLand() == null) {
                    errorDetails.setErrorCode("95");
                    errorDetails.setErrorMessage("Please check Unstructured Land checkbox");
                    return errorDetails;
                }
                if (floorDetails.getUnstructuredLand().booleanValue()) {
                    if (floorDetails.getPlinthArea() == null) {
                        errorDetails.setErrorCode("22");
                        errorDetails.setErrorMessage("Plinth area (Sq.Mtrs) is required.");
                        return errorDetails;
                    }
                    if (Double.valueOf(floorDetails.getPlinthArea().floatValue()) == 0.0) {
                        errorDetails.setErrorCode("66");
                        errorDetails.setErrorMessage("Plinth area should be greater than 0.");
                        return errorDetails;
                    }
                    if (Double.valueOf(floorDetails.getPlinthArea().floatValue()) > areaOfPlot) {
                        errorDetails.setErrorCode("77");
                        errorDetails.setErrorMessage("Plinth Area cannot be greater than Extent of Site.");
                        return errorDetails;
                    }
                } else {
                    if (floorDetails.getPlinthLength() == null) {
                        errorDetails.setErrorCode("67");
                        errorDetails.setErrorMessage("Plinth length is required.");
                        return errorDetails;
                    }
                    if ((double)Float.valueOf(floorDetails.getPlinthLength().floatValue()).floatValue() == 0.0) {
                        errorDetails.setErrorCode("68");
                        errorDetails.setErrorMessage("Plinth length should be greater than 0.");
                        return errorDetails;
                    }
                    if (floorDetails.getPlinthBreadth() == null) {
                        errorDetails.setErrorCode("69");
                        errorDetails.setErrorMessage("Plinth breadth is required.");
                        return errorDetails;
                    }
                    if ((double)Float.valueOf(floorDetails.getPlinthBreadth().floatValue()).floatValue() == 0.0) {
                        errorDetails.setErrorCode("66");
                        errorDetails.setErrorMessage("Plinth area should be greater than 0.");
                        return errorDetails;
                    }
                }
                if (!mode.equals("modify") && StringUtils.isNotBlank((CharSequence)documentTypeDetails.getDocumentDate()) && this.propertyExternalService.convertStringToDate(documentTypeDetails.getDocumentDate()).after(this.propertyExternalService.convertStringToDate(floorDetails.getOccupancyDate()))) {
                    errorDetails.setErrorCode("98");
                    errorDetails.setErrorMessage("Document Date Should be less than Construction Date");
                    return errorDetails;
                }
                if (!StringUtils.isNotBlank((CharSequence)floorDetails.getBuildingPermissionNo())) continue;
                if (StringUtils.isBlank((CharSequence)floorDetails.getBuildingPermissionDate())) {
                    errorDetails.setErrorCode("118");
                    errorDetails.setErrorMessage("Building Permission Date is Required");
                    return errorDetails;
                }
                if (floorDetails.getBuildingPlanPlinthArea() != null) continue;
                errorDetails.setErrorCode("119");
                errorDetails.setErrorMessage("Building Plan Plinth Area is Required");
                return errorDetails;
            }
        }
        if (!mode.equals("modify")) {
            VacantLandDetails vlt = createPropDetails.getVacantLandDetails();
            if (documentTypeDetails == null) {
                errorDetails.setErrorCode("87");
                errorDetails.setErrorMessage("Document Details Required..");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)documentTypeDetails.getDocumentName())) {
                errorDetails.setErrorCode("88");
                errorDetails.setErrorMessage("Select Atleast One Document..");
                return errorDetails;
            }
            if (!documentTypeDetails.getDocumentName().equals("Un-registered Document / Notary document")) {
                if (StringUtils.isBlank((CharSequence)documentTypeDetails.getDocumentNumber())) {
                    errorDetails.setErrorCode("05");
                    errorDetails.setErrorMessage("Registration Doc No is required.");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)documentTypeDetails.getDocumentDate())) {
                    errorDetails.setErrorCode("06");
                    errorDetails.setErrorMessage("Registration Doc Date is required.");
                    return errorDetails;
                }
                if (this.propertyExternalService.convertStringToDate(documentTypeDetails.getDocumentDate()).after(new Date())) {
                    errorDetails.setErrorCode("75");
                    errorDetails.setErrorMessage("Registration Doc Date/Construction Date/Occupancy Date cannot be greater than current date.");
                    return errorDetails;
                }
                if (propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND") && this.propertyExternalService.convertStringToDate(documentTypeDetails.getDocumentDate()).after(this.propertyExternalService.convertStringToDate(vlt.getEffectiveDate()))) {
                    errorDetails.setErrorCode("97");
                    errorDetails.setErrorMessage("Document Date Should be less than Effective Date");
                    return errorDetails;
                }
            }
            if (documentTypeDetails.getDocumentName().equals("Patta Certificate (Issued by Revenue Department)")) {
                if (StringUtils.isBlank((CharSequence)documentTypeDetails.getMroProceedingNumber())) {
                    errorDetails.setErrorCode("89");
                    errorDetails.setErrorMessage("MRO Proceeding  Doc No is required.");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)documentTypeDetails.getMroProceedingDate())) {
                    errorDetails.setErrorCode("90");
                    errorDetails.setErrorMessage("MRO Proceeding  Doc Date is required.");
                    return errorDetails;
                }
                if (documentTypeDetails.getDocumentName().equals("Decree by Civil Court") && StringUtils.isBlank((CharSequence)documentTypeDetails.getCourtName())) {
                    errorDetails.setErrorCode("91");
                    errorDetails.setErrorMessage("Court Name is required.");
                    return errorDetails;
                }
            }
        }
        return errorDetails;
    }

    public Date convertStringToDate(String dateInString) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        return sdf.parse(dateInString);
    }

    public ErrorDetails validateVacantLandDetails(CreatePropertyDetails createPropDetails, ErrorDetails errorDetails) {
        VacantLandDetails vacantLandDetails = createPropDetails.getVacantLandDetails();
        if (vacantLandDetails == null) {
            errorDetails.setErrorCode("39");
            errorDetails.setErrorMessage("Vacant Land Details is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)vacantLandDetails.getSurveyNumber())) {
            errorDetails.setErrorCode("07");
            errorDetails.setErrorMessage("Survey Number is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)vacantLandDetails.getPattaNumber())) {
            errorDetails.setErrorCode("08");
            errorDetails.setErrorMessage("Patta Number is required.");
            return errorDetails;
        }
        if (vacantLandDetails.getVacantLandArea() == null) {
            errorDetails.setErrorCode("09");
            errorDetails.setErrorMessage("Vacant Land Area is required.");
            return errorDetails;
        }
        if ((double)Float.valueOf(vacantLandDetails.getVacantLandArea().floatValue()).floatValue() == 0.0) {
            errorDetails.setErrorCode("61");
            errorDetails.setErrorMessage("Area/Extent of site should be greate than 0.");
            return errorDetails;
        }
        Pattern pattern = Pattern.compile(DIGITS_FLOAT_INT_DBL);
        Matcher matcher = pattern.matcher(Float.toString(vacantLandDetails.getVacantLandArea().floatValue()));
        if (!matcher.matches()) {
            errorDetails.setErrorCode("92");
            errorDetails.setErrorMessage("Please enter valid Vacant Land Area ");
            return errorDetails;
        }
        if (vacantLandDetails.getMarketValue() == null) {
            errorDetails.setErrorCode("10");
            errorDetails.setErrorMessage("Market area Value per Sq.Mtrs (As Per Current Registration department) is required.");
            return errorDetails;
        }
        if (Double.valueOf(vacantLandDetails.getMarketValue()) == 0.0) {
            errorDetails.setErrorCode("62");
            errorDetails.setErrorMessage("Market Value should be greate than 0.");
            return errorDetails;
        }
        pattern = Pattern.compile(DIGITS_FLOAT_INT_DBL);
        matcher = pattern.matcher(Double.toString(vacantLandDetails.getMarketValue()));
        if (!matcher.matches()) {
            errorDetails.setErrorCode("92");
            errorDetails.setErrorMessage("Please enter valid Market Value ");
            return errorDetails;
        }
        if (vacantLandDetails.getCurrentCapitalValue() == null) {
            errorDetails.setErrorCode("11");
            errorDetails.setErrorMessage("Current Capital Value is required.");
            return errorDetails;
        }
        if (Double.valueOf(vacantLandDetails.getCurrentCapitalValue()) == 0.0) {
            errorDetails.setErrorCode("63");
            errorDetails.setErrorMessage("Current Capital Value should be greate than 0.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)vacantLandDetails.getEffectiveDate())) {
            errorDetails.setErrorCode("12");
            errorDetails.setErrorMessage("Effective Date is required.");
            return errorDetails;
        }
        if (vacantLandDetails.getVacantLandPlot() == null) {
            errorDetails.setErrorCode("73");
            errorDetails.setErrorMessage("Vacant Land Area Type is required.");
            return errorDetails;
        }
        if (this.vacantLandPlotAreaRepository.findOne((Serializable)vacantLandDetails.getVacantLandPlot()) == null) {
            errorDetails.setErrorCode("121");
            errorDetails.setErrorMessage("Vacant Plot Area type Doesn't Exists.");
            return errorDetails;
        }
        if (vacantLandDetails.getLayoutApprovalAuthority() == null) {
            errorDetails.setErrorCode("113");
            errorDetails.setErrorMessage("Layout Authority Required.");
            return errorDetails;
        }
        if (this.layoutApprovalAuthorityRepo.findOne((Serializable)vacantLandDetails.getLayoutApprovalAuthority()) == null) {
            errorDetails.setErrorCode("117");
            errorDetails.setErrorMessage("Entered layout authority doesn't exist, Please enter existing one");
            return errorDetails;
        }
        if (vacantLandDetails.getLayoutPermitNumber().isEmpty() && !NO_APPROVAL.equals(((LayoutApprovalAuthority)this.layoutApprovalAuthorityRepo.findOne((Serializable)vacantLandDetails.getLayoutApprovalAuthority())).getName())) {
            errorDetails.setErrorCode("114");
            errorDetails.setErrorMessage("Layout Permit Number Required.");
            return errorDetails;
        }
        if (vacantLandDetails.getLayoutPermitDate().isEmpty() && !NO_APPROVAL.equals(((LayoutApprovalAuthority)this.layoutApprovalAuthorityRepo.findOne((Serializable)vacantLandDetails.getLayoutApprovalAuthority())).getName())) {
            errorDetails.setErrorCode("115");
            errorDetails.setErrorMessage("Layout Permit Date Required.");
            return errorDetails;
        }
        SurroundingBoundaryDetails surBoundaryDetails = createPropDetails.getSurroundingBoundaryDetails();
        if (surBoundaryDetails == null) {
            errorDetails.setErrorCode("41");
            errorDetails.setErrorMessage("Surrounding Boundary Details is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)surBoundaryDetails.getNorthBoundary())) {
            errorDetails.setErrorCode("13");
            errorDetails.setErrorMessage("North is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)surBoundaryDetails.getSouthBoundary())) {
            errorDetails.setErrorCode("14");
            errorDetails.setErrorMessage("South is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)surBoundaryDetails.getEastBoundary())) {
            errorDetails.setErrorCode("15");
            errorDetails.setErrorMessage("East is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)surBoundaryDetails.getWestBoundary())) {
            errorDetails.setErrorCode("16");
            errorDetails.setErrorMessage("East is required.");
            return errorDetails;
        }
        return errorDetails;
    }

    public ErrorDetails validateOwnerDetails(ErrorDetails errorDetails, List<OwnerInformation> ownerDetailsList) {
        if (ownerDetailsList == null) {
            errorDetails.setErrorCode("35");
            errorDetails.setErrorMessage("Owner Details is required.");
            return errorDetails;
        }
        for (OwnerInformation ownerDetails : ownerDetailsList) {
            if (StringUtils.isBlank((CharSequence)ownerDetails.getMobileNumber())) {
                errorDetails.setErrorCode("30");
                errorDetails.setErrorMessage("Mobile Number is required.");
                return errorDetails;
            }
            if (ownerDetails.getMobileNumber().trim().length() != 10) {
                errorDetails.setErrorCode("79");
                errorDetails.setErrorMessage("Maximum of 10 digits can be entered for the mobile number.");
                return errorDetails;
            }
            Pattern pattern = Pattern.compile("\\d{10}");
            Matcher matcher = pattern.matcher(ownerDetails.getMobileNumber());
            if (!matcher.matches()) {
                errorDetails.setErrorCode("78");
                errorDetails.setErrorMessage("Invalid Mobile number.");
                return errorDetails;
            }
            if (StringUtils.isNotBlank((CharSequence)ownerDetails.getEmailId()) && !(matcher = (pattern = Pattern.compile(EMAIL_PATTERN)).matcher(ownerDetails.getEmailId())).matches()) {
                errorDetails.setErrorCode("84");
                errorDetails.setErrorMessage("Invalid Email...");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)ownerDetails.getName())) {
                errorDetails.setErrorCode("30");
                errorDetails.setErrorMessage("Owner Name is required.");
                return errorDetails;
            }
            pattern = Pattern.compile("\\w+\\.?");
            matcher = pattern.matcher(ownerDetails.getMobileNumber());
            if (!matcher.matches()) {
                errorDetails.setErrorCode("51");
                errorDetails.setErrorMessage("Invalid Owner Name");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)ownerDetails.getGender())) {
                errorDetails.setErrorCode("31");
                errorDetails.setErrorMessage("Gender is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)ownerDetails.getGuardianRelation())) {
                errorDetails.setErrorCode("32");
                errorDetails.setErrorMessage("Guardian Relation is required.");
                return errorDetails;
            }
            pattern = Pattern.compile(CAMEL_CASE_PATTERN);
            matcher = pattern.matcher(ownerDetails.getGuardianRelation());
            if (!matcher.matches()) {
                errorDetails.setErrorCode("100");
                errorDetails.setErrorMessage("Invalid Guardian Relation");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)ownerDetails.getGuardian())) {
                errorDetails.setErrorCode("33");
                errorDetails.setErrorMessage("Guardian is required.");
                return errorDetails;
            }
            pattern = Pattern.compile(GUARDIAN_PATTERN);
            matcher = pattern.matcher(ownerDetails.getGuardian());
            if (matcher.matches()) continue;
            errorDetails.setErrorCode("86");
            errorDetails.setErrorMessage("Invalid Guardian Name");
            return errorDetails;
        }
        return errorDetails;
    }

    public ErrorDetails validatePaymentDetails(PayPropertyTaxDetails payPropTaxDetails, boolean isMutationFeePayment, String propertyType) {
        BillReceiptInfo billReceiptList;
        ErrorDetails errorDetails = null;
        if (payPropTaxDetails.getAssessmentNo() == null || payPropTaxDetails.getAssessmentNo().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-12");
            errorDetails.setErrorMessage("Assessment number is required");
        } else {
            Property property;
            BasicProperty basicProperty;
            if (payPropTaxDetails.getAssessmentNo().trim().length() > 0 && payPropTaxDetails.getAssessmentNo().trim().length() < 10) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-8");
                errorDetails.setErrorMessage("Assessment number length can not less than 10 digits");
            }
            if (!this.basicPropertyDAO.isAssessmentNoExist(payPropTaxDetails.getAssessmentNo()).booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-11");
                errorDetails.setErrorMessage("Assessment number not found");
            }
            if ((basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(payPropTaxDetails.getAssessmentNo())) != null && (property = basicProperty.getProperty()) != null && property.getIsExemptedFromTax().booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-42");
                errorDetails.setErrorMessage("Property is Exempted");
            }
        }
        if (this.paymentAmountHasDecimals(payPropTaxDetails.getPaymentAmount()).booleanValue()) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-47");
            errorDetails.setErrorMessage("Paid amount in decimal is not accepted.");
        }
        if (isMutationFeePayment) {
            PropertyMutation propertyMutation;
            if (!this.propertyExternalService.validateMutationFee(payPropTaxDetails.getAssessmentNo(), payPropTaxDetails.getPaymentAmount())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-40");
                errorDetails.setErrorMessage("Mutation fee entered is excess");
            }
            if ((propertyMutation = this.propertyExternalService.getLatestPropertyMutationByAssesmentNo(payPropTaxDetails.getAssessmentNo())) == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-41");
                errorDetails.setErrorMessage("There are no mutations done for this assessment number");
            }
        }
        if (payPropTaxDetails.getTransactionId() == null || "".equals(payPropTaxDetails.getTransactionId())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-25");
            errorDetails.setErrorMessage("Invalid Request, No transaction ID is associated");
        } else if (!(payPropTaxDetails.getTransactionId() == null && "".equals(payPropTaxDetails.getTransactionId()) || (billReceiptList = this.propertyExternalService.validateTransanctionIdPresent(payPropTaxDetails.getTransactionId(), propertyType)) == null)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-26");
            errorDetails.setErrorMessage("Invalid Request, Used transaction ID is associated");
        }
        if (payPropTaxDetails.getPaymentMode() == null || payPropTaxDetails.getPaymentMode().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-13");
            errorDetails.setErrorMessage("Payment mode is required");
        } else if (!("CASH".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()) || "CHEQUE".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-14");
            errorDetails.setErrorMessage("Payment mode is invalid");
        }
        if (payPropTaxDetails.getPaymentMode() != null && ("CHEQUE".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()))) {
            if (payPropTaxDetails.getChqddNo() == null || payPropTaxDetails.getChqddNo().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-34");
                errorDetails.setErrorMessage("Cheque/DD number is required");
            } else if (payPropTaxDetails.getChqddDate() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-35");
                errorDetails.setErrorMessage("Cheque/DD Date is required");
            } else if (payPropTaxDetails.getBankName() == null || payPropTaxDetails.getBankName().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-36");
                errorDetails.setErrorMessage("Bank Name is required");
            } else if (payPropTaxDetails.getBranchName() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-37");
                errorDetails.setErrorMessage("Branch Name  is required");
            }
        }
        return errorDetails;
    }

    public Boolean paymentAmountHasDecimals(BigDecimal amount) {
        return amount.remainder(BigDecimal.ONE).compareTo(BigDecimal.ZERO) != 0;
    }

    public ErrorDetails validateAssessmentDetailsRequest(AssessmentRequest assessmentRequest) {
        ErrorDetails errorDetails = null;
        BasicProperty basicProperty = this.propertyExternalService.fetchBasicProperty(assessmentRequest.getAssessmentNo(), assessmentRequest.getOldAssessmentNo());
        if (basicProperty == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-11");
            errorDetails.setErrorMessage("Assessment number not found");
        }
        return errorDetails;
    }

    public ErrorDetails validateSurveyRequest(AssessmentRequest assessmentRequest) throws ParseException {
        Long propertiesCount;
        ErrorDetails errorDetails = null;
        if (StringUtils.isBlank((CharSequence)assessmentRequest.getTransactionType())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("80");
            errorDetails.setErrorMessage("Transaction type is required.");
        } else if (StringUtils.isBlank((CharSequence)assessmentRequest.getFromDate())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("81");
            errorDetails.setErrorMessage("From date is required.");
        } else if (StringUtils.isBlank((CharSequence)assessmentRequest.getToDate())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("82");
            errorDetails.setErrorMessage("To date is required.");
        }
        if (StringUtils.isNotBlank((CharSequence)assessmentRequest.getTransactionType()) && StringUtils.isNotBlank((CharSequence)assessmentRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)assessmentRequest.getToDate()) && (propertiesCount = this.propertyExternalService.getPropertiesCount(assessmentRequest.getTransactionType(), assessmentRequest.getFromDate(), assessmentRequest.getToDate())) > 100L) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("83");
            errorDetails.setErrorMessage("More than 100 records found, please narrow the search criteria.");
        }
        return errorDetails;
    }

    public ErrorDetails validateUpdateRequest(CreatePropertyDetails createPropDetails, String mode) throws ParseException {
        ErrorDetails errorDetails = new ErrorDetails();
        BasicProperty bp = this.propertyExternalService.getBasicPropertyByPropertyID(createPropDetails.getAssessmentNumber());
        if (bp.isUnderWorkflow()) {
            errorDetails.setErrorCode("102");
            errorDetails.setErrorMessage("Property is Under workflow");
            return errorDetails;
        }
        Property prop = this.propertyExternalService.getPropertyByBasicPropertyID(bp);
        if (prop.getStatus().equals(PropertyTaxConstants.STATUS_DEMAND_INACTIVE)) {
            errorDetails.setErrorCode("101");
            errorDetails.setErrorMessage("Demand is Inactive Foe given Property");
            return errorDetails;
        }
        errorDetails = this.validateCreateRequest(createPropDetails, mode);
        if (errorDetails != null && errorDetails.getErrorCode() != null) {
            return errorDetails;
        }
        if (!bp.getActiveProperty().getPropertyDetail().getCategoryType().equals("VACANTLAND") && createPropDetails.getPropertyTypeMasterCode().equalsIgnoreCase("VAC_LAND")) {
            errorDetails.setErrorCode("116");
            errorDetails.setErrorMessage("Non-Vacant Property cannot be converted to Vacant land");
            return errorDetails;
        }
        return errorDetails;
    }

    public ErrorDetails validateBoundaries(PropertyAddressDetails propertyAddressDetails, ErrorDetails errorDetails, String mode) {
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getElectionWardNum())) {
            errorDetails.setErrorCode("72");
            errorDetails.setErrorMessage("Election Ward is required.");
            return errorDetails;
        }
        if (!this.propertyExternalService.isBoundaryActive(propertyAddressDetails.getElectionWardNum(), "Ward", "ADMINISTRATION").booleanValue()) {
            errorDetails.setErrorCode("107");
            errorDetails.setErrorMessage("Selected Election Ward is Inactive");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getLocalityNum())) {
            errorDetails.setErrorCode("26");
            errorDetails.setErrorMessage("Locality is required.");
            return errorDetails;
        }
        if (!this.propertyExternalService.isBoundaryActive(propertyAddressDetails.getLocalityNum(), "Locality", "LOCATION").booleanValue()) {
            errorDetails.setErrorCode("104");
            errorDetails.setErrorMessage("Selected Locality is Inactive");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getBlockNum())) {
            errorDetails.setErrorCode("29");
            errorDetails.setErrorMessage("Block no is required.");
            return errorDetails;
        }
        if (!this.propertyExternalService.isBoundaryActive(propertyAddressDetails.getBlockNum(), "Block", "REVENUE").booleanValue()) {
            errorDetails.setErrorCode("105");
            errorDetails.setErrorMessage("Selected Block is Inactive");
        }
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getZoneNum()) && !"modify".equalsIgnoreCase(mode)) {
            errorDetails.setErrorCode("27");
            errorDetails.setErrorMessage("Zone no is required.");
            return errorDetails;
        }
        if (!this.propertyExternalService.isBoundaryActive(propertyAddressDetails.getZoneNum(), "Zone", "REVENUE").booleanValue()) {
            errorDetails.setErrorCode("103");
            errorDetails.setErrorMessage("Selected Zone is Inactive");
        }
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getWardNum())) {
            errorDetails.setErrorCode("28");
            errorDetails.setErrorMessage("Zone no is required.");
            return errorDetails;
        }
        if (!this.propertyExternalService.isBoundaryActive(propertyAddressDetails.getWardNum(), "Ward", "REVENUE").booleanValue()) {
            errorDetails.setErrorCode("106");
            errorDetails.setErrorMessage("Selected ward is Inactive");
        }
        return errorDetails;
    }

    public ErrorDetails validateCrossHierarchyMapping(Boundary locality, Boundary ward, Boundary block, ErrorDetails errorDetails) {
        BoundaryType wardBoundaryType = this.propertyExternalService.getBoundaryTypeByNameandHierarchy("Ward", "REVENUE");
        Boolean isMapping = this.propertyExternalService.isCrossHierarchyMappingExist(locality.getId(), ward.getId(), block.getId(), wardBoundaryType.getId());
        if (!isMapping.booleanValue()) {
            errorDetails.setErrorCode("111");
            errorDetails.setErrorMessage("There is No Mapping Found for selected Locality , Block and Ward");
        }
        return errorDetails;
    }

    public ErrorDetails validateTaxCalculatorRequest(TaxCalculatorRequest taxCalculatorRequest) {
        ErrorDetails errorDetails = null;
        BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyForUpicNoOrOldUpicNo(taxCalculatorRequest.getAssessmentNo(), null);
        if (basicProperty == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-11");
            errorDetails.setErrorMessage("Assessment number not found");
            return errorDetails;
        }
        Property property = basicProperty.getProperty();
        if (property != null) {
            if ("VAC_LAND".equalsIgnoreCase(property.getPropertyDetail().getPropertyTypeMaster().getCode())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("122");
                errorDetails.setErrorMessage("Given assessment number belongs to a vacant land");
                return errorDetails;
            }
            errorDetails = this.validateFloorDetailsForTaxCalculation(taxCalculatorRequest.getFloorDetails());
            if (errorDetails != null && StringUtils.isNotBlank((CharSequence)errorDetails.getErrorCode())) {
                return errorDetails;
            }
        }
        return errorDetails;
    }

    private ErrorDetails validateFloorDetailsForTaxCalculation(List<FloorDetails> floorDetailsList) {
        ErrorDetails errorDetails = new ErrorDetails();
        if (floorDetailsList.isEmpty()) {
            errorDetails.setErrorCode("40");
            errorDetails.setErrorMessage("Floor Details is required.");
        } else {
            for (FloorDetails floorDetails : floorDetailsList) {
                errorDetails = this.validateStructureClassification(floorDetails);
                if (StringUtils.isNotBlank((CharSequence)errorDetails.getErrorCode())) {
                    return errorDetails;
                }
                errorDetails = this.validateFloorUsage(floorDetails);
                if (StringUtils.isNotBlank((CharSequence)errorDetails.getErrorCode())) {
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getOccupancyCode())) {
                    errorDetails.setErrorCode("20");
                    errorDetails.setErrorMessage("Occupancy is required.");
                    return errorDetails;
                }
                if (!StringUtils.isBlank((CharSequence)floorDetails.getConstructionDate())) continue;
                errorDetails.setErrorCode("21");
                errorDetails.setErrorMessage("Construction Date is required.");
                return errorDetails;
            }
        }
        return errorDetails;
    }

    private ErrorDetails validateStructureClassification(FloorDetails floorDetails) {
        ErrorDetails errorDetails = new ErrorDetails();
        if (StringUtils.isBlank((CharSequence)floorDetails.getBuildClassificationCode())) {
            errorDetails.setErrorCode("18");
            errorDetails.setErrorMessage("Building Classification is required.");
            return errorDetails;
        }
        Boolean classification = this.structureClassificationService.isActiveClassification(floorDetails.getBuildClassificationCode());
        if (classification == null) {
            errorDetails.setErrorCode("23");
            errorDetails.setErrorMessage("Building Classification doesn't exist");
            return errorDetails;
        }
        if (!classification.booleanValue()) {
            errorDetails.setErrorCode("109");
            errorDetails.setErrorMessage("Building Classification is Inactive");
            return errorDetails;
        }
        return errorDetails;
    }

    private ErrorDetails validateFloorUsage(FloorDetails floorDetails) {
        ErrorDetails errorDetails = new ErrorDetails();
        if (StringUtils.isBlank((CharSequence)floorDetails.getNatureOfUsageCode())) {
            errorDetails.setErrorCode("19");
            errorDetails.setErrorMessage("Nature of Usage is required.");
            return errorDetails;
        }
        Boolean usage = this.propertyUsageService.isActiveUsage(floorDetails.getNatureOfUsageCode());
        if (usage == null) {
            errorDetails.setErrorCode("24");
            errorDetails.setErrorMessage("Nature of Usage doesn't exist");
            return errorDetails;
        }
        if (!usage.booleanValue()) {
            errorDetails.setErrorCode("108");
            errorDetails.setErrorMessage("Usage Code is Inactive");
            return errorDetails;
        }
        return errorDetails;
    }
}

