/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.service;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.BoundaryType;
import org.egov.infra.admin.master.repository.BoundaryRepository;
import org.egov.infra.admin.master.repository.BoundaryTypeRepository;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.restapi.web.contracts.tradelicense.LicenseCreateRequest;
import org.egov.tl.entity.License;
import org.egov.tl.entity.Licensee;
import org.egov.tl.entity.NatureOfBusiness;
import org.egov.tl.entity.TradeLicense;
import org.egov.tl.entity.WorkflowBean;
import org.egov.tl.repository.LicenseCategoryRepository;
import org.egov.tl.repository.LicenseSubCategoryRepository;
import org.egov.tl.repository.NatureOfBusinessRepository;
import org.egov.tl.service.LicenseApplicationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class LicenseCreateAPIService {
    @Autowired
    private LicenseApplicationService licenseApplicationService;
    @Autowired
    private BoundaryRepository boundaryRepository;
    @Autowired
    private LicenseCategoryRepository licenseCategoryRepository;
    @Autowired
    private LicenseSubCategoryRepository licenseSubCategoryRepository;
    @Autowired
    private NatureOfBusinessRepository natureOfBusinessRepository;
    @Autowired
    private BoundaryTypeRepository boundaryTypeRepository;
    @Autowired
    private CrossHierarchyService crossHierarchyService;

    public License createLicense(LicenseCreateRequest license) {
        TradeLicense tradeLicense = new TradeLicense();
        Licensee licensee = new Licensee();
        licensee.setMobilePhoneNumber(license.getMobilePhoneNumber());
        if (StringUtils.isNotBlank((String)license.getAadhaarNumber())) {
            licensee.setUid(license.getAadhaarNumber());
        }
        licensee.setApplicantName(license.getApplicantName());
        licensee.setFatherOrSpouseName(license.getFatherOrSpouseName());
        licensee.setAddress(license.getLicenseeAddress());
        licensee.setEmailId(license.getEmailId());
        tradeLicense.setNewWorkflow(true);
        tradeLicense.setLicensee(licensee);
        tradeLicense.setApplicationDate(new Date());
        tradeLicense.setAddress(license.getTradeAddress());
        tradeLicense.setNameOfEstablishment(license.getTradeTitle());
        tradeLicense.setTradeArea_weight(license.getTradeMeasure());
        tradeLicense.setCommencementDate(license.getCommencementDate());
        tradeLicense.setNameOfEstablishment(license.getApplicantName());
        tradeLicense.setOwnershipType(license.getOwnershipType());
        if (StringUtils.isNotBlank((String)license.getAssessmentNo())) {
            tradeLicense.setAssessmentNo(license.getAssessmentNo());
        }
        if (StringUtils.isNotBlank((String)license.getRemarks())) {
            tradeLicense.setRemarks(license.getRemarks());
        }
        if (license.getAgreementDate() != null && StringUtils.isNotBlank((String)license.getAgreementDocNo())) {
            tradeLicense.setAgreementDate(license.getAgreementDate());
            tradeLicense.setAgreementDocNo(license.getAgreementDocNo());
        }
        tradeLicense.setNatureOfBusiness((NatureOfBusiness)this.natureOfBusinessRepository.findOne((Serializable)license.getNatureOfBusiness()));
        BoundaryType locality = this.boundaryTypeRepository.findByNameAndHierarchyTypeName("Locality", "LOCATION");
        Boundary childBoundary = this.boundaryRepository.findByBoundaryTypeAndBoundaryNum(locality, license.getBoundary());
        BoundaryType blockType = this.boundaryTypeRepository.findByNameAndHierarchyTypeName("Block", "REVENUE");
        List blocks = this.crossHierarchyService.getParentBoundaryByChildBoundaryAndParentBoundaryType(childBoundary.getId(), blockType.getId());
        blocks.stream().forEach(boundary -> {
            if (boundary.getParent().getBoundaryNum().equals(license.getParentBoundary())) {
                tradeLicense.setParentBoundary(boundary.getParent());
            }
        });
        tradeLicense.setBoundary(childBoundary);
        tradeLicense.setCategory(this.licenseCategoryRepository.findByCodeIgnoreCase(license.getCategory()));
        tradeLicense.setTradeName(this.licenseSubCategoryRepository.findByCode(license.getSubCategory()));
        return this.licenseApplicationService.create(tradeLicense, new WorkflowBean());
    }
}

