/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.council.entity.CouncilMeeting;
import org.egov.council.entity.MeetingMOM;
import org.egov.infra.utils.DateUtils;
import org.egov.restapi.model.CouncilAgendaItems;
import org.egov.restapi.model.CouncilMeetingDetails;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CouncilMeetingDetailService {
    @PersistenceContext
    private EntityManager entityManager;

    public List<CouncilMeeting> getMeetingDetailsByMeetingNo(String meetingNumber, String meetingType) {
        StringBuilder queryString = new StringBuilder();
        queryString.append(" from CouncilMeeting C where C.committeeType.isActive=true");
        if (meetingNumber != null) {
            queryString.append(" and C.meetingNumber =:meetingNumber ");
        }
        if (meetingType != null) {
            queryString.append(" and C.committeeType.name =:meetingType ");
        }
        Query query = ((Session)this.entityManager.unwrap(Session.class)).createQuery(queryString.toString());
        if (meetingNumber != null) {
            query.setParameter("meetingNumber", (Object)meetingNumber);
        }
        if (meetingType != null) {
            query.setParameter("meetingType", (Object)meetingType);
        }
        return query.list();
    }

    public List<CouncilMeetingDetails> getCouncilMeetingDetailsList(List<CouncilMeeting> councilMeetingList) {
        ArrayList<CouncilMeetingDetails> councilMeetingDetailsList = new ArrayList<CouncilMeetingDetails>();
        for (CouncilMeeting councilMeeting : councilMeetingList) {
            CouncilMeetingDetails councilMeetingDetails = new CouncilMeetingDetails();
            councilMeetingDetails.setMeetingDate(DateUtils.getDefaultFormattedDate((Date)councilMeeting.getMeetingDate()));
            councilMeetingDetails.setMeetingNo(councilMeeting.getMeetingNumber());
            councilMeetingDetails.setMeetingPlace(councilMeeting.getMeetingLocation());
            councilMeetingDetails.setMeetingTime(councilMeeting.getMeetingTime());
            councilMeetingDetails.setMeetingType(councilMeeting.getCommitteeType().getName());
            List meetingMomList = councilMeeting.getMeetingMOMs();
            ArrayList<CouncilAgendaItems> councilAgendaItemsList = new ArrayList<CouncilAgendaItems>();
            for (MeetingMOM meetingMOM : meetingMomList) {
                CouncilAgendaItems councilAgendaItems = new CouncilAgendaItems();
                councilAgendaItems.setAgendaNo(meetingMOM.getAgenda().getAgendaNumber());
                councilAgendaItems.setDepartment(meetingMOM.getPreamble().getDepartment().getName());
                councilAgendaItems.setGistOfPreamble(meetingMOM.getPreamble().getGistOfPreamble());
                councilAgendaItems.setSerialNo(meetingMOM.getItemNumber());
                councilAgendaItems.setPreambleNo(meetingMOM.getPreamble().getPreambleNumber());
                councilAgendaItems.setResolution(meetingMOM.getResolutionDetail() != null ? meetingMOM.getResolutionDetail() : "");
                councilAgendaItems.setResolutionNo(meetingMOM.getResolutionNumber() != null ? meetingMOM.getResolutionNumber() : "");
                councilAgendaItems.setStatus(meetingMOM.getResolutionStatus() != null ? meetingMOM.getResolutionStatus().getCode() : "");
                councilAgendaItems.setSanctionAmount(meetingMOM.getPreamble().getSanctionAmount() != null ? meetingMOM.getPreamble().getSanctionAmount() : BigDecimal.ZERO);
                councilAgendaItemsList.add(councilAgendaItems);
            }
            councilMeetingDetails.setAgendaItems(councilAgendaItemsList);
            councilMeetingDetailsList.add(councilMeetingDetails);
        }
        return councilMeetingDetailsList;
    }
}

