/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.service.FunctionService;
import org.egov.commons.service.FundService;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.restapi.model.BudgetCheck;
import org.egov.restapi.model.RestErrors;
import org.egov.services.budget.BudgetGroupService;
import org.egov.services.masters.SchemeService;
import org.egov.services.masters.SubSchemeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BudgetCheckService {
    @Autowired
    private FundService fundService;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private SubSchemeService subSchemeService;
    @Autowired
    private BudgetGroupService budgetGroupService;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    private DepartmentService departmentService;

    public List<RestErrors> validateMandatoryFields(BudgetCheck budgetCheck) {
        RestErrors restErrors;
        ArrayList<RestErrors> errors = new ArrayList<RestErrors>();
        if (StringUtils.isBlank((String)budgetCheck.getDepartmentCode()) || this.departmentService.getDepartmentByCode(budgetCheck.getDepartmentCode()) == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-1");
            restErrors.setErrorMessage("No Department exists with the given department code");
            errors.add(restErrors);
        }
        if (StringUtils.isBlank((String)budgetCheck.getFunctionCode()) || this.functionService.findByCode(budgetCheck.getFunctionCode()) == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-2");
            restErrors.setErrorMessage("No Function exists with the given function code");
            errors.add(restErrors);
        }
        if (StringUtils.isBlank((String)budgetCheck.getFundCode()) || this.fundService.findByCode(budgetCheck.getFundCode()) == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-6");
            restErrors.setErrorMessage("No Fund exists with the given fund code");
            errors.add(restErrors);
        }
        if (StringUtils.isBlank((String)budgetCheck.getBudgetHeadName()) || this.budgetGroupService.getBudgetGroupByName(budgetCheck.getBudgetHeadName()) == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-7");
            restErrors.setErrorMessage("No Budget Head exists with the given Budget Head code");
            errors.add(restErrors);
        }
        return errors;
    }

    public String getPlanningBudgetAvailable(BudgetCheck budgetCheck) {
        Scheme scheme = this.schemeService.findByCode(budgetCheck.getSchemeCode());
        SubScheme subScheme = this.subSchemeService.findByCode(budgetCheck.getSubSchemeCode());
        ArrayList<Long> budgetheadid = new ArrayList<Long>();
        budgetheadid.add(this.budgetGroupService.getBudgetGroupByName(budgetCheck.getBudgetHeadName()).getId());
        BigDecimal budgetAvailable = this.budgetDetailsDAO.getPlanningBudgetAvailable(this.financialYearHibernateDAO.getFinYearByDate(new Date()).getId(), Integer.valueOf(Integer.parseInt(this.departmentService.getDepartmentByCode(budgetCheck.getDepartmentCode()).getId().toString())), this.functionService.findByCode(budgetCheck.getFunctionCode()).getId(), null, scheme == null ? null : Integer.valueOf(Integer.parseInt(scheme.getId().toString())), subScheme == null ? null : Integer.valueOf(Integer.parseInt(subScheme.getId().toString())), null, budgetheadid, Integer.valueOf(Integer.parseInt(this.fundService.findByCode(budgetCheck.getFundCode()).getId().toString())));
        return budgetAvailable.toString();
    }
}

