/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.dcb.bean.ChequePayment;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.model.bills.EgBillregister;
import org.egov.restapi.model.BillRegister;
import org.egov.restapi.model.RestErrors;
import org.egov.restapi.service.BillService;
import org.egov.restapi.util.JsonConvertor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CreateBillController {
    private static final Logger LOG = Logger.getLogger(CreateBillController.class);
    @Autowired
    private BillService billService;

    @RequestMapping(value={"/egf/bill"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String createContractorBill(@RequestBody String requestJson, HttpServletResponse response) {
        String responseJson;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rest API creating bill with the data: " + requestJson));
        }
        ApplicationThreadLocals.setUserId((Long)2L);
        BillRegister billRegister = null;
        JsonObject jsonObject = new JsonObject();
        try {
            billRegister = (BillRegister)this.getObjectFromJSONRequest(requestJson, BillRegister.class);
        }
        catch (IOException e) {
            LOG.error((Object)e.getStackTrace());
            ArrayList<RestErrors> errorList = new ArrayList<RestErrors>(0);
            RestErrors re = new RestErrors();
            re.setErrorCode(e.getMessage());
            re.setErrorMessage(e.getMessage());
            errorList.add(re);
            response.setStatus(400);
            return JsonConvertor.convert(errorList);
        }
        try {
            List errors = this.billService.validateBillRegister(billRegister);
            if (!errors.isEmpty()) {
                response.setStatus(400);
                return JsonConvertor.convert((Object)errors);
            }
            EgBillregister egBillregister = new EgBillregister();
            this.billService.createProjectCode(billRegister);
            this.billService.populateBillRegister(egBillregister, billRegister);
            EgBillregister savedBillregister = this.billService.createBill(egBillregister);
            responseJson = savedBillregister.getBillnumber();
        }
        catch (ValidationException e) {
            LOG.error((Object)e.getStackTrace());
            ArrayList<RestErrors> errorList = new ArrayList<RestErrors>(0);
            List errors = e.getErrors();
            for (ValidationError ve : errors) {
                RestErrors re = new RestErrors();
                re.setErrorCode(ve.getKey());
                re.setErrorMessage(ve.getMessage());
                errorList.add(re);
            }
            response.setStatus(400);
            return JsonConvertor.convert(errorList);
        }
        catch (Exception e) {
            LOG.error((Object)e.getStackTrace());
            ArrayList<RestErrors> errorList = new ArrayList<RestErrors>(0);
            RestErrors re = new RestErrors();
            re.setErrorCode(e.getMessage());
            re.setErrorMessage(e.getMessage());
            errorList.add(re);
            response.setStatus(400);
            return JsonConvertor.convert(errorList);
        }
        jsonObject.addProperty("successMessage", "Works Bill created Successfully");
        jsonObject.addProperty("billNumber", responseJson);
        response.setStatus(201);
        return jsonObject.toString();
    }

    private Object getObjectFromJSONRequest(String jsonString, Class cls) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        mapper.setDateFormat((DateFormat)ChequePayment.CHEQUE_DATE_FORMAT);
        return mapper.readValue(jsonString, cls);
    }
}

