/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFunction;
import org.egov.commons.Fund;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.ChartOfAccountsDAO;
import org.egov.commons.service.AccountPurposeService;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.commons.service.FunctionService;
import org.egov.commons.service.FundService;
import org.egov.model.budget.BudgetGroup;
import org.egov.model.service.BudgetingGroupService;
import org.egov.restapi.model.BudgetGroupHelper;
import org.egov.restapi.model.ChartOfAccountHelper;
import org.egov.restapi.model.FunctionHelper;
import org.egov.restapi.model.FundHelper;
import org.egov.restapi.model.SchemeHelper;
import org.egov.restapi.model.SubSchemeHelper;
import org.egov.services.masters.SchemeService;
import org.egov.services.masters.SubSchemeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FinancialMasterService {
    @Autowired
    private FundService fundService;
    @Autowired
    private SubSchemeService subSchemeService;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private AccountPurposeService accountPurposeService;
    @Autowired
    private BudgetingGroupService budgetingGroupService;
    @Autowired
    private ChartOfAccountsDAO chartOfAccountsDAO;

    public List<FunctionHelper> populateFunction() {
        List cFunctions = this.functionService.findAllActive();
        ArrayList<FunctionHelper> functionHelpers = new ArrayList<FunctionHelper>();
        for (CFunction cFunction : cFunctions) {
            this.createFunctionHelper(functionHelpers, cFunction);
        }
        return functionHelpers;
    }

    private void createFunctionHelper(List<FunctionHelper> functionHelpers, CFunction cFunction) {
        FunctionHelper functionHelper = new FunctionHelper();
        functionHelper.setCode(cFunction.getCode());
        functionHelper.setName(cFunction.getName());
        functionHelpers.add(functionHelper);
    }

    public List<SchemeHelper> populateScheme() {
        List schemes = this.schemeService.getByIsActive();
        ArrayList<SchemeHelper> schemeHelpers = new ArrayList<SchemeHelper>();
        for (Scheme scheme : schemes) {
            this.createSchemeHelper(schemeHelpers, scheme);
        }
        return schemeHelpers;
    }

    private void createSchemeHelper(List<SchemeHelper> schemeHelpers, Scheme scheme) {
        SchemeHelper schemeHelper = new SchemeHelper();
        schemeHelper.setCode(scheme.getCode());
        schemeHelper.setName(scheme.getName());
        schemeHelper.setDescription(scheme.getDescription());
        schemeHelper.setValidFrom(scheme.getValidfrom());
        schemeHelper.setValidTo(scheme.getValidto());
        schemeHelper.setFund(scheme.getFund().getName());
        schemeHelpers.add(schemeHelper);
    }

    public List<SubSchemeHelper> populateSubScheme() {
        List subSchemes = this.subSchemeService.getByIsActive();
        ArrayList<SubSchemeHelper> subSchemeHelpers = new ArrayList<SubSchemeHelper>();
        for (SubScheme subScheme : subSchemes) {
            this.createSubSchemeHelper(subSchemeHelpers, subScheme);
        }
        return subSchemeHelpers;
    }

    private void createSubSchemeHelper(List<SubSchemeHelper> subSchemeHelpers, SubScheme subScheme) {
        SubSchemeHelper subSchemeHelper = new SubSchemeHelper();
        subSchemeHelper.setCode(subScheme.getCode());
        subSchemeHelper.setName(subScheme.getName());
        subSchemeHelper.setScheme(subScheme.getScheme().getName());
        subSchemeHelpers.add(subSchemeHelper);
    }

    public List<FundHelper> populateFund() {
        List funds = this.fundService.findAllActiveAndIsnotleaf();
        ArrayList<FundHelper> fundHelpers = new ArrayList<FundHelper>();
        for (Fund fund : funds) {
            this.createFundHelper(fundHelpers, fund);
        }
        return fundHelpers;
    }

    private void createFundHelper(List<FundHelper> fundHelpers, Fund fund) {
        FundHelper fundHelper = new FundHelper();
        fundHelper.setCode(fund.getCode());
        fundHelper.setName(fund.getName());
        fundHelpers.add(fundHelper);
    }

    public List<ChartOfAccountHelper> populateChartOfAccounts() {
        List cChartOfAccounts = this.chartOfAccountsService.getAllAccountCodesByIsactiveAndClassification();
        ArrayList<ChartOfAccountHelper> chartOfAccountHelpers = new ArrayList<ChartOfAccountHelper>();
        for (CChartOfAccounts cChartOfAccount : cChartOfAccounts) {
            this.createChartOfAccountHelper(chartOfAccountHelpers, cChartOfAccount);
        }
        return chartOfAccountHelpers;
    }

    private void createChartOfAccountHelper(List<ChartOfAccountHelper> chartOfAccountHelpers, CChartOfAccounts cChartOfAccount) {
        ChartOfAccountHelper chartOfAccountHelper = new ChartOfAccountHelper();
        chartOfAccountHelper.setGlCode(cChartOfAccount.getGlcode());
        chartOfAccountHelper.setName(cChartOfAccount.getName());
        if (cChartOfAccount.getPurposeId() != null) {
            chartOfAccountHelper.setPurpose(this.accountPurposeService.getByPurposeId(cChartOfAccount.getPurposeId()).getName());
        } else {
            chartOfAccountHelper.setPurpose("");
        }
        chartOfAccountHelper.setType(cChartOfAccount.getType());
        if (cChartOfAccount.getBudgetCheckReq() != null) {
            chartOfAccountHelper.setBudgetCheckReqired(cChartOfAccount.getBudgetCheckReq().booleanValue());
        } else {
            chartOfAccountHelper.setBudgetCheckReqired(Boolean.FALSE.booleanValue());
        }
        if (cChartOfAccount.getFunctionReqd() != null) {
            chartOfAccountHelper.setFunctionReqired(cChartOfAccount.getFunctionReqd().booleanValue());
        } else {
            chartOfAccountHelper.setFunctionReqired(Boolean.FALSE.booleanValue());
        }
        chartOfAccountHelper.initializeArray(cChartOfAccount.getChartOfAccountDetails().size());
        int i = 0;
        for (CChartOfAccountDetail accountDetail : cChartOfAccount.getChartOfAccountDetails()) {
            chartOfAccountHelper.addSubledger(accountDetail.getDetailTypeId().getName(), i);
            ++i;
        }
        chartOfAccountHelpers.add(chartOfAccountHelper);
    }

    public List<BudgetGroupHelper> populateBudgetGroup() throws Exception {
        List budgetGroups = this.budgetingGroupService.getActiveBudgetGroups();
        ArrayList<BudgetGroupHelper> budgetGroupHelpers = new ArrayList<BudgetGroupHelper>();
        for (BudgetGroup budgetGroup : budgetGroups) {
            this.createBudgetGroupHelper(budgetGroupHelpers, budgetGroup);
        }
        return budgetGroupHelpers;
    }

    private void createBudgetGroupHelper(List<BudgetGroupHelper> budgetGroupHelpers, BudgetGroup budgetGroup) throws Exception {
        BudgetGroupHelper budgetGroupHelper = new BudgetGroupHelper();
        if (budgetGroup.getMinCode() != null && budgetGroup.getMaxCode() != null && budgetGroup.getMinCode().equals((Object)budgetGroup.getMaxCode())) {
            budgetGroupHelper.initializeArray(1);
            budgetGroupHelper.addAccountCode(budgetGroup.getMaxCode().getGlcode(), 0);
        } else {
            List accountCodes = this.chartOfAccountsDAO.getGlcode(budgetGroup.getMinCode() != null ? budgetGroup.getMinCode().getId().toString() : "", budgetGroup.getMaxCode() != null ? budgetGroup.getMaxCode().getId().toString() : "", budgetGroup.getMajorCode() != null ? budgetGroup.getMajorCode().getId().toString() : "");
            budgetGroupHelper.initializeArray(accountCodes.size());
            budgetGroupHelper.setAccountCode((String[])accountCodes.toArray());
        }
        budgetGroupHelper.setName(budgetGroup.getName());
        budgetGroupHelpers.add(budgetGroupHelper);
    }
}

