/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.restapi.model.ContractorHelper;
import org.egov.restapi.model.RestErrors;
import org.egov.works.master.service.ContractorService;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.masters.ContractorDetail;
import org.egov.works.models.masters.ExemptionForm;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ExternalContractorService {
    protected static final String ALPHANUMERICWITHSPECIALCHAR = "[0-9a-zA-Z-& :,/.()@]+";
    protected static final String ALPHANUMERICWITHALLSPECIALCHAR = "[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+";
    protected static final String EMAIL = "^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    protected static final String ALPHANUMERIC_WITHSPACE = "[0-9a-zA-Z ]+";
    protected static final String WORKS_CONTRACTOR_STATUS = "Contractor";
    protected static final String PANNUMBER = "[a-zA-Z]{5}[0-9]{4}[a-zA-Z]{1}";
    protected static final String ALPHANUMERIC = "[0-9a-zA-Z]+";
    protected static final String MOBILE_NUM = "^((\\+)?(\\d{2}[-]))?(\\d{10}){1}?$";
    @Autowired
    private ContractorService contractorService;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;

    public ContractorHelper populateContractorData(Contractor contractor) {
        return this.createContractorData(contractor);
    }

    public List<RestErrors> validateContactorToCreate(ContractorHelper contractorHelper) {
        Contractor existingContractor;
        ArrayList<RestErrors> errors = new ArrayList();
        RestErrors restErrors = null;
        errors = this.validateMandatoryFields(contractorHelper, errors);
        if (contractorHelper.getCode() != null && (existingContractor = this.contractorService.getContractorByCode(contractorHelper.getCode())) != null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-2");
            restErrors.setErrorMessage("Contractor exists with given contractor code");
            errors.add(restErrors);
        }
        return errors;
    }

    private List<RestErrors> validateMandatoryFields(ContractorHelper contractorHelper, List<RestErrors> errors) {
        RestErrors restErrors = null;
        if (StringUtils.isBlank((String)contractorHelper.getCode())) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-4");
            restErrors.setErrorMessage("Code is required");
            errors.add((RestErrors)restErrors);
        }
        if (StringUtils.isBlank((String)contractorHelper.getName())) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-5");
            restErrors.setErrorMessage("Name is required");
            errors.add((RestErrors)restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getCode()) && !contractorHelper.getCode().matches(ALPHANUMERICWITHSPECIALCHAR)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-6");
            restErrors.setErrorMessage("Special charectors not allowed in code");
            errors.add((RestErrors)restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getName()) && !contractorHelper.getName().matches(ALPHANUMERICWITHSPECIALCHAR)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-7");
            restErrors.setErrorMessage("Special charectors not allowed in name");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getCode()) && contractorHelper.getCode().length() > 50) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-8");
            restErrors.setErrorMessage("Code Length Should be less then 50");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getName()) && contractorHelper.getName().length() > 100) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-9");
            restErrors.setErrorMessage("Name Length Should be less then 100");
            errors.add(restErrors);
        }
        errors = this.validateNonMandatorFields(contractorHelper, errors, restErrors);
        return errors;
    }

    private List<RestErrors> validateNonMandatorFields(ContractorHelper contractorHelper, List<RestErrors> errors, RestErrors restErrors) {
        if (StringUtils.isNotBlank((String)contractorHelper.getCorrespondenceAddress()) && !contractorHelper.getCorrespondenceAddress().matches(ALPHANUMERICWITHALLSPECIALCHAR)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-10");
            restErrors.setErrorMessage("Correspondence address is not a valid");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getPaymentAddress()) && !contractorHelper.getPaymentAddress().matches(ALPHANUMERICWITHALLSPECIALCHAR)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-11");
            restErrors.setErrorMessage("Payment address is not a valid");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getNarration()) && !contractorHelper.getNarration().matches(ALPHANUMERICWITHALLSPECIALCHAR)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-12");
            restErrors.setErrorMessage("Narration is not a valid");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getContactPerson()) && !contractorHelper.getContactPerson().matches(ALPHANUMERIC_WITHSPACE)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-13");
            restErrors.setErrorMessage("Contact person is not a valid");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getEmail()) && !contractorHelper.getEmail().matches(EMAIL)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-20");
            restErrors.setErrorMessage("Email is not a valid");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getPanNumber()) && !contractorHelper.getPanNumber().matches(PANNUMBER)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-14");
            restErrors.setErrorMessage("PAN number is not a valid");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getTinNumber()) && !contractorHelper.getTinNumber().matches(ALPHANUMERIC)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-15");
            restErrors.setErrorMessage("TIN number is not a valid");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getIfscCode()) && !contractorHelper.getIfscCode().matches(ALPHANUMERIC)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-16");
            restErrors.setErrorMessage("IFSC code is not a valid");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getBankAccount()) && !contractorHelper.getBankAccount().matches(ALPHANUMERIC)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-18");
            restErrors.setErrorMessage("Bank Account is not a valid");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getPwdApprovalCode()) && !contractorHelper.getPwdApprovalCode().matches(ALPHANUMERIC)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-19");
            restErrors.setErrorMessage("Pwd approval code is not a valid");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)contractorHelper.getMobileNumber()) && !contractorHelper.getMobileNumber().matches(MOBILE_NUM)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-17");
            restErrors.setErrorMessage("Mobile number is not a valid");
            errors.add(restErrors);
        }
        return errors;
    }

    public List<RestErrors> validateContactorToUpdate(ContractorHelper contractorHelper) {
        Contractor existingContractor;
        ArrayList<RestErrors> errors = new ArrayList();
        RestErrors restErrors = null;
        if (StringUtils.isNotBlank((String)contractorHelper.getCode()) && (existingContractor = this.contractorService.getContractorByCode(contractorHelper.getCode())) == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-1");
            restErrors.setErrorMessage("No contractor exists with given contractor code");
            errors.add(restErrors);
        }
        errors = this.validateMandatoryFields(contractorHelper, errors);
        return errors;
    }

    public Contractor populateContractorToCreate(ContractorHelper contractorHelper) {
        Contractor contractor = new Contractor();
        this.populateContractor(contractorHelper, contractor);
        return contractor;
    }

    public Contractor populateContractorToUpdate(ContractorHelper contractorHelper) {
        Contractor contractor = this.contractorService.getContractorByCode(contractorHelper.getCode());
        this.populateContractor(contractorHelper, contractor);
        return contractor;
    }

    private void populateContractor(ContractorHelper contractorHelper, Contractor contractor) {
        contractor.setCode(contractorHelper.getCode());
        contractor.setName(contractorHelper.getName());
        if (StringUtils.isNotBlank((String)contractorHelper.getBankName())) {
            contractor.setBank(this.bankHibernateDAO.getBankByName(contractorHelper.getBankName()));
        }
        contractor.setBankAccount(contractorHelper.getBankAccount());
        contractor.setContactPerson(contractorHelper.getContactPerson());
        contractor.setCorrespondenceAddress(contractorHelper.getCorrespondenceAddress());
        contractor.setPaymentAddress(contractorHelper.getPaymentAddress());
        contractor.setEmail(contractorHelper.getEmail());
        contractor.setMobileNumber(contractorHelper.getMobileNumber());
        if (contractorHelper.getExemptionName() != null && contractorHelper.getExemptionName().equalsIgnoreCase(ExemptionForm.EARNEST_MONEY_DEPOSIT.toString())) {
            contractor.setExemptionForm(ExemptionForm.EARNEST_MONEY_DEPOSIT);
        } else if (contractorHelper.getExemptionName() != null && contractorHelper.getExemptionName().equalsIgnoreCase(ExemptionForm.INCOME_TAX.toString())) {
            contractor.setExemptionForm(ExemptionForm.INCOME_TAX);
        } else if (contractorHelper.getExemptionName() != null && contractorHelper.getExemptionName().equalsIgnoreCase(ExemptionForm.VAT.toString())) {
            contractor.setExemptionForm(ExemptionForm.VAT);
        }
        contractor.setIfscCode(contractorHelper.getIfscCode());
        contractor.setPanNumber(contractorHelper.getPanNumber());
        contractor.setTinNumber(contractorHelper.getTinNumber());
        contractor.setPwdApprovalCode(contractorHelper.getPwdApprovalCode());
        contractor.setNarration(contractorHelper.getNarration());
    }

    public Contractor saveContractor(Contractor contractor) {
        return this.contractorService.createContractor(contractor);
    }

    public Contractor updateContractor(Contractor contractor) {
        return this.contractorService.updateContractor(contractor);
    }

    public List<ContractorHelper> populateContractor() {
        List contractors = this.contractorService.getAllContractors();
        ArrayList<ContractorHelper> contractorHelpers = new ArrayList<ContractorHelper>();
        for (Contractor contractor : contractors) {
            this.createContractorData(contractorHelpers, contractor);
        }
        return contractorHelpers;
    }

    private void createContractorData(List<ContractorHelper> contractorHelpers, Contractor contractor) {
        ContractorHelper contractorHelper = this.createContractorData(contractor);
        contractorHelpers.add(contractorHelper);
    }

    private ContractorHelper createContractorData(Contractor contractor) {
        ContractorHelper contractorHelper = new ContractorHelper();
        contractorHelper.setCode(contractor.getCode());
        contractorHelper.setName(contractor.getName());
        if (contractor.getBank() != null) {
            contractorHelper.setBankName(contractor.getBank().getName());
        } else {
            contractorHelper.setBankName("");
        }
        if (StringUtils.isNotBlank((String)contractor.getBankAccount())) {
            contractorHelper.setBankAccount(contractor.getBankAccount());
        } else {
            contractorHelper.setBankAccount("");
        }
        if (StringUtils.isNotBlank((String)contractor.getContactPerson())) {
            contractorHelper.setContactPerson(contractor.getContactPerson());
        } else {
            contractorHelper.setContactPerson("");
        }
        this.createContractorHeaderData(contractor, contractorHelper);
        this.populateContractorDetailsData(contractor, contractorHelper);
        return contractorHelper;
    }

    private void populateContractorDetailsData(Contractor contractor, ContractorHelper contractorHelper) {
        if (!contractor.getContractorDetails().isEmpty() && StringUtils.isNotBlank((String)((ContractorDetail)contractor.getContractorDetails().get(0)).getCategory())) {
            contractorHelper.setContractorCategory(((ContractorDetail)contractor.getContractorDetails().get(0)).getCategory());
        } else {
            contractorHelper.setContractorCategory("");
        }
        if (!contractor.getContractorDetails().isEmpty() && ((ContractorDetail)contractor.getContractorDetails().get(0)).getGrade() != null) {
            contractorHelper.setContractorClass(((ContractorDetail)contractor.getContractorDetails().get(0)).getGrade().getGrade());
        } else {
            contractorHelper.setContractorClass("");
        }
        if (!contractor.getContractorDetails().isEmpty()) {
            contractorHelper.setStatus(((ContractorDetail)contractor.getContractorDetails().get(0)).getStatus().getCode());
        } else {
            contractorHelper.setStatus("");
        }
    }

    private void createContractorHeaderData(Contractor contractor, ContractorHelper contractorHelper) {
        if (StringUtils.isNotBlank((String)contractor.getCorrespondenceAddress())) {
            contractorHelper.setCorrespondenceAddress(contractor.getCorrespondenceAddress());
        } else {
            contractorHelper.setCorrespondenceAddress("");
        }
        if (StringUtils.isNotBlank((String)contractor.getPaymentAddress())) {
            contractorHelper.setPaymentAddress(contractor.getPaymentAddress());
        } else {
            contractorHelper.setPaymentAddress("");
        }
        if (StringUtils.isNotBlank((String)contractor.getEmail())) {
            contractorHelper.setEmail(contractor.getEmail());
        } else {
            contractorHelper.setEmail("");
        }
        if (contractor.getExemptionForm() != null) {
            contractorHelper.setExemptionName(contractor.getExemptionForm().toString());
        } else {
            contractorHelper.setExemptionName("");
        }
        if (StringUtils.isNotBlank((String)contractor.getIfscCode())) {
            contractorHelper.setIfscCode(contractor.getIfscCode());
        } else {
            contractorHelper.setIfscCode("");
        }
        this.populateContractorDataToView(contractor, contractorHelper);
    }

    private void populateContractorDataToView(Contractor contractor, ContractorHelper contractorHelper) {
        if (StringUtils.isNotBlank((String)contractor.getPanNumber())) {
            contractorHelper.setPanNumber(contractor.getPanNumber());
        } else {
            contractorHelper.setPanNumber("");
        }
        if (StringUtils.isNotBlank((String)contractor.getTinNumber())) {
            contractorHelper.setTinNumber(contractor.getTinNumber());
        } else {
            contractorHelper.setTinNumber("");
        }
        if (StringUtils.isNotBlank((String)contractor.getPwdApprovalCode())) {
            contractorHelper.setPwdApprovalCode(contractor.getPwdApprovalCode());
        } else {
            contractorHelper.setPwdApprovalCode("");
        }
        if (StringUtils.isNotBlank((String)contractor.getNarration())) {
            contractorHelper.setNarration(contractor.getNarration());
        } else {
            contractorHelper.setNarration("");
        }
        if (StringUtils.isNotBlank((String)contractor.getMobileNumber())) {
            contractorHelper.setMobileNumber(contractor.getMobileNumber());
        } else {
            contractorHelper.setMobileNumber("");
        }
    }
}

