/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.service.AccountdetailtypeService;
import org.egov.commons.service.ChartOfAccountsService;
import org.egov.commons.service.EntityTypeService;
import org.egov.commons.service.FunctionService;
import org.egov.commons.service.FundService;
import org.egov.commons.utils.EntityType;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.egf.utils.FinancialUtils;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.model.bills.EgBillregistermis;
import org.egov.restapi.model.BillDetails;
import org.egov.restapi.model.BillPayeeDetails;
import org.egov.restapi.model.BillRegister;
import org.egov.restapi.model.RestErrors;
import org.egov.services.masters.SchemeService;
import org.egov.services.masters.SubSchemeService;
import org.egov.works.master.service.ContractorService;
import org.egov.works.models.estimate.ProjectCode;
import org.egov.works.services.ProjectCodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BillService {
    @Autowired
    private FundService fundService;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private SubSchemeService subSchemeService;
    @Autowired
    private ChartOfAccountsService chartOfAccountsService;
    @Autowired
    private ExpenseBillService expenseBillService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private AccountdetailtypeService accountdetailtypeService;
    @Autowired
    private ProjectCodeService projectCodeService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    private ContractorService contractorService;
    @Autowired
    private FinancialUtils financialUtils;

    public List<RestErrors> validateBillRegister(BillRegister billRegister) {
        RestErrors restErrors;
        ArrayList<RestErrors> errors = new ArrayList<RestErrors>();
        this.validateMandatoryFields(billRegister, errors);
        this.validateBillDates(billRegister, errors);
        if (billRegister.getBillAmount() == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-16");
            restErrors.setErrorMessage("Bill Amount is required");
            errors.add(restErrors);
        }
        if (this.projectCodeService.findActiveProjectCodeByCode(billRegister.getProjectCode()) == null && StringUtils.isBlank((String)billRegister.getNameOfWork())) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-14");
            restErrors.setErrorMessage("Name of the Work is required");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)billRegister.getNameOfWork()) && !billRegister.getNameOfWork().matches("[0-9a-zA-Z_@./#&+-/!(){}\",^$%*|=;:<>?`~ ]+")) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-37");
            restErrors.setErrorMessage("\n \t and ' are not allowed in Name of the Work");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)billRegister.getSchemeCode()) && this.schemeService.findByCode(billRegister.getSchemeCode()) == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-32");
            restErrors.setErrorMessage("No Scheme exists with the given scheme code");
            errors.add(restErrors);
        }
        if (StringUtils.isNotBlank((String)billRegister.getSubSchemeCode()) && this.subSchemeService.findByCode(billRegister.getSubSchemeCode()) == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-32");
            restErrors.setErrorMessage("No Scheme exists with the given scheme code");
            errors.add(restErrors);
        }
        this.validateBillDetails(billRegister, errors);
        this.validateBillPayeeDetails(billRegister, errors);
        return errors;
    }

    private void validateMandatoryFields(BillRegister billRegister, List<RestErrors> errors) {
        RestErrors restErrors;
        if (StringUtils.isBlank((String)billRegister.getDepartmentCode()) || this.departmentService.getDepartmentByCode(billRegister.getDepartmentCode()) == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-1");
            restErrors.setErrorMessage("No Department exists with the given department code");
            errors.add(restErrors);
        }
        if (StringUtils.isBlank((String)billRegister.getFunctionCode()) || this.functionService.findByCode(billRegister.getFunctionCode()) == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-2");
            restErrors.setErrorMessage("No Function exists with the given function code");
            errors.add(restErrors);
        }
        if (StringUtils.isBlank((String)billRegister.getProjectCode())) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-3");
            restErrors.setErrorMessage("WIN Code is required");
            errors.add(restErrors);
        }
        if (StringUtils.isBlank((String)billRegister.getBillType())) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-5");
            restErrors.setErrorMessage("Bill Type is required");
            errors.add(restErrors);
        }
        if (StringUtils.isBlank((String)billRegister.getFundCode()) || this.fundService.findByCode(billRegister.getFundCode()) == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-6");
            restErrors.setErrorMessage("No Fund exists with the given fund code");
            errors.add(restErrors);
        }
        if (StringUtils.isBlank((String)billRegister.getPayTo())) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-15");
            restErrors.setErrorMessage("Pay To is required");
            errors.add(restErrors);
        }
    }

    private void validateBillDates(BillRegister billRegister, List<RestErrors> errors) {
        RestErrors restErrors;
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        if (billRegister.getBillDate() == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-4");
            restErrors.setErrorMessage("Bill Date is required");
            errors.add(restErrors);
        } else if (billRegister.getBillDate().after(new Date())) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-34");
            restErrors.setErrorMessage(sdf.format(billRegister.getBillDate()) + " - " + "Provided date can not be Future date");
            errors.add(restErrors);
        } else {
            try {
                this.financialYearHibernateDAO.getFinancialYearByDate(billRegister.getBillDate());
            }
            catch (Exception e) {
                restErrors = new RestErrors();
                restErrors.setErrorCode(e.getMessage());
                restErrors.setErrorMessage(e.getMessage());
                errors.add(restErrors);
            }
        }
        if (billRegister.getPartyBillDate() != null && billRegister.getPartyBillDate().after(new Date())) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-34");
            restErrors.setErrorMessage(sdf.format(billRegister.getPartyBillDate()) + " - " + "Provided date can not be Future date");
            errors.add(restErrors);
        }
    }

    private void validateBillDetails(BillRegister billRegister, List<RestErrors> errors) {
        if (billRegister.getBillDetails() == null || billRegister.getBillDetails().isEmpty()) {
            RestErrors restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-11");
            restErrors.setErrorMessage("Bill Details are required");
            errors.add(restErrors);
        } else if (billRegister.getBillDetails().size() < 2) {
            RestErrors restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-26");
            restErrors.setErrorMessage("Minimum two glcode details are required");
            errors.add(restErrors);
        } else {
            this.validateDetails(billRegister, errors);
        }
    }

    private void validateDetails(BillRegister billRegister, List<RestErrors> errors) {
        RestErrors restErrors;
        Accountdetailtype projectCodeAccountDetailType = null;
        Boolean isProjectCodeSubledger = false;
        boolean foundNetPayable = false;
        List contractorPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        List advancePayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("CONTRACTOR_ADVANCE_ACCOUNTCODE");
        BigDecimal creditAmount = BigDecimal.ZERO;
        BigDecimal debitAmount = BigDecimal.ZERO;
        for (BillDetails billDetails : billRegister.getBillDetails()) {
            if (StringUtils.isBlank((String)billDetails.getGlcode())) {
                restErrors = new RestErrors();
                restErrors.setErrorCode("EGF-REST-7");
                restErrors.setErrorMessage("Glcode is required for Bill Details");
                errors.add(restErrors);
                continue;
            }
            CChartOfAccounts coa = this.chartOfAccountsService.getByGlCode(billDetails.getGlcode());
            if (coa == null) {
                restErrors = new RestErrors();
                restErrors.setErrorCode("EGF-REST-25");
                restErrors.setErrorMessage(billDetails.getGlcode() + " - " + "No Glcode exists with the given glcode");
                errors.add(restErrors);
            } else if (coa.getClassification() != 4L) {
                restErrors = new RestErrors();
                restErrors.setErrorCode("EGF-REST-35");
                restErrors.setErrorMessage(billDetails.getGlcode() + " - " + "Glcode provided is not a valid detail code");
                errors.add(restErrors);
            }
            if (billDetails.getDebitAmount() == null && billDetails.getCreditAmount() == null) {
                restErrors = new RestErrors();
                restErrors.setErrorCode("EGF-REST-12");
                restErrors.setErrorMessage("Either Credit or Debit Amount is required for the bill detail");
                errors.add(restErrors);
            } else if (billDetails.getCreditAmount() != null && billDetails.getDebitAmount() != null && billDetails.getCreditAmount().doubleValue() > 0.0 && billDetails.getDebitAmount().doubleValue() > 0.0) {
                restErrors = new RestErrors();
                restErrors.setErrorCode("EGF-REST-27");
                restErrors.setErrorMessage("Both Debit and Credit amounts can not be greater than zero");
                errors.add(restErrors);
            }
            if (billDetails.getCreditAmount() == null && billDetails.getDebitAmount().compareTo(BigDecimal.ZERO) <= 0) {
                restErrors = new RestErrors();
                restErrors.setErrorCode("EGF-REST-24");
                restErrors.setErrorMessage("Amount should be greater than zero");
                errors.add(restErrors);
            }
            if (billDetails.getDebitAmount() != null && billDetails.getDebitAmount().compareTo(BigDecimal.ZERO) > 0) {
                debitAmount = debitAmount.add(billDetails.getDebitAmount());
                if (coa != null) {
                    projectCodeAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "PROJECTCODE");
                }
                if (projectCodeAccountDetailType != null) {
                    isProjectCodeSubledger = true;
                }
                if (coa == null || coa.getChartOfAccountDetails().isEmpty()) continue;
                Boolean isProjectContractorSubLedger = false;
                Set chartOfAccountDetails = coa.getChartOfAccountDetails();
                for (CChartOfAccountDetail detail : chartOfAccountDetails) {
                    if (!detail.getDetailTypeId().getName().equals("PROJECTCODE") && !detail.getDetailTypeId().getName().equals("contractor")) continue;
                    isProjectContractorSubLedger = true;
                }
                if (isProjectContractorSubLedger.booleanValue()) continue;
                restErrors = new RestErrors();
                restErrors.setErrorCode("EGF-REST-28");
                restErrors.setErrorMessage(coa.getGlcode() + " - " + "GL Code should be either Project or Contractor Subledger");
                errors.add(restErrors);
                continue;
            }
            if (billDetails.getCreditAmount() == null) continue;
            creditAmount = creditAmount.add(billDetails.getCreditAmount());
            if (advancePayableAccountList.contains(coa) || contractorPayableAccountList.contains(coa)) {
                foundNetPayable = true;
            }
            if (contractorPayableAccountList != null && !contractorPayableAccountList.isEmpty() && contractorPayableAccountList.contains(coa) && billDetails.getCreditAmount().compareTo(BigDecimal.ZERO) == -1) {
                restErrors = new RestErrors();
                restErrors.setErrorCode("EGF-REST-23");
                restErrors.setErrorMessage("Amount can not be less than zero");
                errors.add(restErrors);
                continue;
            }
            if (billDetails.getDebitAmount() != null || billDetails.getCreditAmount().compareTo(BigDecimal.ZERO) > 0) continue;
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-24");
            restErrors.setErrorMessage("Amount should be greater than zero");
            errors.add(restErrors);
        }
        if (!isProjectCodeSubledger.booleanValue()) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-21");
            restErrors.setErrorMessage("Atleast one Debit code provided in bill details should have Project Code subledger");
            errors.add(restErrors);
        }
        if (!creditAmount.equals(debitAmount)) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-13");
            restErrors.setErrorMessage("Sum of Debit and Credit amounts should be equal");
            errors.add(restErrors);
        }
        if (!foundNetPayable) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-30");
            restErrors.setErrorMessage("Either Advance payable or Contractor payable is required for Credit GL Code");
            errors.add(restErrors);
        }
    }

    private void validateBillPayeeDetails(BillRegister billRegister, List<RestErrors> errors) {
        RestErrors restErrors;
        if (billRegister.getBillPayeeDetails() == null || billRegister.getBillPayeeDetails().isEmpty()) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-REST-38");
            restErrors.setErrorMessage("Bill Payee Details are required");
            errors.add(restErrors);
        }
        if (billRegister.getBillPayeeDetails() != null && !billRegister.getBillPayeeDetails().isEmpty()) {
            for (BillPayeeDetails billPayeeDetails : billRegister.getBillPayeeDetails()) {
                CChartOfAccounts coa;
                Boolean isCOAExistInDetails = false;
                if (StringUtils.isBlank((String)billPayeeDetails.getGlcode())) {
                    restErrors = new RestErrors();
                    restErrors.setErrorCode("EGF-REST-17");
                    restErrors.setErrorMessage("Glcode is required for Bill Payee Details");
                    errors.add(restErrors);
                }
                if (StringUtils.isBlank((String)billPayeeDetails.getAccountDetailType())) {
                    restErrors = new RestErrors();
                    restErrors.setErrorCode("EGF-REST-18");
                    restErrors.setErrorMessage("Account Detail Type is required for Bill Payee Details");
                    errors.add(restErrors);
                } else if ("contractor".equals(billPayeeDetails.getAccountDetailType()) && this.contractorService.getContractorByCode(billPayeeDetails.getAccountDetailKey()) == null) {
                    restErrors = new RestErrors();
                    restErrors.setErrorCode("EGWORKS-CONTRACTOR-1");
                    restErrors.setErrorMessage("No contractor exists with given contractor code");
                    errors.add(restErrors);
                } else if (StringUtils.isNotBlank((String)billRegister.getProjectCode()) && "PROJECTCODE".equals(billPayeeDetails.getAccountDetailType()) && !billRegister.getProjectCode().equals(billPayeeDetails.getAccountDetailKey())) {
                    restErrors = new RestErrors();
                    restErrors.setErrorCode("EGF-REST-36");
                    restErrors.setErrorMessage("Given Bill Payee Project code is not matching Bill register Project code");
                    errors.add(restErrors);
                }
                if (StringUtils.isBlank((String)billPayeeDetails.getAccountDetailKey())) {
                    restErrors = new RestErrors();
                    restErrors.setErrorCode("EGF-REST-19");
                    restErrors.setErrorMessage("Account Detail Key is required for Bill Payee Details");
                    errors.add(restErrors);
                }
                if (billPayeeDetails.getDebitAmount() == null && billPayeeDetails.getCreditAmount() == null) {
                    restErrors = new RestErrors();
                    restErrors.setErrorCode("EGF-REST-20");
                    restErrors.setErrorMessage("It can be Either Credit or Debit Amount for the given Chart Of Account - " + billPayeeDetails.getGlcode());
                    errors.add(restErrors);
                }
                if (billPayeeDetails.getDebitAmount() != null && billPayeeDetails.getCreditAmount() != null && billPayeeDetails.getDebitAmount().doubleValue() > 0.0 && billPayeeDetails.getCreditAmount().doubleValue() > 0.0) {
                    restErrors = new RestErrors();
                    restErrors.setErrorCode("EGF-REST-27");
                    restErrors.setErrorMessage("Both Debit and Credit amounts can not be greater than zero");
                    errors.add(restErrors);
                }
                if ((coa = this.chartOfAccountsService.getByGlCode(billPayeeDetails.getGlcode())) != null && !coa.getChartOfAccountDetails().isEmpty()) {
                    Boolean isProjectContractorSubLedger = false;
                    Set chartOfAccountDetails = coa.getChartOfAccountDetails();
                    for (CChartOfAccountDetail detail : chartOfAccountDetails) {
                        if (!detail.getDetailTypeId().getName().equals("PROJECTCODE") && !detail.getDetailTypeId().getName().equals("contractor")) continue;
                        isProjectContractorSubLedger = true;
                    }
                    if (!isProjectContractorSubLedger.booleanValue()) {
                        restErrors = new RestErrors();
                        restErrors.setErrorCode("EGF-REST-28");
                        restErrors.setErrorMessage("GL Code should be either Project or Contractor Subledger");
                        errors.add(restErrors);
                    }
                }
                for (BillDetails billDetails : billRegister.getBillDetails()) {
                    if (!billDetails.getGlcode().equals(billPayeeDetails.getGlcode())) continue;
                    isCOAExistInDetails = true;
                }
                if (isCOAExistInDetails.booleanValue()) continue;
                restErrors = new RestErrors();
                restErrors.setErrorCode("EGF-REST-29");
                restErrors.setErrorMessage(billPayeeDetails.getGlcode() + " - " + "The given Payee GL code does not exist in Bill details");
                errors.add(restErrors);
            }
        }
    }

    public void populateBillRegister(EgBillregister egBillregister, BillRegister billRegister) throws ClassNotFoundException {
        this.populateEgBillregister(egBillregister, billRegister);
        this.populateEgBillregisterMis(egBillregister, billRegister);
        for (BillDetails details : billRegister.getBillDetails()) {
            this.populateEgBilldetails(egBillregister, details, billRegister);
        }
    }

    private void populateEgBillregister(EgBillregister egBillregister, BillRegister billRegister) {
        egBillregister.setBilldate(billRegister.getBillDate());
        egBillregister.setBilltype(billRegister.getBillType());
        egBillregister.setBillamount(billRegister.getBillAmount());
        egBillregister.setExpendituretype("Works");
        egBillregister.setBillstatus("APPROVED");
        egBillregister.setStatus(this.financialUtils.getStatusByModuleAndCode("CONTRACTORBILL", "APPROVED"));
    }

    private void populateEgBillregisterMis(EgBillregister egBillregister, BillRegister billRegister) {
        EgBillregistermis egBillregistermis = new EgBillregistermis();
        egBillregistermis.setFunction(this.functionService.findByCode(billRegister.getFunctionCode()));
        egBillregistermis.setFund(this.fundService.findByCode(billRegister.getFundCode()));
        egBillregistermis.setScheme(this.schemeService.findByCode(billRegister.getSchemeCode()));
        egBillregistermis.setSubScheme(this.subSchemeService.findByCode(billRegister.getSubSchemeCode()));
        egBillregistermis.setEgDepartment(this.departmentService.getDepartmentByCode(billRegister.getDepartmentCode()));
        egBillregistermis.setPayto(billRegister.getPayTo());
        egBillregistermis.setNarration(billRegister.getNarration());
        egBillregistermis.setPartyBillNumber(billRegister.getPartyBillNumber());
        egBillregistermis.setPartyBillDate(billRegister.getPartyBillDate());
        egBillregister.setEgBillregistermis(egBillregistermis);
    }

    private void populateEgBilldetails(EgBillregister egBillregister, BillDetails details, BillRegister billRegister) throws ClassNotFoundException {
        EgBilldetails egBilldetails = new EgBilldetails();
        egBilldetails.setGlcodeid(BigDecimal.valueOf(this.chartOfAccountsService.getByGlCode(details.getGlcode()).getId()));
        egBilldetails.setCreditamount(details.getCreditAmount() != null ? details.getCreditAmount() : null);
        egBilldetails.setDebitamount(details.getDebitAmount() != null ? details.getDebitAmount() : null);
        egBilldetails.setEgBillregister(egBillregister);
        egBilldetails.setLastupdatedtime(new Date());
        egBilldetails.setFunctionid(BigDecimal.valueOf(egBillregister.getEgBillregistermis().getFunction().getId()));
        for (BillPayeeDetails payeeDetails : billRegister.getBillPayeeDetails()) {
            Accountdetailtype contractorAccountDetailType;
            CChartOfAccounts coa = this.chartOfAccountsService.getByGlCode(payeeDetails.getGlcode());
            if (payeeDetails.getCreditAmount() != null) {
                contractorAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "contractor");
                if (contractorAccountDetailType != null) {
                    this.populateEgBillPayeedetails(egBilldetails, payeeDetails, details);
                }
            } else if (payeeDetails.getDebitAmount() != null) {
                Accountdetailtype projectCodeAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "PROJECTCODE");
                contractorAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "contractor");
                if (projectCodeAccountDetailType != null || contractorAccountDetailType != null) {
                    this.populateEgBillPayeedetails(egBilldetails, payeeDetails, details);
                }
            }
            egBillregister.addEgBilldetailes(egBilldetails);
        }
    }

    private void populateEgBillPayeedetails(EgBilldetails egBilldetails, BillPayeeDetails payeeDetails, BillDetails details) throws ClassNotFoundException {
        EgBillPayeedetails billPayeedetails = new EgBillPayeedetails();
        if (payeeDetails.getGlcode() != null && payeeDetails.getGlcode().equals(details.getGlcode())) {
            if (payeeDetails.getCreditAmount() != null && payeeDetails.getCreditAmount().longValue() > 0L) {
                billPayeedetails.setCreditAmount(payeeDetails.getCreditAmount());
            }
            if (payeeDetails.getDebitAmount() != null && payeeDetails.getDebitAmount().longValue() > 0L) {
                billPayeedetails.setDebitAmount(payeeDetails.getDebitAmount());
            }
            Accountdetailtype detailType = this.accountdetailtypeService.findByName(payeeDetails.getAccountDetailType());
            billPayeedetails.setAccountDetailTypeId(detailType.getId());
            if (payeeDetails.getAccountDetailType() != null) {
                String table = detailType.getFullQualifiedName();
                Class<?> service = Class.forName(table);
                String simpleName = service.getSimpleName();
                simpleName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1) + "Service";
                EntityTypeService entityService = (EntityTypeService)this.applicationContext.getBean(simpleName);
                List entities = entityService.filterActiveEntities(payeeDetails.getAccountDetailKey(), 10, detailType.getId());
                billPayeedetails.setAccountDetailKeyId(((EntityType)entities.get(0)).getEntityId());
            }
            billPayeedetails.setEgBilldetailsId(egBilldetails);
            billPayeedetails.setLastUpdatedTime(new Date());
            egBilldetails.addEgBillPayeedetail(billPayeedetails);
        }
    }

    public void createProjectCode(BillRegister billRegister) {
        ProjectCode projectCode = this.projectCodeService.findActiveProjectCodeByCode(billRegister.getProjectCode());
        if (projectCode == null) {
            this.projectCodeService.createProjectCode(billRegister.getProjectCode(), billRegister.getNameOfWork());
        }
    }

    public EgBillregister createBill(EgBillregister egBillregister) {
        return this.expenseBillService.create(egBillregister, null, null, null, "Create And Approve");
    }
}

