/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.dcb.bean.ChequePayment;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.ptis.bean.AssessmentInfo;
import org.egov.ptis.constants.PropertyTaxConstants;
import org.egov.ptis.domain.entity.property.PropertyTypeMaster;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.DrainageEnum;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.LocalityDetails;
import org.egov.ptis.domain.model.MasterCodeNamePairDetails;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.model.ReceiptDetails;
import org.egov.ptis.domain.model.RestPropertyTaxDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.restapi.model.AssessmentRequest;
import org.egov.restapi.model.LocalityCodeDetails;
import org.egov.restapi.model.OwnershipCategoryDetails;
import org.egov.restapi.model.PropertyTaxBoundaryDetails;
import org.egov.restapi.util.JsonConvertor;
import org.egov.restapi.util.ValidationUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Scope(scopeName="prototype")
public class AssessmentService {
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private ValidationUtil validationUtil;

    @RequestMapping(value={"/property/assessmentDetails"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getAssessmentDetails(@RequestBody String assessmentRequest) throws IOException {
        AssessmentRequest assessmentReq = (AssessmentRequest)this.getObjectFromJSONRequest(assessmentRequest, AssessmentRequest.class);
        AssessmentDetails assessmentDetail = this.propertyExternalService.loadAssessmentDetails(assessmentReq.getAssessmentNo(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        return this.getJSONResponse((Object)assessmentDetail);
    }

    @RequestMapping(value={"/property/propertytaxdetails"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getPropertyTaxDetails(@RequestBody String assessmentRequest) throws IOException {
        PropertyTaxDetails propertyTaxDetails = new PropertyTaxDetails();
        AssessmentRequest assessmentReq = (AssessmentRequest)this.getObjectFromJSONRequest(assessmentRequest, AssessmentRequest.class);
        try {
            String assessmentNo = assessmentReq.getAssessmentNo();
            String category = assessmentReq.getCategory();
            if (null != assessmentNo) {
                propertyTaxDetails = this.propertyExternalService.getPropertyTaxDetails(assessmentNo, category);
            } else {
                ErrorDetails errorDetails = this.getInvalidCredentialsErrorDetails();
                propertyTaxDetails.setErrorDetails(errorDetails);
            }
            if (propertyTaxDetails.getOwnerDetails() == null) {
                propertyTaxDetails.setOwnerDetails(new ArrayList(0));
            }
            if (propertyTaxDetails.getLocalityName() == null) {
                propertyTaxDetails.setLocalityName("");
            }
            if (propertyTaxDetails.getPropertyAddress() == null) {
                propertyTaxDetails.setPropertyAddress("");
            }
            if (propertyTaxDetails.getTaxDetails() == null) {
                RestPropertyTaxDetails ar = new RestPropertyTaxDetails();
                ArrayList<RestPropertyTaxDetails> taxDetails = new ArrayList<RestPropertyTaxDetails>(0);
                taxDetails.add(ar);
                propertyTaxDetails.setTaxDetails(taxDetails);
            }
        }
        catch (Exception e) {
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            ErrorDetails er = new ErrorDetails();
            er.setErrorCode(e.getMessage());
            er.setErrorMessage(e.getMessage());
            errorList.add(er);
            return JsonConvertor.convert(errorList);
        }
        return JsonConvertor.convert((Object)propertyTaxDetails);
    }

    @RequestMapping(value={"/property/propertytaxdetailsByOwnerDetails"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getPropertyTaxDetailsByOwnerDetails(@RequestBody String assessmentRequest) throws IOException {
        List<PropertyTaxDetails> propertyTaxDetailsList = new ArrayList();
        AssessmentRequest assessmentReq = (AssessmentRequest)this.getObjectFromJSONRequest(assessmentRequest, AssessmentRequest.class);
        try {
            String assessmentNo = assessmentReq.getAssessmentNo();
            String ownerName = assessmentReq.getOwnerName();
            String mobileNumber = assessmentReq.getMobileNumber();
            String category = assessmentReq.getCategory();
            String doorNo = assessmentReq.getDoorNo();
            if (!(StringUtils.isBlank((String)category) || "PT".equals(category) || "VLT".equals(category))) {
                ArrayList<ErrorDetails> errors = new ArrayList<ErrorDetails>(0);
                ErrorDetails er = new ErrorDetails();
                er.setErrorCode("PTIS-REST-45");
                er.setErrorMessage("Invalid Category");
                errors.add(er);
                return JsonConvertor.convert(errors);
            }
            if (!(StringUtils.isBlank((String)assessmentNo) && StringUtils.isBlank((String)ownerName) && StringUtils.isBlank((String)mobileNumber) && StringUtils.isBlank((String)doorNo))) {
                propertyTaxDetailsList = this.propertyExternalService.getPropertyTaxDetails(assessmentNo, ownerName, mobileNumber, category, doorNo);
            } else {
                ErrorDetails errorDetails = this.getInvalidCredentialsErrorDetails();
                PropertyTaxDetails propertyTaxDetails = new PropertyTaxDetails();
                propertyTaxDetails.setErrorDetails(errorDetails);
                propertyTaxDetailsList.add(propertyTaxDetails);
            }
            for (PropertyTaxDetails propertyTaxDetails : propertyTaxDetailsList) {
                if (propertyTaxDetails.getOwnerDetails() == null) {
                    propertyTaxDetails.setOwnerDetails(new ArrayList(0));
                }
                if (propertyTaxDetails.getLocalityName() == null) {
                    propertyTaxDetails.setLocalityName("");
                }
                if (propertyTaxDetails.getPropertyAddress() == null) {
                    propertyTaxDetails.setPropertyAddress("");
                }
                if (propertyTaxDetails.getTaxDetails() == null) {
                    RestPropertyTaxDetails ar = new RestPropertyTaxDetails();
                    ArrayList<RestPropertyTaxDetails> taxDetails = new ArrayList<RestPropertyTaxDetails>(0);
                    taxDetails.add(ar);
                    propertyTaxDetails.setTaxDetails(taxDetails);
                }
                if (propertyTaxDetails.getErrorDetails() != null) continue;
                ErrorDetails errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-0");
                errorDetails.setErrorMessage("SUCCESS");
                propertyTaxDetails.setErrorDetails(errorDetails);
            }
        }
        catch (Exception e) {
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            ErrorDetails er = new ErrorDetails();
            er.setErrorCode(e.getMessage());
            er.setErrorMessage(e.getMessage());
            errorList.add(er);
            return JsonConvertor.convert(errorList);
        }
        return JsonConvertor.convert(propertyTaxDetailsList);
    }

    @RequestMapping(value={"/property/propertyTaxDetailsByBoundary"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getPropertyTaxDetailsByBoundary(@RequestBody String propertyTaxBoundaryDetails) throws IOException {
        PropertyTaxBoundaryDetails propTaxBoundaryDetails = (PropertyTaxBoundaryDetails)this.getObjectFromJSONRequest(propertyTaxBoundaryDetails, PropertyTaxBoundaryDetails.class);
        String circleName = propTaxBoundaryDetails.getCircleName();
        String zoneName = propTaxBoundaryDetails.getZoneName();
        String wardName = propTaxBoundaryDetails.getWardName();
        String blockName = propTaxBoundaryDetails.getBlockName();
        String ownerName = propTaxBoundaryDetails.getOwnerName();
        String doorNo = propTaxBoundaryDetails.getDoorNo();
        String aadhaarNumber = propTaxBoundaryDetails.getAadhaarNumber();
        String mobileNumber = propTaxBoundaryDetails.getMobileNumber();
        List propertyTaxDetailsList = this.propertyExternalService.getPropertyTaxDetails(circleName, zoneName, wardName, blockName, ownerName, doorNo, aadhaarNumber, mobileNumber);
        return this.getJSONResponse((Object)propertyTaxDetailsList);
    }

    @RequestMapping(value={"/property/paypropertytax"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String payPropertyTax(@RequestBody String payPropertyTaxDetails, HttpServletRequest request) throws IOException {
        String responseJson;
        try {
            responseJson = new String();
            PayPropertyTaxDetails payPropTaxDetails = (PayPropertyTaxDetails)this.getObjectFromJSONRequest(payPropertyTaxDetails, PayPropertyTaxDetails.class);
            String propertyType = this.propertyExternalService.getPropertyType(payPropTaxDetails.getAssessmentNo());
            ErrorDetails errorDetails = this.validationUtil.validatePaymentDetails(payPropTaxDetails, false, propertyType);
            if (null != errorDetails) {
                responseJson = JsonConvertor.convert((Object)errorDetails);
            } else {
                payPropTaxDetails.setSource(request.getSession().getAttribute("source") != null ? request.getSession().getAttribute("source").toString() : "");
                ReceiptDetails receiptDetails = this.propertyExternalService.payPropertyTax(payPropTaxDetails, propertyType);
                responseJson = JsonConvertor.convert((Object)receiptDetails);
            }
        }
        catch (ValidationException e) {
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            List errors = e.getErrors();
            for (ValidationError ve : errors) {
                ErrorDetails er = new ErrorDetails();
                er.setErrorCode(ve.getKey());
                er.setErrorMessage(ve.getMessage());
                errorList.add(er);
            }
            responseJson = JsonConvertor.convert(errorList);
        }
        catch (Exception e) {
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            ErrorDetails er = new ErrorDetails();
            er.setErrorCode(e.getMessage());
            er.setErrorMessage(e.getMessage());
            errorList.add(er);
            responseJson = JsonConvertor.convert(errorList);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/ownershipCategories"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getOwnershipCategories() throws IOException {
        List propTypeMasterDetailsList = this.propertyExternalService.getPropertyTypeMasterDetails();
        return this.getJSONResponse((Object)propTypeMasterDetailsList);
    }

    @RequestMapping(value={"/property/ownershipCategoryByCode"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getOwnershipCategoryByCode(@RequestBody String ownershipCategoryDetails) throws IOException {
        OwnershipCategoryDetails ownershipCategory = (OwnershipCategoryDetails)this.getObjectFromJSONRequest(ownershipCategoryDetails, OwnershipCategoryDetails.class);
        PropertyTypeMaster propertyTypeMaster = this.propertyExternalService.getPropertyTypeMasterByCode(ownershipCategory.getOwnershipCategoryCode());
        return this.getJSONResponse((Object)propertyTypeMaster);
    }

    @RequestMapping(value={"/property/propertyTypesByOwnership"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getPropertyTypeCategoryDetails(@RequestBody String ownershipCategoryDetails) throws IOException {
        OwnershipCategoryDetails ownershipCategory = (OwnershipCategoryDetails)this.getObjectFromJSONRequest(ownershipCategoryDetails, OwnershipCategoryDetails.class);
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getPropertyTypeCategoryDetails(ownershipCategory.getOwnershipCategoryCode());
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/propertyTypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getPropertyTypes() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getPropertyTypes();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/apartments"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getApartmentsAndComplexes() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getApartmentsAndComplexes();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/createPropertyReasons"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getCreatePropertyReasons() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getReasonsForChangeProperty("CREATE");
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/localities"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getLocalities() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getBoundariesByBoundaryTypeAndHierarchyType("locality", "LOCATION");
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/boundaryByLocalityCode"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getBoundaryByLocalityCode(@RequestBody String localityCodeDetails) throws IOException {
        LocalityCodeDetails locCodeDetails = (LocalityCodeDetails)this.getObjectFromJSONRequest(localityCodeDetails, LocalityCodeDetails.class);
        LocalityDetails localityDetails = this.propertyExternalService.getLocalityDetailsByLocalityCode(locCodeDetails.getLocalityCode());
        return this.getJSONResponse((Object)localityDetails);
    }

    @RequestMapping(value={"/property/electionWards"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getElectionWards() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getBoundariesByBoundaryTypeAndHierarchyType("Ward", "ADMINISTRATION");
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/enumerationBlocks"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getEnumerationBlocks() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getEnumerationBlocks();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/floorTypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getFloorTypes() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getFloorTypes();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/roofTypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getRoofTypes() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getRoofTypes();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/wallTypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getWallTypes() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getWallTypes();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/woodTypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getWoodTypes() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getWoodTypes();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/floors"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getFloors() throws IOException {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        TreeMap floorMap = PropertyTaxConstants.FLOOR_MAP;
        Set keys = floorMap.keySet();
        for (Integer key : keys) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(key.toString());
            mstrCodeNamePairDetails.setName((String)floorMap.get(key));
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return this.getJSONResponse(mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/propertyClassifications"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getPropertyClassifications() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getBuildingClassifications();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/propertyUsages"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getPropertUsages() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getNatureOfUsages();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/occupancyTypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getOccupancyTypes() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getOccupancies();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/exemptionCategories"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getTaxExemptionCategories() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getExemptionCategories();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/drainages"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getDrainages() throws IOException {
        ArrayList<MasterCodeNamePairDetails> mstrCodeNamePairDetailsList = new ArrayList<MasterCodeNamePairDetails>();
        for (DrainageEnum drngEnum : DrainageEnum.values()) {
            MasterCodeNamePairDetails mstrCodeNamePairDetails = new MasterCodeNamePairDetails();
            mstrCodeNamePairDetails.setCode(drngEnum.getCode());
            mstrCodeNamePairDetails.setName(drngEnum.name());
            mstrCodeNamePairDetailsList.add(mstrCodeNamePairDetails);
        }
        return this.getJSONResponse(mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/approverDepartments"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getApproverDepartments() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getApproverDepartments();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/wardWisePropertyDetails"}, method={RequestMethod.GET}, produces={"application/json"})
    public List<AssessmentInfo> getWardWisePropertyDetails(AssessmentRequest assessmentRequest) throws IOException {
        return this.propertyExternalService.getPropertyDetailsForWard(assessmentRequest.getUlbCode(), assessmentRequest.getWardNum(), assessmentRequest.getAssessmentNo(), assessmentRequest.getDoorNo());
    }

    private String getJSONResponse(Object obj) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }

    private ErrorDetails getInvalidCredentialsErrorDetails() {
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-1");
        errorDetails.setErrorMessage("Invaild Credentials");
        return errorDetails;
    }

    private ErrorDetails getRequestFailedErrorDetails() {
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-3");
        errorDetails.setErrorMessage("Communication Failure or Server may be down");
        return errorDetails;
    }

    @RequestMapping(value={"/property/documentTypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getDocumentTypes() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getDocumentTypes();
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    @RequestMapping(value={"/property/mutationReasons"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getMutatioReasons() throws IOException {
        List mstrCodeNamePairDetailsList = this.propertyExternalService.getReasonsForChangeProperty("TRANSFER");
        return this.getJSONResponse((Object)mstrCodeNamePairDetailsList);
    }

    private Object getObjectFromJSONRequest(String jsonString, Class cls) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        mapper.setDateFormat((DateFormat)ChequePayment.CHEQUE_DATE_FORMAT);
        return mapper.readValue(jsonString, cls);
    }
}

