/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.contracts.tradelicense;

import java.util.Date;
import org.egov.infra.utils.DateUtils;
import org.egov.tl.entity.License;

public class TradeLicenseDetailResponse {
    private String tin;
    private String assessmentNo;
    private String ownerName;
    private String mobileNumber;
    private String expiryDate;
    private String category;
    private String subCategory;
    private String tradeTitle;

    public TradeLicenseDetailResponse(License license) {
        this.tin = license.getLicenseNumber();
        this.assessmentNo = license.getAssessmentNo();
        this.ownerName = license.getLicensee().getApplicantName();
        this.mobileNumber = license.getLicensee().getMobilePhoneNumber();
        this.expiryDate = DateUtils.getDefaultFormattedDate((Date)(license.getDateOfExpiry() == null ? new Date() : license.getDateOfExpiry()));
        this.category = license.getCategory().getName();
        this.subCategory = license.getTradeName().getName();
        this.tradeTitle = license.getNameOfEstablishment();
    }

    public String getTin() {
        return this.tin;
    }

    public String getAssessmentNo() {
        return this.assessmentNo;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getExpiryDate() {
        return this.expiryDate;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSubCategory() {
        return this.subCategory;
    }

    public String getTradeTitle() {
        return this.tradeTitle;
    }
}

