/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import org.egov.restapi.service.FinancialMasterService;
import org.egov.restapi.util.JsonConvertor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FinancialMasterController {
    @Autowired
    private FinancialMasterService financialMasterService;

    @RequestMapping(value={"/egf/funds"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getAllActiveFunds() {
        return JsonConvertor.convert((Object)this.financialMasterService.populateFund());
    }

    @RequestMapping(value={"/egf/schemes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getAllActiveSchemes() {
        return JsonConvertor.convert((Object)this.financialMasterService.populateScheme());
    }

    @RequestMapping(value={"/egf/subschemes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getAllActiveSubSchemes() {
        return JsonConvertor.convert((Object)this.financialMasterService.populateSubScheme());
    }

    @RequestMapping(value={"/egf/functions"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getAllActiveFunctions() {
        return JsonConvertor.convert((Object)this.financialMasterService.populateFunction());
    }

    @RequestMapping(value={"/egf/chartofaccounts/detailedcodes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getChartOfAccounts() {
        return JsonConvertor.convert((Object)this.financialMasterService.populateChartOfAccounts());
    }

    @RequestMapping(value={"/egf/budgetgroups"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getAllActiveBudgetGroups() {
        try {
            return JsonConvertor.convert((Object)this.financialMasterService.populateBudgetGroup());
        }
        catch (Exception e) {
            return JsonConvertor.convert((Object)"");
        }
    }
}

