/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.dcb.bean.ChequePayment;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.restapi.model.ContractorHelper;
import org.egov.restapi.model.RestErrors;
import org.egov.restapi.service.ExternalContractorService;
import org.egov.restapi.util.JsonConvertor;
import org.egov.works.masters.entity.Contractor;
import org.egov.works.masters.service.ContractorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ContractorController {
    @Autowired
    private ContractorService contractorService;
    @Autowired
    private ExternalContractorService externalContractorService;

    @RequestMapping(value={"/egworks/contractors"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getContractors(@RequestParam(value="code", required=false) String code) {
        if (StringUtils.isBlank((String)code)) {
            return JsonConvertor.convert((Object)this.externalContractorService.populateContractor());
        }
        RestErrors restErrors = new RestErrors();
        Contractor contractor = this.contractorService.getContractorByCode(code);
        if (contractor == null) {
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-1");
            restErrors.setErrorMessage("No contractor exists with given contractor code");
            return JsonConvertor.convert((Object)restErrors);
        }
        return JsonConvertor.convert((Object)this.externalContractorService.populateContractorData(contractor));
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/egworks/contractor"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String createContractor(@RequestBody String requestJson, HttpServletRequest request) throws IOException {
        List errors = new ArrayList<RestErrors>();
        RestErrors restErrors = new RestErrors();
        ApplicationThreadLocals.setUserId((Long)2L);
        if (StringUtils.isBlank((String)requestJson)) {
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-3");
            restErrors.setErrorMessage("Please send valid JSON request");
            errors.add(restErrors);
            return JsonConvertor.convert(errors);
        }
        ContractorHelper contractorHelper = (ContractorHelper)this.getObjectFromJSONRequest(requestJson, ContractorHelper.class);
        errors = this.externalContractorService.validateContactorToCreate(contractorHelper);
        if (!errors.isEmpty()) {
            return JsonConvertor.convert(errors);
        }
        Contractor contractor = this.externalContractorService.populateContractorToCreate(contractorHelper);
        Contractor savedContractor = this.externalContractorService.saveContractor(contractor);
        StringBuilder successMessage = new StringBuilder();
        successMessage.append("Contractor data saved successfully with code ").append(savedContractor.getCode());
        return JsonConvertor.convert((Object)successMessage.toString());
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/egworks/contractor"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json"})
    public String updateContractor(@RequestBody String requestJson, HttpServletRequest request) throws IOException {
        List errors = new ArrayList<RestErrors>();
        RestErrors restErrors = new RestErrors();
        ApplicationThreadLocals.setUserId((Long)2L);
        if (StringUtils.isBlank((String)requestJson)) {
            restErrors.setErrorCode("EGWORKS-CONTRACTOR-3");
            restErrors.setErrorMessage("Please send valid JSON request");
            errors.add(restErrors);
            return JsonConvertor.convert((Object)restErrors);
        }
        ContractorHelper contractorHelper = (ContractorHelper)this.getObjectFromJSONRequest(requestJson, ContractorHelper.class);
        errors = this.externalContractorService.validateContactorToUpdate(contractorHelper);
        if (!errors.isEmpty()) {
            return JsonConvertor.convert(errors);
        }
        Contractor contractor = this.externalContractorService.populateContractorToUpdate(contractorHelper);
        Contractor savedContractor = this.externalContractorService.updateContractor(contractor);
        StringBuilder modifyMessage = new StringBuilder();
        modifyMessage.append("Contractor data modified successfully with code ").append(savedContractor.getCode());
        return JsonConvertor.convert((Object)modifyMessage);
    }

    private Object getObjectFromJSONRequest(String jsonString, Class cls) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        mapper.setDateFormat((DateFormat)ChequePayment.CHEQUE_DATE_FORMAT);
        return mapper.readValue(jsonString, cls);
    }
}

