/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.egov.egf.commons.EgovCommon;
import org.egov.egf.expensebill.service.ExpenseBillService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationException;
import org.egov.model.bills.EgBillregister;
import org.egov.restapi.model.RestErrors;
import org.egov.restapi.util.JsonConvertor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class BillPaymentStatusController {
    private static final Logger LOG = Logger.getLogger(BillPaymentStatusController.class);
    @Autowired
    private EgovCommon egovCommon;
    @Autowired
    private ExpenseBillService expenseBillService;

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(value={"/egf/bill/paymentamount"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getPaymentAmount(@RequestParam String billNumber, HttpServletRequest request) {
        BigDecimal paymentAmount;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rest API getting payment status for the bill number: " + billNumber));
        }
        ApplicationThreadLocals.setUserId((Long)2L);
        EgBillregister egBillregister = null;
        try {
            egBillregister = this.expenseBillService.getByBillnumber(billNumber);
            if (egBillregister == null) {
                RestErrors restErrors = new RestErrors();
                restErrors.setErrorCode("EGF-REST-31");
                restErrors.setErrorMessage("Please provide valid Bill Number");
                return JsonConvertor.convert((Object)restErrors);
            }
            paymentAmount = this.egovCommon.getPaymentAmount(egBillregister.getId());
        }
        catch (ApplicationException e) {
            LOG.error((Object)e.getStackTrace());
            RestErrors re = new RestErrors();
            re.setErrorCode(e.getMessage());
            re.setErrorMessage(e.getMessage());
            return JsonConvertor.convert((Object)re);
        }
        return JsonConvertor.convert((Object)paymentAmount);
    }
}

