/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.filter;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.restapi.config.properties.RestAPIApplicationProperties;
import org.egov.restapi.filter.MultiReadRequestWrapper;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class ApiFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(ApiFilter.class);
    private static final String SOURCE = "source";
    private static final String ULB_CODE = "ulbCode";
    private static final String RESTAPI_ERROR_CODE = "RESTAPI.001";
    private static final EnumMap<Source, List<String>> SOURCE_IP_MAPPING = new EnumMap(Source.class);
    @Autowired
    private CityService cityService;
    @Autowired
    private RestAPIApplicationProperties restAPIProperties;
    @Autowired
    @Qualifier(value="ulbCodeMap")
    private Map<String, String> ulbCodeMap;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        MultiReadRequestWrapper multiReadRequestWrapper = new MultiReadRequestWrapper((HttpServletRequest)request);
        String ulbCode = this.validateAndExtractULBCode(multiReadRequestWrapper);
        if (StringUtils.isNotBlank((CharSequence)ulbCode)) {
            boolean diffDestination = !ulbCode.equals(ApplicationThreadLocals.getCityCode());
            LOG.info("Requested ULB Code :- reached : {}, destination : {}. Altering tenant info : {}", new Object[]{ApplicationThreadLocals.getCityCode(), ulbCode, diffDestination});
            if (diffDestination) {
                String tenantId = (String)this.ulbCodeMap.get(ulbCode);
                ApplicationThreadLocals.setTenantID((String)tenantId);
                City city = this.cityService.getCityByCode(ulbCode);
                ApplicationThreadLocals.setDomainName((String)city.getDomainURL());
                ApplicationThreadLocals.setCityCode((String)ulbCode);
            }
        } else {
            throw new ApplicationRuntimeException("Could not obtain ULB Code from the request");
        }
        filterChain.doFilter((ServletRequest)multiReadRequestWrapper, response);
    }

    private String validateAndExtractULBCode(MultiReadRequestWrapper request) throws IOException {
        Optional<Map.Entry> resolvedIP;
        HttpSession session;
        String referrer = request.getHeader("Referer");
        if (StringUtils.isNotBlank((CharSequence)referrer)) {
            session = request.getSession();
            resolvedIP = SOURCE_IP_MAPPING.entrySet().parallelStream().filter(e -> ((List)e.getValue()).parallelStream().anyMatch(referrer::contains)).findFirst();
            if (!resolvedIP.isPresent()) {
                throw new ApplicationRuntimeException(RESTAPI_ERROR_CODE);
            }
        } else {
            throw new ApplicationRuntimeException(RESTAPI_ERROR_CODE);
        }
        session.setAttribute(SOURCE, resolvedIP.get().getKey());
        String ulbCode = request.getParameter(ULB_CODE);
        return StringUtils.isBlank((CharSequence)ulbCode) ? new JSONObject(IOUtils.toString((InputStream)request.getInputStream(), (Charset)Charsets.UTF_8)).get(ULB_CODE).toString() : ulbCode;
    }

    public void init(FilterConfig arg0) throws ServletException {
        SOURCE_IP_MAPPING.put(Source.APONLINE, this.restAPIProperties.aponlineIPAddress());
        SOURCE_IP_MAPPING.put(Source.ESEVA, this.restAPIProperties.esevaIPAddress());
        SOURCE_IP_MAPPING.put(Source.SOFTTECH, this.restAPIProperties.softtechIPAddress());
        SOURCE_IP_MAPPING.put(Source.CARD, this.restAPIProperties.cardIPAddress());
        SOURCE_IP_MAPPING.put(Source.LEADWINNER, this.restAPIProperties.leadwinnerIPAddress());
    }

    public void destroy() {
    }
}

