/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.egov.billsaccounting.services.CreateVoucher;
import org.egov.commons.CVoucherHeader;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.restapi.model.CreateVoucherHelper;
import org.egov.restapi.model.RestErrors;
import org.egov.restapi.service.ExternalVoucherService;
import org.egov.restapi.util.JsonConvertor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class VoucherController {
    private static final Logger LOG = Logger.getLogger(VoucherController.class);
    @Autowired
    private CreateVoucher createVoucher;
    @Autowired
    private ExternalVoucherService externalVoucherService;

    @RequestMapping(value={"/egf/voucher/create"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String createVoucher(@RequestBody CreateVoucherHelper createVoucherHelper, HttpServletResponse response) {
        CVoucherHeader cVoucherHeader;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rest API creating voucher with the data: " + createVoucherHelper));
        }
        ApplicationThreadLocals.setUserId((Long)2L);
        List<RestErrors> errorList = new ArrayList<RestErrors>(0);
        RestErrors re = new RestErrors();
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
        try {
            createVoucherHelper.getHeaderDetails().put("voucherdate", formatter.parse(createVoucherHelper.getHeaderDetails().get("voucherdate").toString()));
        }
        catch (ParseException e1) {
            re.setErrorCode("EGF-VOUCHER-4");
            re.setErrorMessage("Please send Voucher Date in header deatils");
            errorList.add(re);
            response.setStatus(400);
            return JsonConvertor.convert(errorList);
        }
        errorList = this.externalVoucherService.validateVoucherReuest(createVoucherHelper);
        if (!errorList.isEmpty()) {
            response.setStatus(400);
            return JsonConvertor.convert(errorList);
        }
        JsonObject jsonObject = new JsonObject();
        try {
            cVoucherHeader = this.createVoucher.createPreApprovedVoucher(createVoucherHelper.getHeaderDetails(), createVoucherHelper.getAccountCodeDetails(), createVoucherHelper.getSubledgerDetails());
        }
        catch (ApplicationRuntimeException e) {
            re.setErrorCode(e.getMessage());
            re.setErrorMessage(e.getMessage());
            errorList.add(re);
            response.setStatus(400);
            return JsonConvertor.convert(errorList);
        }
        catch (ValidationException e) {
            re.setErrorCode(((ValidationError)e.getErrors().get(0)).getKey());
            re.setErrorMessage(((ValidationError)e.getErrors().get(0)).getMessage());
            errorList.add(re);
            response.setStatus(400);
            return JsonConvertor.convert(errorList);
        }
        catch (Exception e) {
            re.setErrorCode(e.getMessage());
            re.setErrorMessage(e.getMessage());
            errorList.add(re);
            response.setStatus(400);
            return JsonConvertor.convert(errorList);
        }
        jsonObject.addProperty("successMessage", "Voucher Created Successfully");
        jsonObject.addProperty("voucherNumber", cVoucherHeader.getVoucherNumber());
        response.setStatus(201);
        return jsonObject.toString();
    }
}

