/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.dcb.bean.ChequePayment;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.restapi.model.AssessmentRequest;
import org.egov.restapi.util.JsonConvertor;
import org.egov.restapi.util.ValidationUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SurveyDetailsController {
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private ValidationUtil validationUtil;

    @RequestMapping(value={"/property/pulseAssessmentDetails"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getAssessmentDetails(@RequestBody String assessmentRequest) throws IOException, ParseException {
        String responseJson;
        AssessmentRequest assessmentReq = (AssessmentRequest)this.getObjectFromJSONRequest(assessmentRequest, AssessmentRequest.class);
        ErrorDetails errorDetails = this.validationUtil.validateSurveyRequest(assessmentReq);
        if (errorDetails != null) {
            responseJson = JsonConvertor.convert((Object)errorDetails);
        } else {
            List assessmentDetails = this.propertyExternalService.getPropertyDetailsForSurvey(assessmentReq.getTransactionType(), assessmentReq.getFromDate(), assessmentReq.getToDate());
            responseJson = JsonConvertor.convert((Object)assessmentDetails);
        }
        return responseJson;
    }

    private Object getObjectFromJSONRequest(String jsonString, Class cls) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        mapper.setDateFormat((DateFormat)ChequePayment.CHEQUE_DATE_FORMAT);
        return mapper.readValue(jsonString, cls);
    }
}

