/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.util.List;
import java.util.stream.Collectors;
import org.egov.adtax.service.AdvertisementPermitDetailService;
import org.egov.restapi.model.AdvertisementDetails;
import org.egov.restapi.model.AdvertisementRequest;
import org.egov.restapi.model.RestErrors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/adtax"})
public class RestAdvertisementController {
    @Autowired
    private AdvertisementPermitDetailService advertisementPermitDetailService;

    @GetMapping(value={"/details"}, consumes={"application/json"}, produces={"application/json"})
    public List<AdvertisementDetails> advertisementDetails(AdvertisementRequest request) {
        return this.advertisementPermitDetailService.getAdvertisementPermitDetailByWardAndAdvertisementNumber(request.getWardNumber(), request.getAdvertisementNo()).parallelStream().map(AdvertisementDetails::new).collect(Collectors.toList());
    }

    @ExceptionHandler(value={RuntimeException.class})
    public RestErrors restErrors(RuntimeException runtimeException) {
        return new RestErrors("ADVERTISEMENT DOES NOT EXIST", runtimeException.getMessage());
    }
}

