/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.egov.restapi.model.CreateVoucherHelper;
import org.egov.restapi.model.RestErrors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ExternalVoucherService {
    public List<RestErrors> validateVoucherReuest(CreateVoucherHelper createVoucherHelper) {
        Date voucherDate;
        ArrayList<RestErrors> errors = new ArrayList<RestErrors>();
        RestErrors restErrors = null;
        if (createVoucherHelper == null) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-VOUCHER-1");
            restErrors.setErrorMessage("Please send valid JSON request");
            errors.add(restErrors);
        }
        if (createVoucherHelper != null && createVoucherHelper.getHeaderDetails().isEmpty()) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-VOUCHER-2");
            restErrors.setErrorMessage("Please send valid Header Details in JSON request");
            errors.add(restErrors);
        }
        if (createVoucherHelper != null && createVoucherHelper.getAccountCodeDetails().isEmpty()) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-VOUCHER-3");
            restErrors.setErrorMessage("Please send valid Account Code Details in JSON request");
            errors.add(restErrors);
        }
        if (createVoucherHelper != null && !createVoucherHelper.getHeaderDetails().isEmpty() && createVoucherHelper.getHeaderDetails().get("voucherdate") != null && (voucherDate = (Date)createVoucherHelper.getHeaderDetails().get("voucherdate")).after(new Date())) {
            restErrors = new RestErrors();
            restErrors.setErrorCode("EGF-VOUCHER-5");
            restErrors.setErrorMessage("Voucher date cannot be future date");
            errors.add(restErrors);
        }
        return errors;
    }
}

