/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import javax.validation.Valid;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.restapi.model.WaterConnectionInfo;
import org.egov.restapi.web.rest.RestWaterConnectionValidationService;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ChangeOfUseService;
import org.egov.wtms.application.service.NewConnectionService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.ApplicationProcessTimeService;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.egov.wtms.masters.service.PipeSizeService;
import org.egov.wtms.masters.service.PropertyTypeService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.masters.service.WaterSourceService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestWaterConnectionController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private NewConnectionService newConnectionService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private ApplicationProcessTimeService applicationProcessTimeService;
    @Autowired
    private ConnectionCategoryService connectionCategoryService;
    @Autowired
    private RestWaterConnectionValidationService restWaterConnectionValidationService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private PipeSizeService pipeSizeService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private PropertyTypeService propertyTypeService;
    @Autowired
    private UsageTypeService usageTypeService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private WaterSourceService waterSourceService;
    @Autowired
    private ChangeOfUseService changeOfUseService;
    public static final String SUCCESS = "SUCCESS";

    @RequestMapping(value={"/watercharges/newconnection"}, method={RequestMethod.POST}, produces={"application/json"})
    public String createNewConnection(@Valid @RequestBody WaterConnectionInfo WaterConnectionInfo2) throws JsonGenerationException, JsonMappingException, IOException, ParseException {
        ErrorDetails response = this.restWaterConnectionValidationService.validatePropertyID(WaterConnectionInfo2.getPropertyID());
        if (response != null) {
            return this.getJSONResponse((Object)response);
        }
        ErrorDetails errorMessage = this.restWaterConnectionValidationService.validateWaterConnectionDetails(WaterConnectionInfo2);
        if (errorMessage != null) {
            return this.getJSONResponse((Object)errorMessage);
        }
        ErrorDetails errorDetails = this.restWaterConnectionValidationService.validateCreateRequest(WaterConnectionInfo2);
        if (errorDetails != null) {
            return this.getJSONResponse((Object)errorDetails);
        }
        String applicationCode = "NEWCONNECTION";
        WaterConnectionDetails waterConnectionDetails = this.populateAndPersistWaterConnectionDetails(WaterConnectionInfo2, "NEWCONNECTION");
        return waterConnectionDetails.getApplicationNumber();
    }

    @RequestMapping(value={"/watercharges/additionalconnection"}, method={RequestMethod.POST}, produces={"application/json"})
    public String createAddtionalConnection(@Valid @RequestBody WaterConnectionInfo waterConnectionInfo) throws JsonGenerationException, JsonMappingException, IOException, ParseException {
        ErrorDetails response = this.restWaterConnectionValidationService.validateAdditionalWaterConnectionDetails(waterConnectionInfo);
        String applicationCode = "ADDNLCONNECTION";
        if (response != null) {
            return this.getJSONResponse((Object)response);
        }
        ErrorDetails errorDetails = this.restWaterConnectionValidationService.validateCreateRequest(waterConnectionInfo);
        if (errorDetails != null) {
            return this.getJSONResponse((Object)errorDetails);
        }
        WaterConnectionDetails waterConnectionDetails = this.populateAndPersistWaterConnectionDetails(waterConnectionInfo, "ADDNLCONNECTION");
        return waterConnectionDetails.getApplicationNumber();
    }

    @RequestMapping(value={"/watercharges/changeofuse"}, method={RequestMethod.POST}, produces={"application/json"})
    public String createChangeOfUsageConnection(@Valid @RequestBody WaterConnectionInfo waterConnectionInfo) throws JsonGenerationException, JsonMappingException, IOException, ParseException {
        ErrorDetails response = this.restWaterConnectionValidationService.validateChangOfUsageWaterConnectionDetails(waterConnectionInfo);
        String applicationCode = "CHANGEOFUSE";
        if (response != null) {
            return this.getJSONResponse((Object)response);
        }
        ErrorDetails errorMessage = this.restWaterConnectionValidationService.validateCombinationOfChangOfUsage(waterConnectionInfo);
        if (errorMessage != null) {
            return this.getJSONResponse((Object)response);
        }
        ErrorDetails errorDetails = this.restWaterConnectionValidationService.validateCreateRequest(waterConnectionInfo);
        if (errorDetails != null) {
            return this.getJSONResponse((Object)errorDetails);
        }
        WaterConnectionDetails waterConnectionDetails = this.populateAndPersistWaterConnectionDetails(waterConnectionInfo, "CHANGEOFUSE");
        return waterConnectionDetails.getApplicationNumber();
    }

    private WaterConnectionDetails populateAndPersistWaterConnectionDetails(WaterConnectionInfo WaterConnectionInfo2, String applicationCode) {
        WaterConnectionDetails waterConnectionDetails = null;
        Long approvalPosition = 0L;
        Position userPosition = null;
        if (!applicationCode.equals("CHANGEOFUSE")) {
            waterConnectionDetails = this.prepareNewAndAdditionalConnectionDetails(WaterConnectionInfo2, applicationCode);
            userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier());
        } else {
            WaterConnectionDetails connectionUnderChange = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(WaterConnectionInfo2.getConsumerCode(), ConnectionStatus.ACTIVE);
            waterConnectionDetails = this.prepareChangeOfUsageWaterConnectionDetails(WaterConnectionInfo2, connectionUnderChange);
            waterConnectionDetails.setConnection(connectionUnderChange.getConnection());
            userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(connectionUnderChange.getConnection().getPropertyIdentifier());
        }
        if (userPosition != null) {
            approvalPosition = userPosition.getId();
        }
        waterConnectionDetails = applicationCode.equals("CHANGEOFUSE") ? this.changeOfUseService.createChangeOfUseApplication(waterConnectionDetails, approvalPosition, "Rest Api", waterConnectionDetails.getApplicationType().getCode(), null, null) : this.waterConnectionDetailsService.createNewWaterConnection(waterConnectionDetails, approvalPosition, "Rest Api", waterConnectionDetails.getApplicationType().getCode(), null, null);
        return waterConnectionDetails;
    }

    private WaterConnectionDetails prepareNewAndAdditionalConnectionDetails(WaterConnectionInfo WaterConnectionInfo2, String applicationCode) {
        WaterConnection waterConnection = new WaterConnection();
        WaterConnectionDetails waterConnectionDetails = new WaterConnectionDetails();
        waterConnection.setPropertyIdentifier(WaterConnectionInfo2.getPropertyID());
        waterConnectionDetails.setConnection(waterConnection);
        waterConnectionDetails.setApplicationDate(new Date());
        if (applicationCode.equals("NEWCONNECTION")) {
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("NEWCONNECTION"));
        } else {
            WaterConnection connection = this.waterConnectionService.findByConsumerCode(WaterConnectionInfo2.getConsumerCode());
            waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("ADDNLCONNECTION"));
            waterConnection.setParentConnection(connection);
        }
        waterConnectionDetails.setCategory(this.connectionCategoryService.findByCode(WaterConnectionInfo2.getCategory()));
        return this.prepareWaterConnectionDetails(WaterConnectionInfo2, waterConnectionDetails);
    }

    private WaterConnectionDetails prepareChangeOfUsageWaterConnectionDetails(WaterConnectionInfo waterConnectionInfo, WaterConnectionDetails waterConnectionDetails) {
        WaterConnectionDetails changeOfUse = new WaterConnectionDetails();
        changeOfUse.setApplicationDate(new Date());
        changeOfUse.setApplicationType(this.applicationTypeService.findByCode("CHANGEOFUSE"));
        changeOfUse.setCategory(this.connectionCategoryService.findByCode(waterConnectionInfo.getCategory()));
        changeOfUse.setConnectionReason(waterConnectionInfo.getReasonforChangeOfUsage());
        return this.prepareWaterConnectionDetails(waterConnectionInfo, changeOfUse);
    }

    private WaterConnectionDetails prepareWaterConnectionDetails(WaterConnectionInfo WaterConnectionInfo2, WaterConnectionDetails waterConnectionDetails) {
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.INPROGRESS);
        waterConnectionDetails.setConnectionType(WaterConnectionInfo2.getConnectionType().equals(ConnectionType.METERED.toString()) ? ConnectionType.METERED : ConnectionType.NON_METERED);
        Integer appProcessTime = this.applicationProcessTimeService.getApplicationProcessTime(waterConnectionDetails.getApplicationType(), waterConnectionDetails.getCategory());
        if (appProcessTime != null) {
            waterConnectionDetails.setDisposalDate(this.waterConnectionDetailsService.getDisposalDate(waterConnectionDetails, appProcessTime));
        }
        waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CREATED", "WATERTAXAPPLICATION"));
        waterConnectionDetails.setPipeSize(this.pipeSizeService.findByCode(WaterConnectionInfo2.getPipeSize()));
        waterConnectionDetails.setPropertyType(this.propertyTypeService.findByCode(WaterConnectionInfo2.getPropertyType()));
        waterConnectionDetails.setUsageType(this.usageTypeService.findByCode(WaterConnectionInfo2.getUsageType()));
        waterConnectionDetails.setWaterSource(this.waterSourceService.findByCode(WaterConnectionInfo2.getWaterSource()));
        if (waterConnectionDetails.getUsageType().getCode().equals("LODGES")) {
            waterConnectionDetails.setNumberOfRooms(WaterConnectionInfo2.getNumberOfRooms());
        } else {
            waterConnectionDetails.setNumberOfPerson(WaterConnectionInfo2.getNumberOfPersons());
        }
        return waterConnectionDetails;
    }

    private String getJSONResponse(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }

    public Boolean authenticateUser(String username, String password) {
        Boolean isAuthenticated = false;
        if (username.equals("mahesh") && password.equals("demo")) {
            isAuthenticated = true;
        }
        ApplicationThreadLocals.setUserId((Long)Long.valueOf("2"));
        return isAuthenticated;
    }
}

