/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.egov.infra.web.support.json.adapter.HibernateProxyTypeAdapter;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.egov.wtms.masters.service.DocumentNamesService;
import org.egov.wtms.masters.service.PipeSizeService;
import org.egov.wtms.masters.service.PropertyTypeService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.masters.service.WaterSourceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestWaterChargesMasterController {
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private ConnectionCategoryService connectionCategoryService;
    @Autowired
    private UsageTypeService usageTypeService;
    @Autowired
    private DocumentNamesService documentNamesService;
    @Autowired
    private PipeSizeService pipeSizeService;
    @Autowired
    private WaterSourceService waterSourceService;
    @Autowired
    private PropertyTypeService propertyTypeService;

    @RequestMapping(value={"/watercharges/categories"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getConnectionCategoryList() throws JsonGenerationException, JsonMappingException, IOException {
        List connectionCategoryList = this.connectionCategoryService.getConnectionCategoryListForRest();
        return this.getJSONResponse((Object)connectionCategoryList);
    }

    @RequestMapping(value={"/watercharges/usagetypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getUsageTypeList() throws JsonGenerationException, JsonMappingException, IOException {
        List usageTypeList = this.usageTypeService.getUsageTypeListForRest();
        return this.getJSONResponse((Object)usageTypeList);
    }

    @RequestMapping(value={"/watercharges/documentnames"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getDocumentNameList() throws JsonGenerationException, JsonMappingException, IOException {
        List documentNamesList = this.documentNamesService.getDocumentNamesListForRest();
        return this.getJSONResponse((Object)documentNamesList);
    }

    @RequestMapping(value={"/watercharges/pipesizes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getPipeSizeList() throws JsonGenerationException, JsonMappingException, IOException {
        List pipeSizeList = this.pipeSizeService.getPipeSizeListForRest();
        return this.getJSONResponse((Object)pipeSizeList);
    }

    @RequestMapping(value={"/watercharges/watersourcetypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getWaterSourceTypes() throws JsonGenerationException, JsonMappingException, IOException {
        List waterSourceList = this.waterSourceService.getWaterSourceListForRest();
        return this.getJSONResponse((Object)waterSourceList);
    }

    @RequestMapping(value={"/watercharges/waterconnectiontypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getWaterConnectionTypes() throws JsonGenerationException, JsonMappingException, IOException {
        ArrayList connectionTypeList = new ArrayList(0);
        HashMap<String, String> meteredTypeMap = new HashMap<String, String>(0);
        meteredTypeMap.put("code", ConnectionType.METERED.toString());
        HashMap<String, String> nonMeteredTypeMap = new HashMap<String, String>(0);
        nonMeteredTypeMap.put("code", ConnectionType.NON_METERED.toString());
        connectionTypeList.add(meteredTypeMap);
        connectionTypeList.add(nonMeteredTypeMap);
        return this.getJSONResponse(connectionTypeList);
    }

    @RequestMapping(value={"/watercharges/propertytypes"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getPropertyTypes() throws JsonGenerationException, JsonMappingException, IOException {
        List propertyTypeList = this.propertyTypeService.getPropertyTypeListForRest();
        return this.getJSONResponse((Object)propertyTypeList);
    }

    private String getJSONResponse(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        Gson jsonCreator = new GsonBuilder().registerTypeAdapterFactory(HibernateProxyTypeAdapter.FACTORY).disableHtmlEscaping().create();
        return jsonCreator.toJson(obj, new /* Unavailable Anonymous Inner Class!! */.getType());
    }
}

