/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.ws.rs.FormParam;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.objection.RevisionPetition;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.service.revisionPetition.RevisionPetitionService;
import org.egov.restapi.model.CreateRevisionPetitionDetails;
import org.egov.restapi.web.rest.RevisionPetitionAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RevisionPetitionRestService {
    @Autowired
    private RevisionPetitionService revisionPetitionService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    String USER_NAME = "mahesh";
    String PASSWORD = "demo";
    String LOGIN_USERID = "16";

    @RequestMapping(value={"/property/revisionPetition"}, method={RequestMethod.POST}, produces={"application/json"})
    public String getRevisionPetitionDetails(@FormParam(value="applicationNo") String applicationNo) throws JsonGenerationException, JsonMappingException, IOException {
        RevisionPetition revisionPetition = this.revisionPetitionService.getRevisionPetitionByApplicationNumber(applicationNo);
        if (revisionPetition != null) {
            return this.convertRevisionPetitionObjectToJson((Object)revisionPetition);
        }
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-21");
        errorDetails.setErrorMessage("Invalid Revision petition number.");
        return this.getJSONResponse((Object)errorDetails);
    }

    @RequestMapping(value={"/property/createRevisionPetition"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String createRevisionPetitionFromRest(@RequestBody String createRevionPetitionDetails) throws JsonGenerationException, JsonMappingException, IOException {
        String responseJson = new String();
        ApplicationThreadLocals.setUserId((Long)Long.valueOf(this.LOGIN_USERID));
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        CreateRevisionPetitionDetails revionPetitionDetails = (CreateRevisionPetitionDetails)mapper.readValue(createRevionPetitionDetails, CreateRevisionPetitionDetails.class);
        String assessmentNo = revionPetitionDetails.getAssessmentNo();
        String details = revionPetitionDetails.getDetails();
        String receivedOn = revionPetitionDetails.getReceivedOn();
        String receivedBy = revionPetitionDetails.getReceivedBy();
        ErrorDetails errorDetails = this.validateRevisionPetitionForm(assessmentNo, details, receivedOn, receivedBy);
        if (null != errorDetails) {
            responseJson = this.getJSONResponse((Object)errorDetails);
        } else {
            try {
                BasicProperty basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(assessmentNo);
                if (basicProperty != null && basicProperty.isUnderWorkflow()) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("PTIS-REST-20");
                    errorDetails.setErrorMessage("Selected property can not be objected,the property is in objected state or the property is in a different workflow");
                    return this.getJSONResponse((Object)errorDetails);
                }
                RevisionPetition revPetition = new RevisionPetition();
                revPetition.setBasicProperty(basicProperty);
                revPetition.setRecievedBy(receivedBy);
                revPetition.setDetails(details);
                SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
                revPetition.setRecievedOn(sdf.parse(receivedOn));
                responseJson = this.convertRevisionPetitionObjectToJson((Object)this.revisionPetitionService.createRevisionPetitionForRest(revPetition));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return responseJson;
    }

    private ErrorDetails validateRevisionPetitionForm(String accessmentnumber, String details, String receivedon, String recievedBy) {
        ErrorDetails errorDetails = null;
        if (accessmentnumber == null || accessmentnumber.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-12");
            errorDetails.setErrorMessage("Assessment number is required");
        } else {
            if (accessmentnumber.trim().length() > 0 && accessmentnumber.trim().length() < 10) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-8");
                errorDetails.setErrorMessage("Assessment number length can not less than 10 digits");
            }
            if (!this.basicPropertyDAO.isAssessmentNoExist(accessmentnumber).booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-11");
                errorDetails.setErrorMessage("Assessment number not found");
            }
        }
        if (receivedon == null || receivedon.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-17");
            errorDetails.setErrorMessage("Revision petition received date required");
        } else if (recievedBy == null || recievedBy.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-18");
            errorDetails.setErrorMessage("Revision petition received user details required");
        } else if (details == null || details.trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-19");
            errorDetails.setErrorMessage("Revision petition details are required");
        }
        return errorDetails;
    }

    private String convertRevisionPetitionObjectToJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(RevisionPetition.class, (Object)new RevisionPetitionAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    private String getJSONResponse(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }

    private ErrorDetails getInvalidCredentialsErrorDetails() {
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-1");
        errorDetails.setErrorMessage("Invaild Credentials");
        return errorDetails;
    }

    public RevisionPetitionService getRevisionPetitionService() {
        return this.revisionPetitionService;
    }

    public void setRevisionPetitionService(RevisionPetitionService revisionPetitionService) {
        this.revisionPetitionService = revisionPetitionService;
    }

    public Boolean authenticateUser(String username, String password) {
        Boolean isAuthenticated = false;
        if (username != null && password != null && username.equals(this.USER_NAME) && password.equals(this.PASSWORD)) {
            isAuthenticated = true;
        }
        return isAuthenticated;
    }
}

