/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.model.RestPropertyTaxDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.restapi.util.JsonConvertor;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.application.service.collection.WaterTaxExternalService;
import org.egov.wtms.masters.entity.PayWaterTaxDetails;
import org.egov.wtms.masters.entity.WaterConnectionRequestDetails;
import org.egov.wtms.masters.entity.WaterReceiptDetails;
import org.egov.wtms.masters.entity.WaterTaxDetails;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestWaterConnectionCollection {
    private static Logger LOG = Logger.getLogger(RestWaterConnectionCollection.class);
    @Autowired
    private WaterTaxExternalService waterTaxExternalService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private PropertyExternalService propertyExternalService;

    @RequestMapping(value={"/watercharges/paywatertax"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String payWaterTax(@Valid @RequestBody PayWaterTaxDetails payWaterTaxDetails, HttpServletRequest request) {
        WaterReceiptDetails waterReceiptDetails = null;
        try {
            ErrorDetails errorDetails = this.validatePaymentDetails(payWaterTaxDetails);
            if (null != errorDetails) {
                return JsonConvertor.convert((Object)errorDetails);
            }
            payWaterTaxDetails.setSource(request.getSession().getAttribute("source") != null ? request.getSession().getAttribute("source").toString() : "");
            waterReceiptDetails = this.waterTaxExternalService.payWaterTax(payWaterTaxDetails);
        }
        catch (ValidationException e) {
            e.printStackTrace();
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            List errors = e.getErrors();
            for (ValidationError ve : errors) {
                ErrorDetails er = new ErrorDetails();
                er.setErrorCode(ve.getKey());
                er.setErrorMessage(ve.getMessage());
                errorList.add(er);
            }
            JsonConvertor.convert(errorList);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            ErrorDetails er = new ErrorDetails();
            er.setErrorCode(e.getMessage());
            er.setErrorMessage(e.getMessage());
            errorList.add(er);
            JsonConvertor.convert(errorList);
        }
        return JsonConvertor.convert((Object)waterReceiptDetails);
    }

    @RequestMapping(value={"/watercharges/getwatertaxdetails"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getWaterTaxDetailsByAppLicationOrConsumerNumber(@Valid @RequestBody PayWaterTaxDetails payWaterTaxDetails) throws JsonGenerationException, JsonMappingException, IOException, BindException {
        ErrorDetails errorDetails = this.validateConsumerAndApplicationNumber(payWaterTaxDetails);
        if (null != errorDetails) {
            return JsonConvertor.convert((Object)errorDetails);
        }
        WaterTaxDetails waterTaxDetails = this.waterTaxExternalService.getWaterTaxDemandDet(payWaterTaxDetails);
        if (waterTaxDetails.getConsumerNo() == null || "".equals(waterTaxDetails.getConsumerNo())) {
            waterTaxDetails.setConsumerNo("");
        }
        if (waterTaxDetails.getOwnerName() == null) {
            waterTaxDetails.setOwnerName("");
        }
        if (waterTaxDetails.getLocalityName() == null) {
            waterTaxDetails.setLocalityName("");
        }
        if (waterTaxDetails.getPropertyAddress() == null) {
            waterTaxDetails.setPropertyAddress("");
        }
        if (waterTaxDetails.getTaxDetails() == null) {
            RestPropertyTaxDetails ar = new RestPropertyTaxDetails();
            ArrayList<RestPropertyTaxDetails> taxDetails = new ArrayList<RestPropertyTaxDetails>(0);
            taxDetails.add(ar);
            waterTaxDetails.setTaxDetails(taxDetails);
        }
        return JsonConvertor.convert((Object)waterTaxDetails);
    }

    @RequestMapping(value={"/watercharges/getwatertaxdetailsByOwnerDetails"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getWaterTaxDetailsByAppLicationOrConsumerNumberByOwnerDetails(@Valid @RequestBody WaterConnectionRequestDetails waterConnectionRequestDetails) throws JsonGenerationException, JsonMappingException, IOException, BindException {
        ErrorDetails errorDetails = null;
        if (waterConnectionRequestDetails.getConsumerNo() != null) {
            errorDetails = this.validateConsumerNumber(waterConnectionRequestDetails.getConsumerNo());
        }
        if (null != errorDetails) {
            return JsonConvertor.convert((Object)errorDetails);
        }
        List propertyTaxDetailsList = new ArrayList();
        String assessmentNo = "";
        if (waterConnectionRequestDetails.getConsumerNo() != null) {
            assessmentNo = this.waterConnectionService.findByConsumerCode(waterConnectionRequestDetails.getConsumerNo()).getPropertyIdentifier();
        }
        String ownerName = "";
        String mobileNumber = "";
        if (waterConnectionRequestDetails.getOwnerName() != null) {
            ownerName = waterConnectionRequestDetails.getOwnerName();
        }
        if (waterConnectionRequestDetails.getMobileNo() != null) {
            mobileNumber = waterConnectionRequestDetails.getMobileNo();
        }
        String category = "";
        String doorNo = "";
        if (!(StringUtils.isBlank((String)assessmentNo) && StringUtils.isBlank((String)ownerName) && StringUtils.isBlank((String)mobileNumber) && StringUtils.isBlank((String)""))) {
            propertyTaxDetailsList = this.propertyExternalService.getPropertyTaxDetails(assessmentNo, ownerName, mobileNumber, "", "");
        }
        List waterConnectionList = new ArrayList();
        ArrayList<String> consumerCodesList = new ArrayList<String>();
        for (PropertyTaxDetails propertyTaxDetails : propertyTaxDetailsList) {
            waterConnectionList = this.waterConnectionService.findByPropertyIdentifier(propertyTaxDetails.getAssessmentNo());
            for (WaterConnection waterconnection : waterConnectionList) {
                consumerCodesList.add(waterconnection.getConsumerCode());
            }
        }
        if (consumerCodesList.size() == 0 || consumerCodesList.size() > 1000) {
            ErrorDetails errordetails = new ErrorDetails();
            errordetails.setErrorCode("WCMS-REST-15");
            errordetails.setErrorMessage("Water Tax Details is empty or morethan 100");
            return JsonConvertor.convert((Object)errordetails);
        }
        ArrayList<WaterTaxDetails> waterTaxDetailsList = new ArrayList<WaterTaxDetails>();
        WaterTaxDetails watertaxdetails = new WaterTaxDetails();
        for (String consumerCode : consumerCodesList) {
            watertaxdetails = this.waterTaxExternalService.getWaterTaxDemandDetByConsumerCode(consumerCode);
            if (watertaxdetails.getConsumerNo() == null || "".equals(watertaxdetails.getConsumerNo())) {
                watertaxdetails.setConsumerNo("");
            }
            if (watertaxdetails.getOwnerName() == null) {
                watertaxdetails.setOwnerName("");
            }
            if (watertaxdetails.getLocalityName() == null) {
                watertaxdetails.setLocalityName("");
            }
            if (watertaxdetails.getPropertyAddress() == null) {
                watertaxdetails.setPropertyAddress("");
            }
            if (watertaxdetails.getTaxDetails() == null) {
                RestPropertyTaxDetails ar = new RestPropertyTaxDetails();
                ArrayList<RestPropertyTaxDetails> taxDetails = new ArrayList<RestPropertyTaxDetails>(0);
                taxDetails.add(ar);
                watertaxdetails.setTaxDetails(taxDetails);
            }
            waterTaxDetailsList.add(watertaxdetails);
        }
        return JsonConvertor.convert(waterTaxDetailsList);
    }

    public ErrorDetails validatePaymentDetails(PayWaterTaxDetails payWaterTaxDetails) {
        BillReceiptInfo billReceipt;
        ErrorDetails errorDetails = null;
        WaterConnectionDetails waterConnDetailsObj = null;
        errorDetails = this.validateConsumerAndApplicationNumber(payWaterTaxDetails);
        if (payWaterTaxDetails.getApplicaionNumber() != null && !"".equals(payWaterTaxDetails.getApplicaionNumber())) {
            waterConnDetailsObj = this.waterConnectionDetailsService.findByApplicationNumber(payWaterTaxDetails.getApplicaionNumber());
        } else if (payWaterTaxDetails.getConsumerNo() != null) {
            waterConnDetailsObj = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(payWaterTaxDetails.getConsumerNo(), ConnectionStatus.ACTIVE);
        }
        if (waterConnDetailsObj == null) {
            waterConnDetailsObj = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(payWaterTaxDetails.getConsumerNo(), ConnectionStatus.INACTIVE);
            if (waterConnDetailsObj != null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("WCMS-REST-14");
                errorDetails.setErrorMessage("Consumer number is InActive");
            } else {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("WCMS-REST-8");
                errorDetails.setErrorMessage("Either ConsumerCode is not valid or ApplicationNumber not valid");
            }
        }
        if (waterConnDetailsObj != null && waterConnDetailsObj.getConnectionType().equals((Object)ConnectionType.NON_METERED)) {
            BigDecimal totalAmountDue = this.waterConnectionDetailsService.getTotalAmount(waterConnDetailsObj);
            LOG.error((Object)("totalAmountDue:" + totalAmountDue));
            LOG.error((Object)("payWaterTaxDetails.getTotalAmount():" + payWaterTaxDetails.getTotalAmount()));
            LOG.error((Object)("compare " + totalAmountDue.compareTo(payWaterTaxDetails.getTotalAmount())));
            LOG.error((Object)("compare " + totalAmountDue.compareTo(payWaterTaxDetails.getTotalAmount())));
            if (totalAmountDue.compareTo(payWaterTaxDetails.getTotalAmount()) == -1) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("WTMS-REST-11");
                errorDetails.setErrorMessage("Paid Amount is greater than Total Amount to be paid");
            }
        }
        if (payWaterTaxDetails.getTransactionId() == null || "".equals(payWaterTaxDetails.getTransactionId())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-25");
            errorDetails.setErrorMessage("Invalid Request, No transaction ID is associated");
        } else if (!(payWaterTaxDetails.getTransactionId() == null && "".equals(payWaterTaxDetails.getTransactionId()) || (billReceipt = this.waterTaxExternalService.validateTransanctionIdPresent(payWaterTaxDetails.getTransactionId())) == null)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-26");
            errorDetails.setErrorMessage("Invalid Request, Used transaction ID is associated");
        }
        if (payWaterTaxDetails.getPaymentMode() == null || payWaterTaxDetails.getPaymentMode().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-13");
            errorDetails.setErrorMessage("Payment mode is required");
        } else if (!("CASH".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().trim()) || "CHEQUE".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().trim()))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-14");
            errorDetails.setErrorMessage("Payment mode is invalid");
        }
        if (payWaterTaxDetails.getPaymentMode() != null && ("CHEQUE".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().trim()))) {
            if (payWaterTaxDetails.getChqddNo() == null || payWaterTaxDetails.getChqddNo().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-34");
                errorDetails.setErrorMessage("Cheque/DD number is required");
            } else if (payWaterTaxDetails.getChqddDate() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-35");
                errorDetails.setErrorMessage("Cheque/DD Date is required");
            } else if (payWaterTaxDetails.getBankName() == null || payWaterTaxDetails.getBankName().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-36");
                errorDetails.setErrorMessage("Bank Name is required");
            } else if (payWaterTaxDetails.getBranchName() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-37");
                errorDetails.setErrorMessage("Branch Name  is required");
            }
        }
        return errorDetails;
    }

    private ErrorDetails validateConsumerAndApplicationNumber(PayWaterTaxDetails payWaterTaxDetails) {
        ErrorDetails errorDetails = null;
        if (payWaterTaxDetails.getConsumerNo() == null || payWaterTaxDetails.getConsumerNo().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-12");
            errorDetails.setErrorMessage("Cosumer Code is required");
        } else if (payWaterTaxDetails.getConsumerNo().trim().length() > 0 && payWaterTaxDetails.getConsumerNo().trim().length() < 10) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-9");
            errorDetails.setErrorMessage("Consumer number length can not less than 10 digits");
        }
        if (payWaterTaxDetails.getConsumerNo() == null && payWaterTaxDetails.getApplicaionNumber() == null) {
            errorDetails.setErrorCode("WTMS-REST-13");
            errorDetails.setErrorMessage("Either Cosumer Code or Application number is required");
        } else if (payWaterTaxDetails.getApplicaionNumber() != null && payWaterTaxDetails.getApplicaionNumber().trim().length() > 0 && payWaterTaxDetails.getApplicaionNumber().trim().length() < 13) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-10");
            errorDetails.setErrorMessage("Application number length can not less than 13 digits");
        }
        WaterConnectionDetails waterConnDetailsObj = null;
        if (payWaterTaxDetails.getConsumerNo() != null) {
            waterConnDetailsObj = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(payWaterTaxDetails.getConsumerNo(), ConnectionStatus.INACTIVE);
        }
        if (waterConnDetailsObj != null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WCMS-REST-14");
            errorDetails.setErrorMessage("Consumer number is InActive");
        }
        return errorDetails;
    }

    private ErrorDetails validateConsumerNumber(String consumerCode) {
        ErrorDetails errorDetails = null;
        if (consumerCode.trim().length() > 0 && consumerCode.trim().length() < 10) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-9");
            errorDetails.setErrorMessage("Consumer number length can not less than 10 digits");
        }
        WaterConnection waterConnection = null;
        if (consumerCode != null) {
            waterConnection = this.waterConnectionService.findByConsumerCode(consumerCode);
        }
        if (waterConnection == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WCMS-REST-16");
            errorDetails.setErrorMessage("Entered Consumer Code doesn't exist");
        }
        WaterConnectionDetails waterConnDetailsObj = null;
        if (consumerCode != null) {
            waterConnDetailsObj = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.INACTIVE);
        }
        if (waterConnDetailsObj != null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WCMS-REST-14");
            errorDetails.setErrorMessage("Consumer number is InActive");
        }
        return errorDetails;
    }
}

