/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.dcb.bean.ChequePayment;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.NewPropertyDetails;
import org.egov.ptis.domain.model.OwnerDetails;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.model.ReceiptDetails;
import org.egov.ptis.domain.model.RestAssessmentDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.ptis.domain.service.transfer.PropertyTransferService;
import org.egov.restapi.model.AssessmentRequest;
import org.egov.restapi.model.OwnerInformation;
import org.egov.restapi.model.PropertyTransferDetails;
import org.egov.restapi.util.JsonConvertor;
import org.egov.restapi.util.ValidationUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PropertyTitleTransferService {
    @Autowired
    private ValidationUtil validationUtil;
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private PropertyTransferService transferOwnerService;

    @RequestMapping(value={"/property/titletransfer"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String transferProperty(@RequestBody String titleTransferDetails) throws JsonGenerationException, JsonMappingException, IOException, ParseException {
        String responseJson = new String();
        ApplicationThreadLocals.setUserId((Long)2L);
        PropertyTransferDetails propertyTransferDetails = (PropertyTransferDetails)this.getObjectFromJSONRequest(titleTransferDetails, PropertyTransferDetails.class);
        ErrorDetails errorDetails = ValidationUtil.validatePropertyTransferRequest((PropertyTransferDetails)propertyTransferDetails);
        if (errorDetails != null) {
            responseJson = JsonConvertor.convert((Object)errorDetails);
        } else {
            String assessmentNo = propertyTransferDetails.getAssessmentNo();
            String mutationReasonCode = propertyTransferDetails.getMutationReasonCode();
            String saleDetails = propertyTransferDetails.getSaleDetails();
            String deedNo = propertyTransferDetails.getDeedNo();
            String deedDate = propertyTransferDetails.getDeedDate();
            List ownerDetailsList = this.getOwnerDetails(propertyTransferDetails.getOwnerDetails());
            NewPropertyDetails newPropertyDetails = this.transferOwnerService.createPropertyMutation(assessmentNo, mutationReasonCode, saleDetails, deedNo, deedDate, ownerDetailsList);
            responseJson = JsonConvertor.convert((Object)newPropertyDetails);
        }
        return responseJson;
    }

    private List<OwnerDetails> getOwnerDetails(List<OwnerInformation> ownerInfoList) {
        ArrayList<OwnerDetails> ownerDetailsList = new ArrayList<OwnerDetails>();
        for (OwnerInformation ownerInfo : ownerInfoList) {
            OwnerDetails ownerDetails = new OwnerDetails();
            ownerDetails.setAadhaarNo(ownerInfo.getAadhaarNo());
            ownerDetails.setSalutationCode(ownerInfo.getSalutationCode());
            ownerDetails.setName(ownerInfo.getName());
            ownerDetails.setGender(ownerInfo.getGender());
            ownerDetails.setMobileNumber(ownerInfo.getMobileNumber());
            ownerDetails.setEmailId(ownerInfo.getEmailId());
            ownerDetails.setGuardianRelation(ownerInfo.getGuardianRelation());
            ownerDetails.setGuardian(ownerInfo.getGuardian());
            ownerDetailsList.add(ownerDetails);
        }
        return ownerDetailsList;
    }

    @RequestMapping(value={"/property/assessmentdetails"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String fetchAssessmentDetails(@RequestBody String assessmentRequest) throws JsonGenerationException, JsonMappingException, IOException {
        AssessmentRequest assessmentReq = (AssessmentRequest)this.getObjectFromJSONRequest(assessmentRequest, AssessmentRequest.class);
        String responseJson = new String();
        ErrorDetails errorDetails = this.validationUtil.validateAssessmentDetailsRequest(assessmentReq);
        if (errorDetails != null) {
            responseJson = this.getJSONResponse((Object)errorDetails);
        } else {
            RestAssessmentDetails assessmentDetails = this.propertyExternalService.fetchAssessmentDetails(assessmentReq.getAssessmentNo());
            responseJson = this.getJSONResponse((Object)assessmentDetails);
        }
        return responseJson;
    }

    @RequestMapping(value={"/property/paymutationfee"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String payMutationFee(@RequestBody String payPropertyTaxDetails, HttpServletRequest request, String source) throws JsonGenerationException, JsonMappingException, IOException {
        String responseJson;
        try {
            responseJson = new String();
            PayPropertyTaxDetails payPropTaxDetails = (PayPropertyTaxDetails)this.getObjectFromJSONRequest(payPropertyTaxDetails, PayPropertyTaxDetails.class);
            ErrorDetails errorDetails = this.validationUtil.validatePaymentDetails(payPropTaxDetails, true);
            if (null != errorDetails) {
                responseJson = this.getJSONResponse((Object)errorDetails);
            } else {
                if (StringUtils.isNotBlank((CharSequence)source)) {
                    payPropTaxDetails.setSource(source);
                } else {
                    payPropTaxDetails.setSource(request.getSession().getAttribute("source") != null ? request.getSession().getAttribute("source").toString() : "");
                }
                ReceiptDetails receiptDetails = this.propertyExternalService.payMutationFee(payPropTaxDetails);
                responseJson = this.getJSONResponse((Object)receiptDetails);
            }
        }
        catch (ValidationException e) {
            e.printStackTrace();
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            List errors = e.getErrors();
            for (ValidationError ve : errors) {
                ErrorDetails er = new ErrorDetails();
                er.setErrorCode(ve.getKey());
                er.setErrorMessage(ve.getMessage());
                errorList.add(er);
            }
            responseJson = JsonConvertor.convert(errorList);
        }
        catch (Exception e) {
            e.printStackTrace();
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            ErrorDetails er = new ErrorDetails();
            er.setErrorCode(e.getMessage());
            er.setErrorMessage(e.getMessage());
            errorList.add(er);
            responseJson = JsonConvertor.convert(errorList);
        }
        return responseJson;
    }

    private Object getObjectFromJSONRequest(String jsonString, Class cls) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        mapper.setDateFormat((DateFormat)ChequePayment.CHEQUE_DATE_FORMAT);
        return mapper.readValue(jsonString, cls);
    }

    private String getJSONResponse(Object obj) throws JsonGenerationException, JsonMappingException, IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        String jsonResponse = objectMapper.writeValueAsString(obj);
        return jsonResponse;
    }
}

