/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.util;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.ptis.client.util.PropertyTaxUtil;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.Property;
import org.egov.ptis.domain.entity.property.PropertyMutation;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.FloorDetails;
import org.egov.ptis.domain.model.PayPropertyTaxDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.restapi.model.AssessmentRequest;
import org.egov.restapi.model.AssessmentsDetails;
import org.egov.restapi.model.ConstructionTypeDetails;
import org.egov.restapi.model.CreatePropertyDetails;
import org.egov.restapi.model.OwnerInformation;
import org.egov.restapi.model.PropertyAddressDetails;
import org.egov.restapi.model.PropertyTransferDetails;
import org.egov.restapi.model.SurroundingBoundaryDetails;
import org.egov.restapi.model.VacantLandDetails;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValidationUtil {
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private PropertyTaxUtil propertyTaxUtil;

    public static ErrorDetails validatePropertyTransferRequest(PropertyTransferDetails propertyTransferDetails) {
        ErrorDetails errorDetails = null;
        String assessmentNumber = propertyTransferDetails.getAssessmentNo();
        if (StringUtils.isBlank((CharSequence)assessmentNumber)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("51");
            errorDetails.setErrorMessage("Assessment Number is required.");
            return errorDetails;
        }
        String mutationReasonCode = propertyTransferDetails.getMutationReasonCode();
        if (StringUtils.isBlank((CharSequence)mutationReasonCode)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("52");
            errorDetails.setErrorMessage("Mutation Reason Code is required.");
            return errorDetails;
        }
        if (!(!StringUtils.isNotBlank((CharSequence)mutationReasonCode) || mutationReasonCode.equalsIgnoreCase("GIFTDEED") || mutationReasonCode.equalsIgnoreCase("WILLDEED") || mutationReasonCode.equalsIgnoreCase("SALEDEED") || mutationReasonCode.equalsIgnoreCase("RELINQUISH") || mutationReasonCode.equalsIgnoreCase("PARTITIOND"))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("56");
            errorDetails.setErrorMessage("Invalid Mutation Reason Code. It can be GIFTDEED/WILLDEED/SALEDEED/RELINQUISH/PARTITIOND");
            return errorDetails;
        }
        if (mutationReasonCode.equalsIgnoreCase("SALEDEED") && StringUtils.isBlank((CharSequence)propertyTransferDetails.getSaleDetails())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("53");
            errorDetails.setErrorMessage("Sale Details are required.");
            return errorDetails;
        }
        if (!mutationReasonCode.equalsIgnoreCase("SALEDEED") && StringUtils.isNotBlank((CharSequence)propertyTransferDetails.getSaleDetails())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("57");
            errorDetails.setErrorMessage("Sale Details are required only if reason is Sale Deed.");
            return errorDetails;
        }
        String deedNo = propertyTransferDetails.getDeedNo();
        if (StringUtils.isBlank((CharSequence)deedNo)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("54");
            errorDetails.setErrorMessage("Deed Number is required.");
            return errorDetails;
        }
        String deedDate = propertyTransferDetails.getDeedDate();
        if (StringUtils.isBlank((CharSequence)deedDate)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("55");
            errorDetails.setErrorMessage("Deed Date is required.");
            return errorDetails;
        }
        List ownerDetailsList = propertyTransferDetails.getOwnerDetails();
        if (ownerDetailsList.isEmpty()) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("35");
            errorDetails.setErrorMessage("Owner Details is required.");
            return errorDetails;
        }
        for (OwnerInformation ownerInfo : ownerDetailsList) {
            if (ownerInfo.getMobileNumber() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("30");
                errorDetails.setErrorMessage("Mobile Number is required.");
                return errorDetails;
            }
            if (ownerInfo.getName() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("30");
                errorDetails.setErrorMessage("Owner Name is required.");
                return errorDetails;
            }
            if (ownerInfo.getGender() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("31");
                errorDetails.setErrorMessage("Gender is required.");
                return errorDetails;
            }
            if (ownerInfo.getGuardianRelation() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("32");
                errorDetails.setErrorMessage("Guardian Relation is required.");
                return errorDetails;
            }
            if (ownerInfo.getGuardian() != null) continue;
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("33");
            errorDetails.setErrorMessage("Guardian is required.");
            return errorDetails;
        }
        return errorDetails;
    }

    public ErrorDetails validateCreateRequest(CreatePropertyDetails createPropDetails) throws ParseException {
        PropertyAddressDetails propertyAddressDetails;
        ErrorDetails errorDetails = null;
        String propertyTypeMasterCode = createPropDetails.getPropertyTypeMasterCode();
        if (StringUtils.isBlank((CharSequence)propertyTypeMasterCode)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("01");
            errorDetails.setErrorMessage("Category of Ownership is required.");
            return errorDetails;
        }
        if (!(propertyTypeMasterCode == null || propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND") || propertyTypeMasterCode.equalsIgnoreCase("PRIVATE") || propertyTypeMasterCode.equalsIgnoreCase("STATE_GOVT") || propertyTypeMasterCode.equalsIgnoreCase("CENTRAL_GOVT_33.5") || propertyTypeMasterCode.equalsIgnoreCase("CENTRAL_GOVT_50") || propertyTypeMasterCode.equalsIgnoreCase("CENTRAL_GOVT_75"))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("02");
            errorDetails.setErrorMessage("Invalid Category of Ownership. It can be VAC_LAND/PRIVATE/STATE_GOVT/CENTRAL_GOVT_33.5/CENTRAL_GOVT_50/CENTRAL_GOVT_75.");
            return errorDetails;
        }
        String propertyCategoryCode = createPropDetails.getCategoryCode();
        if (StringUtils.isBlank((CharSequence)propertyCategoryCode)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("03");
            errorDetails.setErrorMessage("Property Type is required.");
            return errorDetails;
        }
        if (!(propertyCategoryCode == null || propertyCategoryCode.equalsIgnoreCase("VACANTLAND") || propertyCategoryCode.equalsIgnoreCase("STATE_GOVT") || propertyCategoryCode.equalsIgnoreCase("CENTRAL_GOVT") || propertyCategoryCode.equalsIgnoreCase("RESIDENTIAl") || propertyCategoryCode.equalsIgnoreCase("NON_RESIDENTIAL") || propertyCategoryCode.equalsIgnoreCase("MIXED"))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("04");
            errorDetails.setErrorMessage("Invalid Property Type. It can be RESIDENTIAl/NON_RESIDENTIAL/MIXED");
            return errorDetails;
        }
        Double areaOfPlot = 0.0;
        List ownerDetailsList = createPropDetails.getOwnerDetails();
        if (ownerDetailsList == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("35");
            errorDetails.setErrorMessage("Owner Details is required.");
            return errorDetails;
        }
        for (OwnerInformation ownerDetails : ownerDetailsList) {
            if (StringUtils.isBlank((CharSequence)ownerDetails.getMobileNumber())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("30");
                errorDetails.setErrorMessage("Mobile Number is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)ownerDetails.getName())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("30");
                errorDetails.setErrorMessage("Owner Name is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)ownerDetails.getGender())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("31");
                errorDetails.setErrorMessage("Gender is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)ownerDetails.getGuardianRelation())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("32");
                errorDetails.setErrorMessage("Guardian Relation is required.");
                return errorDetails;
            }
            if (!StringUtils.isBlank((CharSequence)ownerDetails.getGuardian())) continue;
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("33");
            errorDetails.setErrorMessage("Guardian is required.");
            return errorDetails;
        }
        AssessmentsDetails assessmentsDetails = createPropDetails.getAssessmentDetails();
        if (assessmentsDetails == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("36");
            errorDetails.setErrorMessage("Assessment Details is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)assessmentsDetails.getMutationReasonCode())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("37");
            errorDetails.setErrorMessage("Reason For Creation is required.");
            return errorDetails;
        }
        if (!propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND")) {
            if (StringUtils.isBlank((CharSequence)assessmentsDetails.getExtentOfSite())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("38");
                errorDetails.setErrorMessage("Extent of Site (Sq.Mtrs) is required.");
                return errorDetails;
            }
            if (Double.valueOf(assessmentsDetails.getExtentOfSite()) == 0.0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("61");
                errorDetails.setErrorMessage("Area/Extent of site should be greate than 0.");
                return errorDetails;
            }
            areaOfPlot = Double.valueOf(assessmentsDetails.getExtentOfSite());
            if (assessmentsDetails.getIsExtentAppurtenantLand().booleanValue()) {
                if (StringUtils.isBlank((CharSequence)assessmentsDetails.getExtentAppartenauntLand())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("38");
                    errorDetails.setErrorMessage("Extent of Site (Sq.Mtrs) is required.");
                    return errorDetails;
                }
                if (Double.valueOf(assessmentsDetails.getExtentAppartenauntLand()) == 0.0) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("61");
                    errorDetails.setErrorMessage("Area/Extent of site should be greate than 0.");
                    return errorDetails;
                }
            }
        }
        if (StringUtils.isBlank((CharSequence)assessmentsDetails.getRegdDocNo())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("05");
            errorDetails.setErrorMessage("Registration Doc No is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)assessmentsDetails.getRegdDocDate())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("06");
            errorDetails.setErrorMessage("Registration Doc Date is required.");
            return errorDetails;
        }
        if (this.propertyExternalService.convertStringToDate(assessmentsDetails.getRegdDocDate()).after(new Date())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("75");
            errorDetails.setErrorMessage("Registration Doc Date/Construction Date/Occupancy Date cannot be greater than current date.");
            return errorDetails;
        }
        if (propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND")) {
            VacantLandDetails vacantLandDetails = createPropDetails.getVacantLandDetails();
            if (vacantLandDetails == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("39");
                errorDetails.setErrorMessage("Vacant Land Details is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)vacantLandDetails.getSurveyNumber())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("07");
                errorDetails.setErrorMessage("Survey Number is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)vacantLandDetails.getPattaNumber())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("08");
                errorDetails.setErrorMessage("Patta Number is required.");
                return errorDetails;
            }
            if (vacantLandDetails.getVacantLandArea() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("09");
                errorDetails.setErrorMessage("Vacant Land Area is required.");
                return errorDetails;
            }
            if ((double)Float.valueOf(vacantLandDetails.getVacantLandArea().floatValue()).floatValue() == 0.0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("61");
                errorDetails.setErrorMessage("Area/Extent of site should be greate than 0.");
                return errorDetails;
            }
            if (vacantLandDetails.getMarketValue() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("10");
                errorDetails.setErrorMessage("Market area Value per Sq.Mtrs (As Per Current Registration department) is required.");
                return errorDetails;
            }
            if (Double.valueOf(vacantLandDetails.getMarketValue()) == 0.0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("62");
                errorDetails.setErrorMessage("Market Value should be greate than 0.");
                return errorDetails;
            }
            if (vacantLandDetails.getCurrentCapitalValue() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("11");
                errorDetails.setErrorMessage("Current Capital Value is required.");
                return errorDetails;
            }
            if (Double.valueOf(vacantLandDetails.getCurrentCapitalValue()) == 0.0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("63");
                errorDetails.setErrorMessage("Current Capital Value should be greate than 0.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)vacantLandDetails.getEffectiveDate())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("12");
                errorDetails.setErrorMessage("Effective Date is required.");
                return errorDetails;
            }
            SurroundingBoundaryDetails surBoundaryDetails = createPropDetails.getSurroundingBoundaryDetails();
            if (surBoundaryDetails == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("41");
                errorDetails.setErrorMessage("Surrounding Boundary Details is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)surBoundaryDetails.getNorthBoundary())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("13");
                errorDetails.setErrorMessage("North is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)surBoundaryDetails.getSouthBoundary())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("14");
                errorDetails.setErrorMessage("South is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)surBoundaryDetails.getEastBoundary())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("15");
                errorDetails.setErrorMessage("East is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)surBoundaryDetails.getWestBoundary())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("16");
                errorDetails.setErrorMessage("East is required.");
                return errorDetails;
            }
        }
        if ((propertyAddressDetails = createPropDetails.getPropertyAddressDetails()) == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("71");
            errorDetails.setErrorMessage("Property address details are required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getLocalityNum())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("26");
            errorDetails.setErrorMessage("Locality is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getZoneNum())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("27");
            errorDetails.setErrorMessage("Zone no is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getWardNum())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("28");
            errorDetails.setErrorMessage("Zone no is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getBlockNum())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("29");
            errorDetails.setErrorMessage("Block no is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getElectionWardNum())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("72");
            errorDetails.setErrorMessage("Election Ward is required.");
            return errorDetails;
        }
        if (StringUtils.isBlank((CharSequence)propertyAddressDetails.getPinCode())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("25");
            errorDetails.setErrorMessage("Pin Code is required.");
            return errorDetails;
        }
        if (!propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND") && StringUtils.isBlank((CharSequence)propertyAddressDetails.getDoorNo())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("73");
            errorDetails.setErrorMessage("Door Number is required.");
            return errorDetails;
        }
        if (!propertyTypeMasterCode.equalsIgnoreCase("VAC_LAND")) {
            ConstructionTypeDetails constructionTypeDetails = createPropDetails.getConstructionTypeDetails();
            if (constructionTypeDetails == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("74");
                errorDetails.setErrorMessage("Please enter the construction details.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)constructionTypeDetails.getFloorTypeId())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("23");
                errorDetails.setErrorMessage("Floor Type is required.");
                return errorDetails;
            }
            if (StringUtils.isBlank((CharSequence)constructionTypeDetails.getRoofTypeId())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("24");
                errorDetails.setErrorMessage("Roof Type is required.");
                return errorDetails;
            }
            List floorDetailsList = createPropDetails.getFloorDetails();
            if (floorDetailsList == null || floorDetailsList.isEmpty()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("40");
                errorDetails.setErrorMessage("Floor Details is required.");
                return errorDetails;
            }
            for (FloorDetails floorDetails : floorDetailsList) {
                if (StringUtils.isBlank((CharSequence)floorDetails.getFloorNoCode())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("17");
                    errorDetails.setErrorMessage("Floor Number is required.");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getBuildClassificationCode())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("18");
                    errorDetails.setErrorMessage("Floor Number is required.");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getNatureOfUsageCode())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("19");
                    errorDetails.setErrorMessage("Nature of Usage is required.");
                    return errorDetails;
                }
                if (!floorDetails.getNatureOfUsageCode().equalsIgnoreCase("RESD") && StringUtils.isBlank((CharSequence)floorDetails.getFirmName())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("64");
                    errorDetails.setErrorMessage("Area/Extent of site should be greate than 0.");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getOccupancyCode())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("20");
                    errorDetails.setErrorMessage("Occupancy is required.");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getConstructionDate())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("21");
                    errorDetails.setErrorMessage("Construction Date is required.");
                    return errorDetails;
                }
                if (StringUtils.isBlank((CharSequence)floorDetails.getOccupancyDate())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("65");
                    errorDetails.setErrorMessage("Occupancy Date is required.");
                    return errorDetails;
                }
                Date constructionDate = this.propertyExternalService.convertStringToDate(floorDetails.getConstructionDate());
                Date occupancyDate = this.propertyExternalService.convertStringToDate(floorDetails.getOccupancyDate());
                if (constructionDate.after(new Date()) || occupancyDate.after(new Date())) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("75");
                    errorDetails.setErrorMessage("Registration Doc Date/Construction Date/Occupancy Date cannot be greater than current date.");
                    return errorDetails;
                }
                if (occupancyDate.before(constructionDate)) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("76");
                    errorDetails.setErrorMessage("Occupancy Date cannot be before Construction Date.");
                    return errorDetails;
                }
                if (!floorDetails.getUnstructuredLand().booleanValue()) {
                    if (floorDetails.getPlinthLength() == null) {
                        errorDetails = new ErrorDetails();
                        errorDetails.setErrorCode("67");
                        errorDetails.setErrorMessage("Plinth length is required.");
                        return errorDetails;
                    }
                    if ((double)Float.valueOf(floorDetails.getPlinthLength().floatValue()).floatValue() == 0.0) {
                        errorDetails = new ErrorDetails();
                        errorDetails.setErrorCode("68");
                        errorDetails.setErrorMessage("Plinth length should be greater than 0.");
                        return errorDetails;
                    }
                    if (floorDetails.getPlinthBreadth() == null) {
                        errorDetails = new ErrorDetails();
                        errorDetails.setErrorCode("69");
                        errorDetails.setErrorMessage("Plinth breadth is required.");
                        return errorDetails;
                    }
                    if ((double)Float.valueOf(floorDetails.getPlinthBreadth().floatValue()).floatValue() == 0.0) {
                        errorDetails = new ErrorDetails();
                        errorDetails.setErrorCode("66");
                        errorDetails.setErrorMessage("Plinth area should be greater than 0.");
                        return errorDetails;
                    }
                }
                if (floorDetails.getPlinthArea() == null) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("22");
                    errorDetails.setErrorMessage("Plinth area (Sq.Mtrs) is required.");
                    return errorDetails;
                }
                if (Double.valueOf(floorDetails.getPlinthArea().floatValue()) == 0.0) {
                    errorDetails = new ErrorDetails();
                    errorDetails.setErrorCode("66");
                    errorDetails.setErrorMessage("Plinth area should be greater than 0.");
                    return errorDetails;
                }
                if (!(Double.valueOf(floorDetails.getPlinthArea().floatValue()) > areaOfPlot)) continue;
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("77");
                errorDetails.setErrorMessage("Plinth Area cannot be greater than Extent of Site.");
                return errorDetails;
            }
        }
        return errorDetails;
    }

    public ErrorDetails validatePaymentDetails(PayPropertyTaxDetails payPropTaxDetails, boolean isMutationFeePayment) {
        BillReceiptInfo billReceiptList;
        ErrorDetails errorDetails = null;
        if (payPropTaxDetails.getAssessmentNo() == null || payPropTaxDetails.getAssessmentNo().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-12");
            errorDetails.setErrorMessage("Assessment number is required");
        } else {
            Property property;
            BasicProperty basicProperty;
            if (payPropTaxDetails.getAssessmentNo().trim().length() > 0 && payPropTaxDetails.getAssessmentNo().trim().length() < 10) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-8");
                errorDetails.setErrorMessage("Assessment number length can not less than 10 digits");
            }
            if (!this.basicPropertyDAO.isAssessmentNoExist(payPropTaxDetails.getAssessmentNo()).booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-11");
                errorDetails.setErrorMessage("Assessment number not found");
            }
            if ((basicProperty = this.basicPropertyDAO.getBasicPropertyByPropertyID(payPropTaxDetails.getAssessmentNo())) != null && (property = basicProperty.getProperty()) != null && property.getIsExemptedFromTax().booleanValue()) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-42");
                errorDetails.setErrorMessage("Property is Exempted");
            }
        }
        if (isMutationFeePayment) {
            PropertyMutation propertyMutation;
            if (!this.propertyExternalService.validateMutationFee(payPropTaxDetails.getAssessmentNo(), payPropTaxDetails.getPaymentAmount())) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-40");
                errorDetails.setErrorMessage("Mutation fee entered is excess");
            }
            if ((propertyMutation = this.propertyExternalService.getLatestPropertyMutationByAssesmentNo(payPropTaxDetails.getAssessmentNo())) == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-41");
                errorDetails.setErrorMessage("There are no mutations done for this assessment number");
            }
        }
        if (payPropTaxDetails.getTransactionId() == null || "".equals(payPropTaxDetails.getTransactionId())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-25");
            errorDetails.setErrorMessage("Invalid Request, No transaction ID is associated");
        } else if (!(payPropTaxDetails.getTransactionId() == null && "".equals(payPropTaxDetails.getTransactionId()) || (billReceiptList = this.propertyExternalService.validateTransanctionIdPresent(payPropTaxDetails.getTransactionId())) == null)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-26");
            errorDetails.setErrorMessage("Invalid Request, Used transaction ID is associated");
        }
        if (payPropTaxDetails.getPaymentMode() == null || payPropTaxDetails.getPaymentMode().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-13");
            errorDetails.setErrorMessage("Payment mode is required");
        } else if (!("CASH".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()) || "CHEQUE".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-14");
            errorDetails.setErrorMessage("Payment mode is invalid");
        }
        if (payPropTaxDetails.getPaymentMode() != null && ("CHEQUE".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(payPropTaxDetails.getPaymentMode().trim()))) {
            if (payPropTaxDetails.getChqddNo() == null || payPropTaxDetails.getChqddNo().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-34");
                errorDetails.setErrorMessage("Cheque/DD number is required");
            } else if (payPropTaxDetails.getChqddDate() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-35");
                errorDetails.setErrorMessage("Cheque/DD Date is required");
            } else if (payPropTaxDetails.getBankName() == null || payPropTaxDetails.getBankName().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-36");
                errorDetails.setErrorMessage("Bank Name is required");
            } else if (payPropTaxDetails.getBranchName() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-37");
                errorDetails.setErrorMessage("Branch Name  is required");
            }
        }
        return errorDetails;
    }

    public ErrorDetails validateAssessmentDetailsRequest(AssessmentRequest assessmentRequest) {
        ErrorDetails errorDetails = null;
        if (!this.basicPropertyDAO.isAssessmentNoExist(assessmentRequest.getAssessmentNo()).booleanValue()) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-11");
            errorDetails.setErrorMessage("Assessment number not found");
        }
        return errorDetails;
    }
}

