/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.restapi.model.StateCityInfo;
import org.egov.restapi.model.dashboard.CollIndexTableData;
import org.egov.restapi.model.dashboard.CollectionIndexDetails;
import org.egov.restapi.model.dashboard.CollectionTrend;
import org.egov.restapi.model.dashboard.ConsolidatedCollDetails;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.springframework.stereotype.Service;

@Service
public class DashboardService {
    @PersistenceContext
    private EntityManager entityManager;

    public List<StateCityInfo> getStateCityDetails() {
        String query = "select regionname as region, districtname as district, city as city, grade as grade, citycode as ulbcode from public.statecityinfo order by city ";
        SQLQuery sqlQuery = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(query);
        sqlQuery.addScalar("region", (Type)StandardBasicTypes.STRING);
        sqlQuery.addScalar("district", (Type)StandardBasicTypes.STRING);
        sqlQuery.addScalar("city", (Type)StandardBasicTypes.STRING);
        sqlQuery.addScalar("grade", (Type)StandardBasicTypes.STRING);
        sqlQuery.addScalar("ulbCode", (Type)StandardBasicTypes.STRING);
        sqlQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(StateCityInfo.class));
        List stateCityDetails = sqlQuery.list();
        return stateCityDetails;
    }

    public CollectionIndexDetails getCollectionIndexDetails() {
        CollectionIndexDetails collectionIndexDetails = new CollectionIndexDetails();
        collectionIndexDetails.setTodayColl(BigDecimal.valueOf(156.583));
        collectionIndexDetails.setCytdColl(BigDecimal.valueOf(32499.615));
        collectionIndexDetails.setCytdDmd(BigDecimal.valueOf(51338.92));
        collectionIndexDetails.setTotalDmd(BigDecimal.valueOf(123213.409));
        collectionIndexDetails.setLytdColl(BigDecimal.valueOf(16727.998));
        this.prepareCollectionTrends(collectionIndexDetails);
        this.prepareCollIndexData(collectionIndexDetails);
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("PTIS-REST-0");
        errorDetails.setErrorMessage("SUCCESS");
        collectionIndexDetails.setErrorDetails(errorDetails);
        return collectionIndexDetails;
    }

    public void prepareCollIndexData(CollectionIndexDetails collectionIndexDetails) {
        CollIndexTableData collIndData = new CollIndexTableData();
        ArrayList<CollIndexTableData> collIndexResponseList = new ArrayList<CollIndexTableData>();
        collIndData.setRegionName("ANANTAPUR");
        collIndData.setTotalDmd(BigDecimal.valueOf(25204.194));
        collIndData.setCytdDmd(BigDecimal.valueOf(12602.097));
        collIndData.setCytdColl(BigDecimal.valueOf(8326.337));
        collIndData.setCytdBalDmd(BigDecimal.valueOf(4558.5));
        collIndData.setLytdColl(BigDecimal.valueOf(2558.5));
        collIndexResponseList.add(collIndData);
        collIndData = new CollIndexTableData();
        collIndData.setRegionName("GUNTUR");
        collIndData.setTotalDmd(BigDecimal.valueOf(22639.184));
        collIndData.setCytdDmd(BigDecimal.valueOf(11319.592));
        collIndData.setCytdColl(BigDecimal.valueOf(7960.525));
        collIndData.setCytdBalDmd(BigDecimal.valueOf(3595.227));
        collIndData.setLytdColl(BigDecimal.valueOf(1995.227));
        collIndexResponseList.add(collIndData);
        collIndData = new CollIndexTableData();
        collIndData.setRegionName("RAJAHMUNDRY");
        collIndData.setTotalDmd(BigDecimal.valueOf(19053.534));
        collIndData.setCytdDmd(BigDecimal.valueOf(9526.767));
        collIndData.setCytdColl(BigDecimal.valueOf(6399.553));
        collIndData.setCytdBalDmd(BigDecimal.valueOf(3313.139));
        collIndData.setLytdColl(BigDecimal.valueOf(2113.139));
        collIndexResponseList.add(collIndData);
        collIndData = new CollIndexTableData();
        collIndData.setRegionName("VISAKHAPATNAM");
        collIndData.setTotalDmd(BigDecimal.valueOf(35780.93));
        collIndData.setCytdDmd(BigDecimal.valueOf(17890.465));
        collIndData.setCytdColl(BigDecimal.valueOf(9813.2));
        collIndData.setCytdBalDmd(BigDecimal.valueOf(8348.316));
        collIndData.setLytdColl(BigDecimal.valueOf(4348.316));
        collIndexResponseList.add(collIndData);
        collectionIndexDetails.setResponseDetails(collIndexResponseList);
    }

    public void prepareCollectionTrends(CollectionIndexDetails collectionIndexDetails) {
        CollectionTrend collTrend = new CollectionTrend();
        ArrayList<CollectionTrend> collTrendsList = new ArrayList<CollectionTrend>();
        collTrend.setMonth("April");
        collTrend.setPyColl(BigDecimal.valueOf(90.1));
        collTrend.setLyColl(BigDecimal.valueOf(101.31));
        collTrend.setCyColl(BigDecimal.valueOf(150.41));
        collTrendsList.add(collTrend);
        collTrend = new CollectionTrend();
        collTrend.setMonth("May");
        collTrend.setPyColl(BigDecimal.valueOf(190.2));
        collTrend.setLyColl(BigDecimal.valueOf(200.11));
        collTrend.setCyColl(BigDecimal.valueOf(250.01));
        collTrendsList.add(collTrend);
        collTrend = new CollectionTrend();
        collTrend.setMonth("June");
        collTrend.setPyColl(BigDecimal.valueOf(280.02));
        collTrend.setLyColl(BigDecimal.valueOf(300.04));
        collTrend.setCyColl(BigDecimal.valueOf(360.52));
        collTrendsList.add(collTrend);
        collTrend = new CollectionTrend();
        collTrend.setMonth("July");
        collTrend.setPyColl(BigDecimal.valueOf(375.98));
        collTrend.setLyColl(BigDecimal.valueOf(380.95));
        collTrend.setCyColl(BigDecimal.valueOf(400.92));
        collTrendsList.add(collTrend);
        collTrend = new CollectionTrend();
        collTrend.setMonth("August");
        collTrend.setPyColl(BigDecimal.valueOf(400.92));
        collTrend.setLyColl(BigDecimal.valueOf(450.21));
        collTrend.setCyColl(BigDecimal.valueOf(500.25));
        collTrendsList.add(collTrend);
        collTrend = new CollectionTrend();
        collTrend.setMonth("September");
        collTrend.setPyColl(BigDecimal.valueOf(450.93));
        collTrend.setLyColl(BigDecimal.valueOf(550.96));
        collTrend.setCyColl(BigDecimal.valueOf(600.23));
        collTrendsList.add(collTrend);
        collectionIndexDetails.setCollTrends(collTrendsList);
    }

    public ConsolidatedCollDetails getConsolidatedCollDetails() {
        ConsolidatedCollDetails consolidatedData = new ConsolidatedCollDetails();
        consolidatedData.setCytdColl(BigDecimal.valueOf(50.95));
        consolidatedData.setTotalDmd(BigDecimal.valueOf(194.93));
        consolidatedData.setLytdColl(BigDecimal.valueOf(45.71));
        return consolidatedData;
    }
}

