/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.dcb.bean.ChequePayment;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.FloorDetails;
import org.egov.ptis.domain.model.NewPropertyDetails;
import org.egov.ptis.domain.model.ViewPropertyDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.restapi.model.AmenitiesDetails;
import org.egov.restapi.model.AssessmentsDetails;
import org.egov.restapi.model.ConstructionTypeDetails;
import org.egov.restapi.model.CreatePropertyDetails;
import org.egov.restapi.model.SurroundingBoundaryDetails;
import org.egov.restapi.model.VacantLandDetails;
import org.egov.restapi.util.JsonConvertor;
import org.egov.restapi.util.ValidationUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UpdateAssessmentController {
    @Autowired
    private ValidationUtil validationUtil;
    @Autowired
    private PropertyExternalService propertyExternalService;

    @RequestMapping(value={"/property/updateProperty"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String updateProperty(@RequestBody String createPropertyDetails) throws IOException, ParseException {
        String responseJson;
        ApplicationThreadLocals.setUserId((Long)2L);
        CreatePropertyDetails createPropDetails = (CreatePropertyDetails)this.getObjectFromJSONRequest(createPropertyDetails, CreatePropertyDetails.class);
        ErrorDetails errorDetails = this.validationUtil.validateCreateRequest(createPropDetails, "modify");
        if (errorDetails != null) {
            responseJson = JsonConvertor.convert((Object)errorDetails);
        } else {
            ViewPropertyDetails viewPropertyDetails = this.setRequestParameters(createPropDetails);
            NewPropertyDetails newPropertyDetails = this.propertyExternalService.updateProperty(viewPropertyDetails);
            responseJson = JsonConvertor.convert((Object)newPropertyDetails);
        }
        return responseJson;
    }

    public ViewPropertyDetails setRequestParameters(CreatePropertyDetails createPropDetails) {
        ConstructionTypeDetails constructionTypeDetails;
        ViewPropertyDetails viewPropertyDetails = new ViewPropertyDetails();
        viewPropertyDetails.setAssessmentNumber(createPropDetails.getAssessmentNo());
        viewPropertyDetails.setPropertyTypeMaster(createPropDetails.getPropertyTypeMasterCode());
        viewPropertyDetails.setCategory(createPropDetails.getCategoryCode());
        AssessmentsDetails assessmentDetails = createPropDetails.getAssessmentDetails();
        viewPropertyDetails.setMutationReason(assessmentDetails.getMutationReasonCode());
        viewPropertyDetails.setExtentOfSite(assessmentDetails.getExtentOfSite());
        viewPropertyDetails.setIsExtentAppurtenantLand(assessmentDetails.getIsExtentAppurtenantLand());
        viewPropertyDetails.setOccupancyCertificationNo(assessmentDetails.getOccupancyCertificationNo());
        viewPropertyDetails.setExtentAppartenauntLand(assessmentDetails.getExtentAppartenauntLand());
        AmenitiesDetails amenities = createPropDetails.getAmenitiesDetails();
        if (amenities != null) {
            viewPropertyDetails.setHasLift(amenities.hasLift());
            viewPropertyDetails.setHasToilet(amenities.hasToilet());
            viewPropertyDetails.setHasWaterTap(amenities.hasWaterTap());
            viewPropertyDetails.setHasElectricity(amenities.hasElectricity());
            viewPropertyDetails.setHasAttachedBathroom(amenities.hasAttachedBathroom());
            viewPropertyDetails.setHasWaterHarvesting(amenities.hasWaterHarvesting());
            viewPropertyDetails.setHasCableConnection(amenities.hasCableConnection());
        }
        if ((constructionTypeDetails = createPropDetails.getConstructionTypeDetails()) != null) {
            viewPropertyDetails.setFloorType(constructionTypeDetails.getFloorTypeId());
            viewPropertyDetails.setRoofType(constructionTypeDetails.getRoofTypeId());
            viewPropertyDetails.setWallType(constructionTypeDetails.getWallTypeId());
            viewPropertyDetails.setWoodType(constructionTypeDetails.getWoodTypeId());
        }
        if (createPropDetails.getPropertyTypeMasterCode().equalsIgnoreCase("VAC_LAND")) {
            VacantLandDetails vacantLandDetails = createPropDetails.getVacantLandDetails();
            viewPropertyDetails.setSurveyNumber(vacantLandDetails.getSurveyNumber());
            viewPropertyDetails.setPattaNumber(vacantLandDetails.getPattaNumber());
            viewPropertyDetails.setVacantLandArea(vacantLandDetails.getVacantLandArea());
            viewPropertyDetails.setMarketValue(vacantLandDetails.getMarketValue());
            viewPropertyDetails.setCurrentCapitalValue(vacantLandDetails.getCurrentCapitalValue());
            viewPropertyDetails.setEffectiveDate(vacantLandDetails.getEffectiveDate());
            SurroundingBoundaryDetails surroundingBoundaryDetails = createPropDetails.getSurroundingBoundaryDetails();
            viewPropertyDetails.setNorthBoundary(surroundingBoundaryDetails.getNorthBoundary());
            viewPropertyDetails.setSouthBoundary(surroundingBoundaryDetails.getSouthBoundary());
            viewPropertyDetails.setEastBoundary(surroundingBoundaryDetails.getEastBoundary());
            viewPropertyDetails.setWestBoundary(surroundingBoundaryDetails.getWestBoundary());
        } else {
            viewPropertyDetails.setFloorDetails(createPropDetails.getFloorDetails());
            viewPropertyDetails.setEffectiveDate(((FloorDetails)createPropDetails.getFloorDetails().get(0)).getOccupancyDate());
        }
        return viewPropertyDetails;
    }

    private Object getObjectFromJSONRequest(String jsonString, Class cls) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        mapper.setDateFormat((DateFormat)ChequePayment.CHEQUE_DATE_FORMAT);
        return mapper.readValue(jsonString, cls);
    }
}

