/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.restapi.model.WaterConnectionInfo;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.AdditionalConnectionService;
import org.egov.wtms.application.service.ChangeOfUseService;
import org.egov.wtms.application.service.NewConnectionService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.PropertyCategory;
import org.egov.wtms.masters.entity.PropertyPipeSize;
import org.egov.wtms.masters.entity.WaterPropertyUsage;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.egov.wtms.masters.service.PipeSizeService;
import org.egov.wtms.masters.service.PropertyCategoryService;
import org.egov.wtms.masters.service.PropertyPipeSizeService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.masters.service.WaterPropertyUsageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestWaterConnectionValidationService {
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private PipeSizeService pipeSizeService;
    @Autowired
    private UsageTypeService usageTypeService;
    @Autowired
    private WaterPropertyUsageService waterPropertyUsageService;
    @Autowired
    private ChangeOfUseService changeOfUseService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private AdditionalConnectionService additionalConnectionService;
    @Autowired
    private ConnectionCategoryService connectionCategoryService;
    @Autowired
    private PropertyCategoryService propertyCategoryService;
    @Autowired
    private NewConnectionService newConnectionService;
    @Autowired
    private PropertyPipeSizeService propertyPipeSizeService;

    public ErrorDetails validateCreateRequest(WaterConnectionInfo connectionInfo) {
        ErrorDetails errorDetails = null;
        if (connectionInfo.getPropertyType() != null) {
            WaterPropertyUsage usageTypesList = this.waterPropertyUsageService.findByPropertyTypecodeAndUsageTypecode(connectionInfo.getPropertyType(), connectionInfo.getUsageType());
            if (usageTypesList == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("42");
                errorDetails.setErrorMessage("PropertyType and UsageType Combination is not valid");
                return errorDetails;
            }
            PropertyPipeSize pipeSizeList = this.propertyPipeSizeService.findByPropertyTypecodeAndPipeSizecode(connectionInfo.getPropertyType(), connectionInfo.getPipeSize());
            if (pipeSizeList == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("44");
                errorDetails.setErrorMessage("PropertyType and Pipesize Combination is not valid");
                return errorDetails;
            }
            PropertyCategory categoryTypes = this.propertyCategoryService.getAllCategoryTypesByPropertyTypeAndCategory(connectionInfo.getPropertyType(), connectionInfo.getCategory());
            if (categoryTypes == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("49");
                errorDetails.setErrorMessage("PropertyType and Category Combination is not valid");
                return errorDetails;
            }
        }
        return errorDetails;
    }

    public ErrorDetails validatePropertyID(String propertyid) throws IOException {
        ErrorDetails errorDetails = null;
        String errorMessage = this.newConnectionService.checkValidPropertyAssessmentNumber(propertyid);
        if (errorMessage != null && !errorMessage.equals("")) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("46");
            errorDetails.setErrorMessage("Provided assessmentNumber is not Valid");
        }
        return errorDetails;
    }

    public ErrorDetails validateWaterConnectionDetails(WaterConnectionInfo connectionInfo) throws IOException {
        String responseMessagedet;
        String responseMessage = "";
        ErrorDetails errorDetails = null;
        responseMessage = this.newConnectionService.checkValidPropertyAssessmentNumber(connectionInfo.getPropertyID());
        if (responseMessage.isEmpty() && (responseMessagedet = this.newConnectionService.checkConnectionPresentForProperty(connectionInfo.getPropertyID())) != "" && responseMessagedet != null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorMessage("Provided assessmentNumber has already connection");
            errorDetails.setErrorCode("47");
        }
        return errorDetails;
    }

    public ErrorDetails validateAdditionalWaterConnectionDetails(WaterConnectionInfo connectionInfo) throws IOException {
        String responseMessage = "";
        ErrorDetails errorDetails = null;
        WaterConnection connection = this.waterConnectionService.findByConsumerCode(connectionInfo.getConsumerCode());
        WaterConnectionDetails parentConnectionDetails = this.waterConnectionDetailsService.getParentConnectionDetails(connection.getPropertyIdentifier(), ConnectionStatus.ACTIVE);
        responseMessage = this.additionalConnectionService.validateAdditionalConnection(parentConnectionDetails);
        if (responseMessage != "" && responseMessage != null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorMessage("Either ConsumerCode is not valid or Due is present");
            errorDetails.setErrorCode("50");
        }
        return errorDetails;
    }

    public ErrorDetails validateChangOfUsageWaterConnectionDetails(WaterConnectionInfo connectionInfo) throws IOException {
        String responseMessage = "";
        ErrorDetails errorDetails = null;
        WaterConnectionDetails connectionUnderChange = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(connectionInfo.getConsumerCode(), ConnectionStatus.ACTIVE);
        responseMessage = this.changeOfUseService.validateChangeOfUseConnection(connectionUnderChange);
        if (responseMessage != "" && responseMessage != null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorMessage("Either ConsumerCode is not valid or Due is present");
            errorDetails.setErrorCode("50");
        }
        return errorDetails;
    }

    public ErrorDetails validateCombinationOfChangOfUsage(WaterConnectionInfo connectionInfo) throws IOException {
        String responseMessage = "";
        ErrorDetails errorDetails = null;
        WaterConnectionDetails connectionUnderChange = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(connectionInfo.getConsumerCode(), ConnectionStatus.ACTIVE);
        if (connectionUnderChange.getCategory().getCode().equals(connectionInfo.getCategory()) && connectionUnderChange.getUsageType().getCode().equals(connectionInfo.getUsageType()) && connectionUnderChange.getPropertyType().getCode().equals(connectionInfo.getPropertyType()) && connectionUnderChange.getPipeSize().getCode().equals(connectionInfo.getPipeSize()) && connectionUnderChange.getConnectionType().name().equals(connectionInfo.getConnectionType())) {
            responseMessage = "Please modify at least one mandatory field";
        }
        if (responseMessage != "" && responseMessage != null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorMessage("Either ConsumerCode is not valid or Due is present");
            errorDetails.setErrorCode(responseMessage);
        }
        return errorDetails;
    }
}

