/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.log4j.Logger;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.PropertyTaxDetails;
import org.egov.ptis.domain.model.RestPropertyTaxDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.restapi.util.JsonConvertor;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.application.service.collection.WaterTaxExternalService;
import org.egov.wtms.masters.entity.PayWaterTaxDetails;
import org.egov.wtms.masters.entity.WaterConnectionRequestDetails;
import org.egov.wtms.masters.entity.WaterReceiptDetails;
import org.egov.wtms.masters.entity.WaterTaxDetails;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestWaterConnectionCollection {
    private static final Logger LOG = Logger.getLogger(RestWaterConnectionCollection.class);
    @Autowired
    private WaterTaxExternalService waterTaxExternalService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private PropertyExternalService propertyExternalService;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;

    @RequestMapping(value={"/watercharges/paywatertax"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String payWaterTax(@Valid @RequestBody PayWaterTaxDetails payWaterTaxDetails, HttpServletRequest request) {
        WaterReceiptDetails waterReceiptDetails = null;
        try {
            ErrorDetails errorDetails = this.validatePaymentDetails(payWaterTaxDetails);
            if (null != errorDetails) {
                return JsonConvertor.convert((Object)errorDetails);
            }
            payWaterTaxDetails.setSource(request.getSession().getAttribute("source") != null ? request.getSession().getAttribute("source").toString() : "");
            waterReceiptDetails = this.waterTaxExternalService.payWaterTax(payWaterTaxDetails);
        }
        catch (ValidationException e) {
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            List errors = e.getErrors();
            for (ValidationError ve : errors) {
                ErrorDetails er = new ErrorDetails();
                er.setErrorCode(ve.getKey());
                er.setErrorMessage(ve.getMessage());
                errorList.add(er);
            }
            JsonConvertor.convert(errorList);
        }
        catch (Exception e) {
            ArrayList<ErrorDetails> errorList = new ArrayList<ErrorDetails>(0);
            ErrorDetails er = new ErrorDetails();
            er.setErrorCode(e.getMessage());
            er.setErrorMessage(e.getMessage());
            errorList.add(er);
            JsonConvertor.convert(errorList);
        }
        return JsonConvertor.convert((Object)waterReceiptDetails);
    }

    @RequestMapping(value={"/watercharges/getwatertaxdetails"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getWaterTaxDetailsByAppLicationOrConsumerNumber(@Valid @RequestBody PayWaterTaxDetails payWaterTaxDetails) throws IOException, BindException {
        ErrorDetails errorDetails = this.validateConsumerAndApplicationNumber(payWaterTaxDetails);
        if (null != errorDetails) {
            return JsonConvertor.convert((Object)errorDetails);
        }
        WaterTaxDetails waterTaxDetails = this.waterTaxExternalService.getWaterTaxDemandDet(payWaterTaxDetails);
        return JsonConvertor.convert((Object)this.getWaterTaxDetails(waterTaxDetails));
    }

    @RequestMapping(value={"/watercharges/getwatertaxdetailsByOwnerDetails"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String getWaterTaxDetailsByAppLicationOrConsumerNumberByOwnerDetails(@Valid @RequestBody WaterConnectionRequestDetails waterConnectionRequestDetails) throws IOException, BindException {
        ArrayList<WaterTaxDetails> waterTaxDetailsList = new ArrayList<WaterTaxDetails>();
        ErrorDetails errorDetails = null;
        if (!waterConnectionRequestDetails.getConsumerNo().isEmpty()) {
            errorDetails = this.validateConsumerNumber(waterConnectionRequestDetails.getConsumerNo());
        }
        if (!waterConnectionRequestDetails.getAssessmentNo().isEmpty()) {
            errorDetails = this.validateAssessmentNumber(waterConnectionRequestDetails.getAssessmentNo());
        }
        if (null != errorDetails) {
            WaterTaxDetails watertaxDetails = new WaterTaxDetails();
            watertaxDetails.setErrorDetails(errorDetails);
            waterTaxDetailsList.add(watertaxDetails);
            return JsonConvertor.convert(waterTaxDetailsList);
        }
        List propertyTaxDetailsList = new ArrayList();
        String assessmentNo = "";
        Boolean consumerExists = false;
        Boolean ownerdetailsnotexists = false;
        waterConnectionRequestDetails.setAssessmentNo(waterConnectionRequestDetails.getAssessmentNo() == null ? assessmentNo : waterConnectionRequestDetails.getAssessmentNo());
        if (!waterConnectionRequestDetails.getAssessmentNo().isEmpty() && !waterConnectionRequestDetails.getConsumerNo().isEmpty()) {
            ownerdetailsnotexists = true;
            List waterconnectionList = this.waterConnectionService.findByPropertyIdentifier(waterConnectionRequestDetails.getAssessmentNo());
            for (WaterConnection waterconnection : waterconnectionList) {
                if (!waterconnection.getConsumerCode().equalsIgnoreCase(waterConnectionRequestDetails.getConsumerNo())) continue;
                consumerExists = true;
                ownerdetailsnotexists = false;
                break;
            }
        } else if (waterConnectionRequestDetails.getAssessmentNo().isEmpty() && !waterConnectionRequestDetails.getConsumerNo().isEmpty()) {
            consumerExists = true;
            ownerdetailsnotexists = false;
        } else {
            assessmentNo = waterConnectionRequestDetails.getAssessmentNo();
        }
        if (!consumerExists.booleanValue() && ownerdetailsnotexists.booleanValue()) {
            return JsonConvertor.convert((Object)this.isEmptyWaterTaxDetails());
        }
        if (!consumerExists.booleanValue() && ((propertyTaxDetailsList = this.propertyExternalService.getPropertyTaxDetails(assessmentNo, waterConnectionRequestDetails.getOwnerName(), waterConnectionRequestDetails.getMobileNo(), null, null)) == null || propertyTaxDetailsList.isEmpty())) {
            return JsonConvertor.convert((Object)this.isEmptyWaterTaxDetails());
        }
        ArrayList<String> consumerCodesList = new ArrayList<String>();
        if (consumerExists.booleanValue() && !ownerdetailsnotexists.booleanValue()) {
            consumerCodesList.add(waterConnectionRequestDetails.getConsumerNo());
        } else {
            for (PropertyTaxDetails propertyTaxDetails : propertyTaxDetailsList) {
                List waterConnectionList = this.waterConnectionService.findByPropertyIdentifier(propertyTaxDetails.getAssessmentNo());
                for (WaterConnection waterconnection : waterConnectionList) {
                    consumerCodesList.add(waterconnection.getConsumerCode());
                }
            }
        }
        if (consumerCodesList.size() == 0 || consumerCodesList.size() > 100) {
            return JsonConvertor.convert((Object)this.isEmptyWaterTaxDetails());
        }
        for (String consumerCode : consumerCodesList) {
            WaterTaxDetails watertaxdetails = this.waterTaxExternalService.getWaterTaxDemandDetByConsumerCode(consumerCode);
            waterTaxDetailsList.add(this.getWaterTaxDetails(watertaxdetails));
            if (watertaxdetails.getErrorDetails() != null) continue;
            ErrorDetails errordetails = new ErrorDetails();
            errordetails.setErrorCode("WCMS-REST-0");
            errordetails.setErrorMessage("SUCCESS");
            watertaxdetails.setErrorDetails(errorDetails);
        }
        return JsonConvertor.convert(waterTaxDetailsList);
    }

    public ErrorDetails validatePaymentDetails(PayWaterTaxDetails payWaterTaxDetails) {
        BillReceiptInfo billReceipt;
        WaterConnectionDetails waterConnDetailsObj = null;
        ErrorDetails errorDetails = this.validateConsumerAndApplicationNumber(payWaterTaxDetails);
        if (payWaterTaxDetails.getApplicaionNumber() != null && !"".equals(payWaterTaxDetails.getApplicaionNumber())) {
            waterConnDetailsObj = this.waterConnectionDetailsService.findByApplicationNumber(payWaterTaxDetails.getApplicaionNumber());
        } else if (payWaterTaxDetails.getConsumerNo() != null) {
            waterConnDetailsObj = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(payWaterTaxDetails.getConsumerNo(), ConnectionStatus.ACTIVE);
        }
        if (waterConnDetailsObj == null) {
            waterConnDetailsObj = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(payWaterTaxDetails.getConsumerNo(), ConnectionStatus.INACTIVE);
            if (waterConnDetailsObj != null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("WCMS-REST-14");
                errorDetails.setErrorMessage("Consumer number is InActive");
            } else {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("WCMS-REST-8");
                errorDetails.setErrorMessage("Either ConsumerCode is not valid or ApplicationNumber not valid");
            }
        }
        if (waterConnDetailsObj != null && waterConnDetailsObj.getConnectionType().equals((Object)ConnectionType.NON_METERED)) {
            BigDecimal totalAmountDue = this.waterConnectionDetailsService.getTotalAmount(waterConnDetailsObj);
            LOG.info((Object)("totalAmountDue:" + totalAmountDue));
            LOG.info((Object)("payWaterTaxDetails.getTotalAmount():" + payWaterTaxDetails.getTotalAmount()));
            LOG.info((Object)("compare " + totalAmountDue.compareTo(payWaterTaxDetails.getTotalAmount())));
            LOG.info((Object)("compare " + totalAmountDue.compareTo(payWaterTaxDetails.getTotalAmount())));
        }
        if (payWaterTaxDetails.getTransactionId() == null || "".equals(payWaterTaxDetails.getTransactionId())) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-25");
            errorDetails.setErrorMessage("Invalid Request, No transaction ID is associated");
        } else if (!(payWaterTaxDetails.getTransactionId() == null && "".equals(payWaterTaxDetails.getTransactionId()) || (billReceipt = this.waterTaxExternalService.validateTransanctionIdPresent(payWaterTaxDetails.getTransactionId())) == null)) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-26");
            errorDetails.setErrorMessage("Invalid Request, Used transaction ID is associated");
        }
        if (payWaterTaxDetails.getPaymentMode() == null || payWaterTaxDetails.getPaymentMode().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-13");
            errorDetails.setErrorMessage("Payment mode is required");
        } else if (!("CASH".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().trim()) || "CHEQUE".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().trim()))) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-14");
            errorDetails.setErrorMessage("Payment mode is invalid");
        }
        if (payWaterTaxDetails.getPaymentMode() != null && ("CHEQUE".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().trim()) || "DD".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().trim()))) {
            if (payWaterTaxDetails.getChqddNo() == null || payWaterTaxDetails.getChqddNo().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-34");
                errorDetails.setErrorMessage("Cheque/DD number is required");
            } else if (payWaterTaxDetails.getChqddDate() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-35");
                errorDetails.setErrorMessage("Cheque/DD Date is required");
            } else if (payWaterTaxDetails.getBankName() == null || payWaterTaxDetails.getBankName().trim().length() == 0) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-36");
                errorDetails.setErrorMessage("Bank Name is required");
            } else if (payWaterTaxDetails.getBranchName() == null) {
                errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("PTIS-REST-37");
                errorDetails.setErrorMessage("Branch Name  is required");
            }
        }
        return errorDetails;
    }

    private ErrorDetails validateConsumerAndApplicationNumber(PayWaterTaxDetails payWaterTaxDetails) {
        ErrorDetails errorDetails = null;
        if (payWaterTaxDetails.getConsumerNo() == null || payWaterTaxDetails.getConsumerNo().trim().length() == 0) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-12");
            errorDetails.setErrorMessage("Cosumer Code is required");
        } else if (payWaterTaxDetails.getConsumerNo().trim().length() > 0 && payWaterTaxDetails.getConsumerNo().trim().length() < 10) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-9");
            errorDetails.setErrorMessage("Consumer number length can not less than 10 digits");
        }
        if (payWaterTaxDetails.getConsumerNo() == null && payWaterTaxDetails.getApplicaionNumber() == null) {
            errorDetails.setErrorCode("WTMS-REST-13");
            errorDetails.setErrorMessage("Either Cosumer Code or Application number is required");
        } else if (payWaterTaxDetails.getApplicaionNumber() != null && payWaterTaxDetails.getApplicaionNumber().trim().length() > 0 && payWaterTaxDetails.getApplicaionNumber().trim().length() < 13) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-10");
            errorDetails.setErrorMessage("Application number length can not less than 13 digits");
        }
        WaterConnectionDetails waterConnDetailsObj = null;
        if (payWaterTaxDetails.getConsumerNo() != null) {
            waterConnDetailsObj = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(payWaterTaxDetails.getConsumerNo(), ConnectionStatus.INACTIVE);
        }
        if (waterConnDetailsObj != null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WCMS-REST-14");
            errorDetails.setErrorMessage("Consumer number is InActive");
        }
        return errorDetails;
    }

    private ErrorDetails validateConsumerNumber(String consumerCode) {
        WaterConnectionDetails waterConnDetailsObj;
        WaterConnection waterConnection;
        ErrorDetails errorDetails = null;
        if (consumerCode.trim().length() > 0 && consumerCode.trim().length() < 10) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-9");
            errorDetails.setErrorMessage("Consumer number length can not less than 10 digits");
        }
        if (!consumerCode.isEmpty() && (waterConnection = this.waterConnectionService.findByConsumerCode(consumerCode)) == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WCMS-REST-16");
            errorDetails.setErrorMessage("Entered Consumer Code doesn't exist");
        }
        if (!consumerCode.isEmpty() && (waterConnDetailsObj = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.INACTIVE)) != null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WCMS-REST-14");
            errorDetails.setErrorMessage("Consumer number is InActive");
        }
        return errorDetails;
    }

    private List<WaterTaxDetails> isEmptyWaterTaxDetails() {
        ArrayList<WaterTaxDetails> waterTaxDetailsList = new ArrayList<WaterTaxDetails>();
        WaterTaxDetails watertaxDetails = new WaterTaxDetails();
        ErrorDetails errordetails = new ErrorDetails();
        errordetails.setErrorCode("WCMS-REST-15");
        errordetails.setErrorMessage("Water Tax Details is empty or morethan 100");
        watertaxDetails.setErrorDetails(errordetails);
        waterTaxDetailsList.add(watertaxDetails);
        return waterTaxDetailsList;
    }

    private ErrorDetails validateAssessmentNumber(String assessmentNumber) {
        ErrorDetails errorDetails = null;
        if (assessmentNumber.trim().length() > 0 && assessmentNumber.trim().length() < 10) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-8");
            errorDetails.setErrorMessage("Assessment number length can not less than 10 digits");
        }
        if (!this.basicPropertyDAO.isAssessmentNoExist(assessmentNumber).booleanValue()) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("PTIS-REST-11");
            errorDetails.setErrorMessage("Assessment number not found");
        }
        return errorDetails;
    }

    private WaterTaxDetails getWaterTaxDetails(WaterTaxDetails waterTaxDetails) {
        if (waterTaxDetails.getConsumerNo() == null || "".equals(waterTaxDetails.getConsumerNo())) {
            waterTaxDetails.setConsumerNo("");
        }
        if (waterTaxDetails.getOwnerName() == null) {
            waterTaxDetails.setOwnerName("");
        }
        if (waterTaxDetails.getLocalityName() == null) {
            waterTaxDetails.setLocalityName("");
        }
        if (waterTaxDetails.getPropertyAddress() == null) {
            waterTaxDetails.setPropertyAddress("");
        }
        if (waterTaxDetails.getTaxDetails() == null) {
            RestPropertyTaxDetails ar = new RestPropertyTaxDetails();
            ArrayList<RestPropertyTaxDetails> taxDetails = new ArrayList<RestPropertyTaxDetails>(0);
            taxDetails.add(ar);
            waterTaxDetails.setTaxDetails(taxDetails);
        }
        return waterTaxDetails;
    }
}

