/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.egov.collection.integration.models.PaymentInfoSearchRequest;
import org.egov.collection.integration.models.RestReceiptInfo;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infstr.models.ServiceCategory;
import org.egov.infstr.services.PersistenceService;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.restapi.model.RestErrors;
import org.egov.restapi.model.RestResponse;
import org.egov.restapi.util.JsonConvertor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class RestPaymentReportConroller {
    private static final Logger LOGGER = Logger.getLogger(RestPaymentReportConroller.class);
    @Autowired
    private CollectionIntegrationService collectionService;
    @Autowired
    private PersistenceService<ServiceCategory, Long> serviceCategoryService;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    @Autowired
    ApplicationContext applicationContext;

    @RequestMapping(value={"/reconciliation/paymentdetails/transaction"}, method={RequestMethod.POST}, produces={"application/json"})
    public String searchPaymentByTransactionId(@RequestBody PaymentInfoSearchRequest paymentInfoSearchRequest, HttpServletRequest request) {
        paymentInfoSearchRequest.setSource(request.getSession().getAttribute("source") != null ? request.getSession().getAttribute("source").toString() : "");
        LOGGER.info(request.getSession().getAttribute("source"));
        RestResponse detailsByTransactionId = new RestResponse();
        RestErrors err = new RestErrors();
        try {
            RestReceiptInfo detailsByTransactionId2 = this.collectionService.getDetailsByTransactionId(paymentInfoSearchRequest);
            detailsByTransactionId.setStatus("EGCL-REST-SUCCESS");
            detailsByTransactionId.setAmount(detailsByTransactionId2.getAmount());
            detailsByTransactionId.setReceiptNo(detailsByTransactionId2.getReceiptNo());
            detailsByTransactionId.setReferenceNo(detailsByTransactionId2.getReferenceNo());
            detailsByTransactionId.setTransactionId(detailsByTransactionId2.getTransactionId());
            detailsByTransactionId.setPaymentPeriod(detailsByTransactionId2.getPaymentPeriod());
            detailsByTransactionId.setPaymentType(detailsByTransactionId2.getPaymentType());
            err.setErrorMessage("EGCL-REST-SUCCESS");
            err.setErrorCode("EGCL-REST-SUCCESS");
            detailsByTransactionId.getErrorDetails().add(err);
        }
        catch (Exception e) {
            detailsByTransactionId.setStatus("REST-FAILURE");
            err.setErrorMessage(e.getMessage());
            err.setErrorCode("EGCL-REST-3");
            detailsByTransactionId.getErrorDetails().add(err);
        }
        return JsonConvertor.convert((Object)detailsByTransactionId);
    }

    @RequestMapping(value={"/cancelReceipt"}, method={RequestMethod.POST}, produces={"application/json"})
    public String cancelReceipt(@RequestBody PaymentInfoSearchRequest paymentInfoSearchRequest, BindingResult errors) {
        ErrorDetails successDetail = new ErrorDetails();
        try {
            this.validateCancelReceipt(paymentInfoSearchRequest);
            if (paymentInfoSearchRequest.getReceiptNo() == null || paymentInfoSearchRequest.getReceiptNo().isEmpty()) {
                ErrorDetails errorDetails = new ErrorDetails();
                errorDetails.setErrorCode("EGCL-REST-1");
                errorDetails.setErrorMessage("receiptNumber is required");
                return JsonConvertor.convert((Object)errorDetails);
            }
            ApplicationThreadLocals.setUserId((Long)Long.valueOf("2"));
            String cancelReceipt = this.collectionService.cancelReceipt(paymentInfoSearchRequest);
            successDetail.setErrorCode("EGCL-REST-SUCCESS");
            successDetail.setErrorMessage(cancelReceipt);
        }
        catch (Exception e) {
            ErrorDetails er = new ErrorDetails();
            er.setErrorCode("REST-FAILURE");
            er.setErrorMessage(e.getMessage());
            return JsonConvertor.convert((Object)er);
        }
        return JsonConvertor.convert((Object)successDetail);
    }

    private void validateCancelReceipt(PaymentInfoSearchRequest cancelReq) {
        if (cancelReq.getTransactionId() == null || cancelReq.getTransactionId().isEmpty()) {
            throw new RuntimeException("Invalid Request, No transaction ID is associated");
        }
        if (cancelReq.getReceiptNo() == null || cancelReq.getReceiptNo().isEmpty()) {
            throw new RuntimeException("receiptNumber is required");
        }
        if (cancelReq.getUlbCode() == null || cancelReq.getUlbCode().isEmpty()) {
            throw new RuntimeException("ulbCode Required ");
        }
        if (cancelReq.getReferenceNo() == null || cancelReq.getReferenceNo().isEmpty()) {
            throw new RuntimeException("referenceNo Required ");
        }
    }

    @RequestMapping(value={"/banks"}, method={RequestMethod.GET}, produces={"application/json"})
    public String bankNames() {
        List banks = null;
        try {
            banks = this.bankHibernateDAO.findAll();
        }
        catch (Exception e) {
            ErrorDetails er = new ErrorDetails();
            er.setErrorCode(e.getMessage());
            er.setErrorMessage(e.getMessage());
            return JsonConvertor.convert((Object)er);
        }
        return JsonConvertor.convert((Object)banks);
    }

    @RequestMapping(value={"/services"}, method={RequestMethod.GET}, produces={"application/json"})
    public String services() throws JsonGenerationException, JsonMappingException, IOException {
        LinkedHashMap<String, String> serviceCategory = null;
        try {
            List services = this.serviceCategoryService.findAllByNamedQuery("ACTIVE_SERVICE_CATEGORY", new Object[0]);
            if (services != null && services.size() >= 0) {
                serviceCategory = new LinkedHashMap<String, String>();
                for (ServiceCategory scs : services) {
                    serviceCategory.put(scs.getCode(), scs.getName());
                }
            }
        }
        catch (Exception e) {
            ErrorDetails er = new ErrorDetails();
            er.setErrorCode(e.getMessage());
            er.setErrorMessage(e.getMessage());
            return JsonConvertor.convert((Object)er);
        }
        return JsonConvertor.convert(serviceCategory);
    }
}

