/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonMethod;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.egov.dcb.bean.ChequePayment;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.FloorDetails;
import org.egov.ptis.domain.model.NewPropertyDetails;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.restapi.model.AmenitiesDetails;
import org.egov.restapi.model.AssessmentsDetails;
import org.egov.restapi.model.ConstructionTypeDetails;
import org.egov.restapi.model.CorrespondenceAddressDetails;
import org.egov.restapi.model.CreatePropertyDetails;
import org.egov.restapi.model.PropertyAddressDetails;
import org.egov.restapi.model.SurroundingBoundaryDetails;
import org.egov.restapi.model.VacantLandDetails;
import org.egov.restapi.util.JsonConvertor;
import org.egov.restapi.util.ValidationUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CreateAssessmentController {
    @Autowired
    private ValidationUtil validationUtil;
    @Autowired
    private PropertyExternalService propertyExternalService;

    @RequestMapping(value={"/property/createProperty"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public String createProperty(@RequestBody String createPropertyDetails) throws IOException, ParseException {
        String responseJson;
        ApplicationThreadLocals.setUserId((Long)2L);
        CreatePropertyDetails createPropDetails = (CreatePropertyDetails)this.getObjectFromJSONRequest(createPropertyDetails, CreatePropertyDetails.class);
        ErrorDetails errorDetails = this.validationUtil.validateCreateRequest(createPropDetails, "create");
        if (errorDetails != null) {
            responseJson = JsonConvertor.convert((Object)errorDetails);
        } else {
            NewPropertyDetails newPropertyDetails;
            AssessmentsDetails assessmentsDetails = createPropDetails.getAssessmentDetails();
            PropertyAddressDetails propAddressDetails = createPropDetails.getPropertyAddressDetails();
            Boolean isCorrAddrDiff = propAddressDetails.getIsCorrAddrDiff();
            CorrespondenceAddressDetails corrAddressDetails = propAddressDetails.getCorrAddressDetails();
            String corrAddr1 = "";
            String corrAddr2 = "";
            String corrPinCode = "";
            if (corrAddressDetails != null) {
                corrAddr1 = corrAddressDetails.getCorrAddr1();
                corrAddr2 = corrAddressDetails.getCorrAddr2();
                corrPinCode = corrAddressDetails.getCorrPinCode();
            }
            List documents = null;
            if (createPropDetails.getPropertyTypeMasterCode().equalsIgnoreCase("VAC_LAND")) {
                VacantLandDetails vacantLandDetails = createPropDetails.getVacantLandDetails();
                SurroundingBoundaryDetails surroundingBoundaryDetails = createPropDetails.getSurroundingBoundaryDetails();
                newPropertyDetails = this.propertyExternalService.createNewProperty(createPropDetails.getPropertyTypeMasterCode(), createPropDetails.getCategoryCode(), null, createPropDetails.getApartmentCmplxCode(), createPropDetails.getOwnerDetails(), assessmentsDetails.getMutationReasonCode(), null, Boolean.valueOf(false), null, assessmentsDetails.getRegdDocNo(), assessmentsDetails.getRegdDocDate(), propAddressDetails.getLocalityNum(), propAddressDetails.getBlockNum(), propAddressDetails.getZoneNum(), propAddressDetails.getStreetNum(), propAddressDetails.getElectionWardNum(), propAddressDetails.getDoorNo(), propAddressDetails.getEnumerationBlockCode(), propAddressDetails.getPinCode(), isCorrAddrDiff, corrAddr1, corrAddr2, corrPinCode, Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), null, null, null, null, Collections.emptyList(), vacantLandDetails.getSurveyNumber(), vacantLandDetails.getPattaNumber(), vacantLandDetails.getVacantLandArea(), vacantLandDetails.getMarketValue(), vacantLandDetails.getCurrentCapitalValue(), vacantLandDetails.getEffectiveDate(), surroundingBoundaryDetails.getNorthBoundary(), surroundingBoundaryDetails.getSouthBoundary(), surroundingBoundaryDetails.getEastBoundary(), surroundingBoundaryDetails.getWestBoundary(), assessmentsDetails.getParentPropertyAssessmentNo(), documents);
            } else {
                AmenitiesDetails amenitiesDetails = createPropDetails.getAmenitiesDetails();
                ConstructionTypeDetails constructionTypeDetails = createPropDetails.getConstructionTypeDetails();
                List floorDetailsList = createPropDetails.getFloorDetails();
                newPropertyDetails = this.propertyExternalService.createNewProperty(createPropDetails.getPropertyTypeMasterCode(), createPropDetails.getCategoryCode(), null, createPropDetails.getApartmentCmplxCode(), createPropDetails.getOwnerDetails(), assessmentsDetails.getMutationReasonCode(), assessmentsDetails.getExtentOfSite(), assessmentsDetails.getIsExtentAppurtenantLand(), assessmentsDetails.getOccupancyCertificationNo(), assessmentsDetails.getRegdDocNo(), assessmentsDetails.getRegdDocDate(), propAddressDetails.getLocalityNum(), propAddressDetails.getBlockNum(), propAddressDetails.getZoneNum(), propAddressDetails.getStreetNum(), propAddressDetails.getElectionWardNum(), propAddressDetails.getDoorNo(), propAddressDetails.getEnumerationBlockCode(), propAddressDetails.getPinCode(), isCorrAddrDiff, corrAddr1, corrAddr2, corrPinCode, amenitiesDetails.hasLift(), amenitiesDetails.hasToilet(), amenitiesDetails.hasWaterTap(), amenitiesDetails.hasElectricity(), amenitiesDetails.hasAttachedBathroom(), amenitiesDetails.hasWaterHarvesting(), amenitiesDetails.hasCableConnection(), constructionTypeDetails.getFloorTypeId(), constructionTypeDetails.getRoofTypeId(), constructionTypeDetails.getWallTypeId(), constructionTypeDetails.getWoodTypeId(), floorDetailsList, null, null, null, null, null, ((FloorDetails)floorDetailsList.get(0)).getOccupancyDate(), null, null, null, null, assessmentsDetails.getParentPropertyAssessmentNo(), documents);
            }
            responseJson = JsonConvertor.convert((Object)newPropertyDetails);
        }
        return responseJson;
    }

    private Object getObjectFromJSONRequest(String jsonString, Class cls) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(JsonMethod.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, true);
        mapper.setDateFormat((DateFormat)ChequePayment.CHEQUE_DATE_FORMAT);
        return mapper.readValue(jsonString, cls);
    }
}

