/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.entity.Source;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.restapi.config.properties.RestAPIApplicationProperties;
import org.egov.restapi.constants.RestRedirectConstants;
import org.egov.restapi.filter.MultiReadHttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiFilter
implements Filter {
    private static final Logger LOG = Logger.getLogger(ApiFilter.class);
    private static final String SOURCE = "source";
    @Autowired
    private CityService cityService;
    @Autowired
    private RestAPIApplicationProperties restAPIApplicationProperties;

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        MultiReadHttpServletRequest multiReadRequest = new MultiReadHttpServletRequest((HttpServletRequest)servletRequest);
        if (!this.validateRequest(multiReadRequest)) {
            throw new ApplicationRuntimeException("RESTAPI.001");
        }
        String ulbCode = null;
        byte[] b = new byte[5000];
        ulbCode = servletRequest.getParameter("ulbCode");
        if (ulbCode == null) {
            JSONObject jsonObject = null;
            String jb = new String();
            try {
                ServletInputStream inputStream = multiReadRequest.getInputStream();
                inputStream.read(b);
                jb = new String(b);
            }
            catch (Exception inputStream) {
                // empty catch block
            }
            try {
                jsonObject = JSONObject.fromObject((Object)jb.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid Json");
            }
            if (jsonObject != null) {
                ulbCode = jsonObject.getString("ulbCode");
            } else {
                throw new RuntimeException("Invalid Json ULB Code is not Passed");
            }
        }
        if (StringUtils.isNotBlank((CharSequence)ulbCode)) {
            if (!ulbCode.equals(ApplicationThreadLocals.getCityCode())) {
                LOG.info((Object)"Request Reached Different city. Need to change domain details");
                String cityName = ((String)RestRedirectConstants.getCode_ulbNames().get(ulbCode)).toLowerCase();
                ApplicationThreadLocals.setTenantID((String)cityName);
                City city = this.cityService.getCityByCode(ulbCode);
                ApplicationThreadLocals.setDomainName((String)city.getDomainURL());
                ApplicationThreadLocals.setCityCode((String)ulbCode);
            } else {
                LOG.info((Object)"ULB code resolved to be same, continueing normal request flow");
            }
        } else {
            LOG.error((Object)"ULB Code missing in request");
            throw new ApplicationRuntimeException("ULB Code missing in request");
        }
        filterChain.doFilter((ServletRequest)multiReadRequest, servletResponse);
    }

    public void init(FilterConfig arg0) throws ServletException {
    }

    private boolean validateRequest(MultiReadHttpServletRequest httpServletRequest) {
        String referer = httpServletRequest.getHeader("Referer");
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("The calling request URL:referer= " + referer));
            LOG.info((Object)("Host = " + httpServletRequest.getHeader("Host")));
            LOG.info((Object)("X-Forwarded-For = " + httpServletRequest.getHeader("X-Forwarded-For")));
            LOG.info((Object)("RequestURL = " + httpServletRequest.getRequestURL()));
            LOG.info((Object)("X-RemoteHost = " + httpServletRequest.getRequest().getRemoteHost()));
        }
        List apOnlineIpAddress = this.restAPIApplicationProperties.aponlineIPAddress();
        List esevaIpAddress = this.restAPIApplicationProperties.esevaIPAddress();
        List softtechIpAddress = this.restAPIApplicationProperties.softtechIPAddress();
        List cardIpAddress = this.restAPIApplicationProperties.cardIPAddress();
        if (apOnlineIpAddress != null && referer != null) {
            for (String aponlineIp : apOnlineIpAddress) {
                if (aponlineIp.equals("") || !referer.contains(aponlineIp)) continue;
                httpServletRequest.getSession().setAttribute(SOURCE, (Object)Source.APONLINE);
                return true;
            }
        }
        if (esevaIpAddress != null && referer != null) {
            for (String esevaIp : esevaIpAddress) {
                if (esevaIp.equals("") || !referer.contains(esevaIp)) continue;
                httpServletRequest.getSession().setAttribute(SOURCE, (Object)Source.ESEVA);
                return true;
            }
        }
        if (softtechIpAddress != null && referer != null) {
            for (String Ip : softtechIpAddress) {
                if (Ip.equals("") || !referer.contains(Ip)) continue;
                httpServletRequest.getSession().setAttribute(SOURCE, (Object)Source.SOFTTECH);
                return true;
            }
        }
        if (cardIpAddress != null && referer != null) {
            for (String cardIp : cardIpAddress) {
                if (cardIp.equals("") || !referer.contains(cardIp)) continue;
                httpServletRequest.getSession().setAttribute(SOURCE, (Object)Source.CARD);
                return true;
            }
        }
        return false;
    }
}

