/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.egov.search.domain.Document;
import org.egov.search.domain.SearchResult;

public class ConnectionSearchAdaptor
implements JsonSerializer<SearchResult> {
    public JsonElement serialize(SearchResult searchResult, Type type, JsonSerializationContext jsc) {
        JsonArray jsonArray = new JsonArray();
        HashMap clausesMap = new HashMap(0);
        HashMap searchableMap = new HashMap(0);
        for (Document document : searchResult.getDocuments()) {
            JsonObject jsonObject = new JsonObject();
            clausesMap = (HashMap)document.getResource().get((Object)"clauses");
            jsonObject.addProperty("consumercode", clausesMap.get("consumercode").toString());
            jsonObject.addProperty("assessmentnumber", clausesMap.get("propertyid").toString());
            jsonObject.addProperty("applicationtype", clausesMap.get("applicationcode").toString().toLowerCase());
            jsonObject.addProperty("usagetype", clausesMap.get("usage").toString().toLowerCase());
            jsonObject.addProperty("mobilenumber", clausesMap.get("mobilenumber").toString());
            jsonObject.addProperty("zone", clausesMap.get("zone").toString());
            jsonObject.addProperty("ward", clausesMap.get("ward").toString());
            jsonObject.addProperty("totaldue", Integer.toString((Integer)clausesMap.get("totaldue")));
            jsonObject.addProperty("currentdue", Integer.toString((Integer)clausesMap.get("waterTaxDue")));
            jsonObject.addProperty("connectiontype", clausesMap.get("connectiontype").toString().toLowerCase());
            searchableMap = (HashMap)document.getResource().get((Object)"searchable");
            jsonObject.addProperty("consumername", searchableMap.get("consumername").toString());
            jsonObject.addProperty("locality", searchableMap.get("locality") != null ? searchableMap.get("locality").toString() : "");
            jsonObject.addProperty("pincode", searchableMap.get("PIN") != null ? searchableMap.get("PIN").toString() : "");
            jsonArray.add((JsonElement)jsonObject);
        }
        return jsonArray;
    }
}

