/*
 * Decompiled with CFR 0.152.
 */
package org.egov.restapi.web.rest;

import java.util.Collection;
import java.util.List;
import org.egov.infra.web.utils.WebUtils;
import org.egov.restapi.model.StateCityInfo;
import org.egov.restapi.model.dashboard.CollectionIndexDetails;
import org.egov.restapi.model.dashboard.ConsolidatedCollDetails;
import org.egov.restapi.service.DashboardService;
import org.egov.restapi.util.JsonConvertor;
import org.egov.restapi.web.rest.StateInfoHelperAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CMDashboardController {
    @Autowired
    private DashboardService dashboardService;

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"/statecityinfo"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getStateCityInformation() {
        List stateDetails = this.dashboardService.getStateCityDetails();
        String result = "{ \"data\":" + WebUtils.toJSON((Collection)stateDetails, StateCityInfo.class, StateInfoHelperAdaptor.class) + "}";
        return result;
    }

    @RequestMapping(value={"/collectionstats"}, method={RequestMethod.GET}, produces={"application/json"})
    public String getConsolidatedCollDetails() {
        ConsolidatedCollDetails consolidatedCollData = this.dashboardService.getConsolidatedCollDetails();
        return JsonConvertor.convert((Object)consolidatedCollData);
    }

    @RequestMapping(value={"/collectiondashboard"}, method={RequestMethod.POST}, produces={"application/json"})
    public String getCollectionDetails(@RequestBody String collDetailsRequest) {
        CollectionIndexDetails collectionDetails = this.dashboardService.getCollectionIndexDetails();
        return JsonConvertor.convert((Object)collectionDetails);
    }
}

